/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Cache;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.bee.osql.annotation.customizable.Json;
import org.teasoft.bee.osql.type.TypeHandler;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.TransformResultSet;
import org.teasoft.honey.osql.type.TypeHandlerRegistry;
import org.teasoft.honey.osql.util.AnnoUtil;
import org.teasoft.honey.util.StringUtils;

public class SqlLib
implements BeeSql {
    private Cache cache;
    private int cacheWorkResultSetSize;
    private static boolean showSQL = HoneyConfig.getHoneyConfig().showSQL;
    protected static boolean openFieldTypeHandler = HoneyConfig.getHoneyConfig().openFieldTypeHandler;
    private static final String INDEX1 = "_SYS[index";
    private static final String INDEX2 = "]_End ";
    private static final String INDEX3 = "]";
    private static final String INSERT_ARRAY_SQL = " insert[] SQL : ";

    public SqlLib() {
        this.cacheWorkResultSetSize = HoneyConfig.getHoneyConfig().cache_workResultSetSize;
    }

    private Connection getConn() throws SQLException {
        return HoneyContext.getConn();
    }

    public Cache getCache() {
        if (this.cache == null) {
            this.cache = BeeFactory.getHoneyFactory().getCache();
        }
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public <T> List<T> select(String sql, T entity) {
        return this.selectSomeField(sql, entity);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> selectSomeField(String sql, T entity) {
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        boolean isReg = this.updateInfoInCache(sql, "List<T>", SuidType.SELECT, entity.getClass());
        if (isReg) {
            this.initRoute(SuidType.SELECT, entity.getClass(), sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
        }
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        Object targetObj = null;
        ArrayList<Object> rsList = null;
        Hashtable<String, Field> map = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            ResultSetMetaData rmeta = rs.getMetaData();
            int columnCount = rmeta.getColumnCount();
            rsList = new ArrayList<Object>();
            map = new Hashtable<String, Field>();
            Field field = null;
            String name = null;
            boolean isFirst = true;
            while (true) {
                if (rs.next()) {
                    targetObj = entity.getClass().newInstance();
                } else {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.closeRs(rs);
                    this.clearContext(sql);
                    if (hasException) {
                        this.checkClose(pst, null);
                        this.closeConn(conn);
                    } else {
                        this.checkClose(pst, conn);
                    }
                    entity = null;
                    targetObj = null;
                    map = null;
                    this.logSelectRows(rsList.size());
                    return rsList;
                }
                for (int i = 0; i < columnCount; ++i) {
                    block33: {
                        try {
                            name = SqlLib._toFieldName(rmeta.getColumnName(i + 1), entity.getClass());
                            if (isFirst) {
                                field = entity.getClass().getDeclaredField(name);
                                map.put(name, field);
                                break block33;
                            } else {
                                field = (Field)map.get(name);
                                if (field == null) {
                                }
                            }
                        }
                        catch (NoSuchFieldException e) {}
                        continue;
                    }
                    field.setAccessible(true);
                    Object obj = null;
                    boolean isRegHandlerPriority = false;
                    try {
                        boolean processAsJson = false;
                        if (this.isJoson(field)) {
                            obj = rs.getString(i + 1);
                            TypeHandler<Json> jsonHandler = TypeHandlerRegistry.getHandler(Json.class);
                            if (jsonHandler != null) {
                                obj = this.jsonHandlerProcess(field, obj, jsonHandler);
                                processAsJson = true;
                            }
                        } else if (openFieldTypeHandler) {
                            isRegHandlerPriority = TypeHandlerRegistry.isPriorityType(field.getType());
                        }
                        if (!processAsJson) {
                            obj = rs.getObject(i + 1);
                        }
                        if (isRegHandlerPriority) {
                            obj = TypeHandlerRegistry.handlerProcess(field.getType(), obj);
                            field.set(targetObj, obj);
                            continue;
                        }
                        field.set(targetObj, obj);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Class<?> type;
                        TypeHandler<?> handler;
                        boolean alreadyProcess = false;
                        obj = this._getObjectByindex(rs, field, i + 1);
                        if (openFieldTypeHandler && (handler = TypeHandlerRegistry.getHandler(type = field.getType())) != null) {
                            try {
                                Object newObj = handler.process(type, obj);
                                field.set(targetObj, newObj);
                                alreadyProcess = true;
                            }
                            catch (Exception e2) {
                                alreadyProcess = false;
                            }
                        }
                        if (alreadyProcess) continue;
                        field.set(targetObj, obj);
                    }
                }
                rsList.add(targetObj);
                isFirst = false;
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    hasException = true;
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    hasException = true;
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.closeRs(rs);
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(pst, conn);
                }
                entity = null;
                targetObj = null;
                map = null;
                throw throwable;
            }
        }
    }

    protected boolean isJoson(Field field) {
        return AnnoUtil.isJson(field);
    }

    protected Object jsonHandlerProcess(Field field, Object obj, TypeHandler jsonHandler) {
        if (List.class.isAssignableFrom(field.getType())) {
            Object[] newOjb = new Object[]{obj, field};
            obj = jsonHandler.process(field.getType(), (Object)newOjb);
        } else {
            obj = jsonHandler.process(field.getType(), obj);
        }
        return obj;
    }

    public String selectFun(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        boolean isReg = this.updateInfoInCache(sql, "String", SuidType.SELECT, entityClass);
        if (isReg) {
            this.initRoute(SuidType.SELECT, entityClass, sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                return (String)cacheObj;
            }
        }
        String result = null;
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            if (rs.next()) {
                result = rs.getObject(1) == null ? "" : rs.getObject(1).toString();
            }
            boolean hasMore = false;
            if (rs.next()) {
                hasMore = true;
            }
            if (hasMore) {
                throw new ObjSQLException("ObjSQLException:The size of ResultSet more than 1.");
            }
            this.addInCache(sql, result, "String", SuidType.SELECT, 1);
            this.closeRs(rs);
            this.clearContext(sql);
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.closeRs(rs);
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(pst, conn);
                }
                throw throwable;
            }
        }
        return result;
    }

    public List<String[]> select(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        boolean isReg = this.updateInfoInCache(sql, "List<String[]>", SuidType.SELECT, entityClass);
        if (isReg) {
            this.initRoute(SuidType.SELECT, entityClass, sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
        }
        List<Object> list = new ArrayList();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            list = TransformResultSet.toStringsList(rs);
            this.logSelectRows(list.size());
            this.addInCache(sql, list, "List<String[]>", SuidType.SELECT, list.size());
            this.closeRs(rs);
            this.clearContext(sql);
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.closeRs(rs);
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(pst, conn);
                }
                throw throwable;
            }
        }
        return list;
    }

    public List<Map<String, Object>> selectMapList(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return Collections.emptyList();
        }
        boolean isReg = this.updateInfoInCache(sql, "List<Map<String,Object>>", SuidType.SELECT, null);
        if (isReg) {
            this.initRoute(SuidType.SELECT, null, sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
        }
        List<Object> list = new ArrayList();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            list = TransformResultSet.toMapList(rs);
            this.logSelectRows(list.size());
            this.addInCache(sql, list, "List<Map<String,Object>>", SuidType.SELECT, list.size());
            this.closeRs(rs);
            this.clearContext(sql);
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.closeRs(rs);
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(pst, conn);
                }
                throw throwable;
            }
        }
        return list;
    }

    public int modify(String sql) {
        if (sql == null || "".equals(sql)) {
            return -2;
        }
        this.initRoute(SuidType.MODIFY, null, sql);
        int num = 0;
        Connection conn = null;
        PreparedStatement pst = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            num = pst.executeUpdate();
        }
        catch (SQLException e) {
            boolean notCatch = HoneyConfig.getHoneyConfig().notCatchModifyDuplicateException;
            if (!notCatch && this.isConstraint(e)) {
                boolean notShow = HoneyConfig.getHoneyConfig().notShowModifyDuplicateException;
                if (!notShow) {
                    Logger.warn(e.getMessage());
                } else {
                    Logger.debug(e.getMessage());
                }
                int n = num;
                return n;
            }
            hasException = true;
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.clearInCache(sql, "int", SuidType.MODIFY, num);
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
        }
        Logger.logSQL(" | <--  Affected rows: ", num + "");
        return num;
    }

    public long insertAndReturnId(String sql) {
        if (sql == null || "".equals(sql)) {
            return -2L;
        }
        this.initRoute(SuidType.INSERT, null, sql);
        int num = 0;
        long returnId = -1L;
        Connection conn = null;
        PreparedStatement pst = null;
        boolean hasException = false;
        ResultSet rsKey = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            String pkName = (String)OneTimeParameter.getAttribute("_SYS_Bee_PK_Name_For_InsertAndReturnId");
            if (StringUtils.isBlank(pkName)) {
                pkName = "id";
            }
            pst = conn.prepareStatement(exe_sql, pkName.split(","));
            this.setPreparedValues(pst, sql);
            num = pst.executeUpdate();
            rsKey = pst.getGeneratedKeys();
            rsKey.next();
            returnId = rsKey.getLong(1);
            this.closeRs(rsKey);
            this.clearInCache(sql, "int", SuidType.INSERT, num);
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.closeRs(rsKey);
                this.clearInCache(sql, "int", SuidType.INSERT, num);
                if (hasException) {
                    this.checkClose(pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(pst, conn);
                }
                throw throwable;
            }
        }
        Logger.logSQL(" | <--  Affected rows: ", num + "");
        return returnId;
    }

    public String selectJson(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        Class entityClass = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        boolean isReg = this.updateInfoInCache(sql, "StringJson", SuidType.SELECT, entityClass);
        if (isReg) {
            this.initRoute(SuidType.SELECT, entityClass, sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                return (String)cacheObj;
            }
        }
        StringBuffer json = new StringBuffer("");
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        boolean hasException = false;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            json = TransformResultSet.toJson(rs, entityClass);
            this.addInCache(sql, json.toString(), "StringJson", SuidType.SELECT, -1);
            this.closeRs(rs);
            this.clearContext(sql);
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.closeRs(rs);
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(pst, null);
                    this.closeConn(conn);
                } else {
                    this.checkClose(pst, conn);
                }
                throw throwable;
            }
        }
        return json.toString();
    }

    public int batch(String[] sql) {
        if (sql == null) {
            return -1;
        }
        int batchSize = HoneyConfig.getHoneyConfig().insertBatchSize;
        return this.batch(sql, batchSize);
    }

    /*
     * Loose catch block
     */
    public int batch(String[] sql, int batchSize) {
        int total;
        block26: {
            boolean hasException;
            boolean oldAutoCommit;
            PreparedStatement pst;
            Connection conn;
            int len;
            block24: {
                if (sql == null || sql.length < 1) {
                    return -1;
                }
                if (HoneyUtil.isMysql()) {
                    return this.batchForMysql(sql, batchSize);
                }
                this.initRoute(SuidType.INSERT, null, sql[0]);
                len = sql.length;
                total = 0;
                int temp = 0;
                conn = null;
                pst = null;
                oldAutoCommit = false;
                hasException = false;
                conn = this.getConn();
                oldAutoCommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
                String exe_sql = HoneyUtil.deleteLastSemicolon(sql[0]);
                pst = conn.prepareStatement(exe_sql);
                if (len <= batchSize) {
                    total = this.batch(sql[0], 0, len, conn, pst);
                    break block24;
                }
                for (int i = 0; i < len / batchSize; ++i) {
                    temp = this.batch(sql[0], i * batchSize, (i + 1) * batchSize, conn, pst);
                    total += temp;
                    pst.clearBatch();
                    pst.clearParameters();
                }
                if (len % batchSize == 0) break block24;
                temp = this.batch(sql[0], len - len % batchSize, len, conn, pst);
                total += temp;
            }
            try {
                if (conn != null) {
                    conn.setAutoCommit(oldAutoCommit);
                }
            }
            catch (Exception e3) {
                Logger.debug(e3.getMessage());
            }
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
            break block26;
            catch (SQLException e) {
                block25: {
                    int n;
                    try {
                        hasException = true;
                        this.clearContext(sql[0], batchSize, len);
                        if (!this.isConstraint(e)) break block25;
                        Logger.warn(e.getMessage());
                        n = total;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (conn != null) {
                                conn.setAutoCommit(oldAutoCommit);
                            }
                        }
                        catch (Exception e3) {
                            Logger.debug(e3.getMessage());
                        }
                        if (hasException) {
                            this.checkClose(pst, null);
                            this.closeConn(conn);
                        } else {
                            this.checkClose(pst, conn);
                        }
                        this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
                        throw throwable;
                    }
                    try {
                        if (conn != null) {
                            conn.setAutoCommit(oldAutoCommit);
                        }
                    }
                    catch (Exception e3) {
                        Logger.debug(e3.getMessage());
                    }
                    if (hasException) {
                        this.checkClose(pst, null);
                        this.closeConn(conn);
                    } else {
                        this.checkClose(pst, conn);
                    }
                    this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
                    return n;
                }
                Logger.warn(e.getMessage());
                throw ExceptionHelper.convert(e);
            }
        }
        this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
        return total;
    }

    private int batch(String sql, int start, int end, Connection conn, PreparedStatement pst) throws SQLException {
        int a = 0;
        for (int i = start; i < end; ++i) {
            if (showSQL) {
                if (i == 0) {
                    Logger.logSQL(INSERT_ARRAY_SQL, sql);
                }
                OneTimeParameter.setAttribute("_SYS_Bee_BatchInsert", i + "");
                String sql_i = INDEX1 + i + INDEX2 + sql;
                Logger.logSQL(INSERT_ARRAY_SQL, sql_i);
            }
            this.setAndClearPreparedValues(pst, INDEX1 + i + INDEX2 + sql);
            pst.addBatch();
        }
        int[] array = pst.executeBatch();
        a = HoneyUtil.isOracle() ? pst.getUpdateCount() : this.countFromArray(array);
        conn.commit();
        Logger.logSQL(" | <-- index[" + start + "~" + (end - 1) + INDEX3 + " Affected rows: ", a + "");
        return a;
    }

    private int countFromArray(int[] array) {
        int a = 0;
        if (array == null) {
            return a;
        }
        for (int i = 0; i < array.length; ++i) {
            a += array[i];
        }
        return a;
    }

    /*
     * Loose catch block
     */
    private int batchForMysql(String[] sql, int batchSize) {
        int total;
        block25: {
            boolean hasException;
            boolean oldAutoCommit;
            PreparedStatement pst;
            Connection conn;
            int len;
            block23: {
                if (sql == null || sql.length < 1) {
                    return -1;
                }
                this.initRoute(SuidType.INSERT, null, sql[0]);
                len = sql.length;
                total = 0;
                int temp = 0;
                String placeholderValue = (String)OneTimeParameter.getAttribute("_SYS_Bee_PlaceholderValue");
                conn = null;
                pst = null;
                oldAutoCommit = false;
                hasException = false;
                conn = this.getConn();
                oldAutoCommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
                String exe_sql = HoneyUtil.deleteLastSemicolon(sql[0]);
                if (len <= batchSize) {
                    String[] batchExeSql = this.getBatchExeSql(exe_sql, len, placeholderValue);
                    pst = conn.prepareStatement(batchExeSql[0]);
                    total = this._batchForMysql(sql[0], 0, len, conn, pst, batchSize, batchExeSql[1]);
                    break block23;
                }
                String[] batchExeSql = this.getBatchExeSql(exe_sql, batchSize, placeholderValue);
                pst = conn.prepareStatement(batchExeSql[0]);
                for (int i = 0; i < len / batchSize; ++i) {
                    temp = this._batchForMysql(sql[0], i * batchSize, (i + 1) * batchSize, conn, pst, batchSize, batchExeSql[1]);
                    total += temp;
                }
                if (len % batchSize == 0) break block23;
                batchExeSql = this.getBatchExeSql(exe_sql, len % batchSize, placeholderValue);
                pst = conn.prepareStatement(batchExeSql[0]);
                temp = this._batchForMysql(sql[0], len - len % batchSize, len, conn, pst, batchSize, batchExeSql[1]);
                total += temp;
            }
            try {
                if (conn != null) {
                    conn.setAutoCommit(oldAutoCommit);
                }
            }
            catch (Exception e2) {
                Logger.debug(e2.getMessage());
            }
            if (hasException) {
                this.checkClose(pst, null);
                this.closeConn(conn);
            } else {
                this.checkClose(pst, conn);
            }
            break block25;
            catch (SQLException e) {
                block24: {
                    int n;
                    try {
                        hasException = true;
                        this.clearContextForMysql(sql[0], batchSize, len);
                        if (!this.isConstraint(e)) break block24;
                        Logger.warn(e.getMessage());
                        n = total;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (conn != null) {
                                conn.setAutoCommit(oldAutoCommit);
                            }
                        }
                        catch (Exception e2) {
                            Logger.debug(e2.getMessage());
                        }
                        if (hasException) {
                            this.checkClose(pst, null);
                            this.closeConn(conn);
                        } else {
                            this.checkClose(pst, conn);
                        }
                        this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
                        throw throwable;
                    }
                    try {
                        if (conn != null) {
                            conn.setAutoCommit(oldAutoCommit);
                        }
                    }
                    catch (Exception e2) {
                        Logger.debug(e2.getMessage());
                    }
                    if (hasException) {
                        this.checkClose(pst, null);
                        this.closeConn(conn);
                    } else {
                        this.checkClose(pst, conn);
                    }
                    this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
                    return n;
                }
                Logger.warn(e.getMessage());
                throw ExceptionHelper.convert(e);
            }
        }
        this.clearInCache(sql[0], "int[]", SuidType.INSERT, total);
        return total;
    }

    protected void clearContext(String sql_0, int batchSize, int len) {
        for (int i = 0; i < len; ++i) {
            String sql_i = INDEX1 + i + INDEX2 + sql_0;
            this.clearContext(sql_i);
        }
    }

    private void clearContextForMysql(String sql_0, int batchSize, int len) {
        this.clearContext(sql_0, batchSize, len);
        int num = (len - 1) / batchSize;
        for (int i = 0; i <= num; ++i) {
            String sqlForGetValue = sql_0 + "  [Batch:" + i + INDEX3;
            this.clearContext(sqlForGetValue);
        }
    }

    private boolean isConstraint(SQLException e) {
        String className = e.getClass().getSimpleName();
        String fullClassName = e.getClass().getName();
        return "MySQLIntegrityConstraintViolationException".equals(className) || e.getMessage().startsWith("Duplicate entry ") || e instanceof SQLIntegrityConstraintViolationException || e.getMessage().contains("ORA-00001:") || e instanceof BatchUpdateException || e.getMessage().contains("duplicate key") || e.getMessage().contains("DUPLICATE KEY") || e.getMessage().contains("primary key violation") || "org.h2.jdbc.JdbcBatchUpdateException".equals(fullClassName) || e.getMessage().contains("SQLITE_CONSTRAINT_PRIMARYKEY") || e.getMessage().contains("PRIMARY KEY constraint") || e.getMessage().contains("Duplicate entry") || e.getMessage().contains("Duplicate Entry") || e.getMessage().contains("Duplicate key") || e.getMessage().contains("Duplicate Key");
    }

    private int _batchForMysql(String sql, int start, int end, Connection conn, PreparedStatement pst, int batchSize, String batchSqlForPrint) throws SQLException {
        if (showSQL) {
            if (start == 0 || end - start != batchSize) {
                Logger.logSQL(INSERT_ARRAY_SQL, batchSqlForPrint);
            }
            for (int i = start; i < end; ++i) {
                OneTimeParameter.setAttribute("_SYS_Bee_BatchInsert", i + "");
                String sql_i = INDEX1 + i + INDEX2 + sql;
                Logger.logSQL(INSERT_ARRAY_SQL, sql_i);
            }
        }
        int a = 0;
        String sqlForGetValue = sql + "  [Batch:" + start / batchSize + INDEX3;
        this.setAndClearPreparedValues(pst, sqlForGetValue);
        a = pst.executeUpdate();
        conn.commit();
        Logger.logSQL(" | <-- [Batch:" + start / batchSize + INDEX3 + " Affected rows: ", a + "");
        return a;
    }

    private String[] getBatchExeSql(String sql0, int size, String placeholderValue) {
        StringBuffer batchSql = new StringBuffer(sql0);
        StringBuffer batchSql_forPrint = new StringBuffer(sql0);
        String[] batchExeSql = new String[2];
        for (int i = 0; i < size - 1; ++i) {
            batchSql.append(",");
            batchSql.append(placeholderValue);
            if (size > 10 && i == 1) {
                batchSql_forPrint.append(",......,");
                continue;
            }
            if (size > 10 && i == size - 2) {
                batchSql_forPrint.append(placeholderValue);
                batchSql_forPrint.append("      ");
                batchSql_forPrint.append("Total of records : ");
                batchSql_forPrint.append(size);
                continue;
            }
            if (size > 10 && i > 1) continue;
            batchSql_forPrint.append(",");
            batchSql_forPrint.append(placeholderValue);
        }
        batchExeSql[0] = batchSql.toString();
        batchExeSql[1] = batchSql_forPrint.toString();
        return batchExeSql;
    }

    protected void checkClose(Statement stmt, Connection conn) {
        HoneyContext.checkClose(stmt, conn);
    }

    private void closeRs(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void closeConn(Connection conn) {
        HoneyContext.closeConn(conn);
    }

    protected Object createObject(Class c) throws IllegalAccessException, InstantiationException {
        return c.newInstance();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> moreTableSelect(String sql, T entity) {
        if (sql == null) return Collections.emptyList();
        if ("".equals(sql.trim())) {
            return Collections.emptyList();
        }
        MoreTableStruct[] moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity);
        if (moreTableStruct == null) {
            OneTimeParameter.setTrueForKey("_SYS_Bee_MoreStruct_to_SqlLib");
            moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity);
        }
        boolean subOneIsList1 = moreTableStruct[0].subOneIsList;
        boolean subTwoIsList2 = moreTableStruct[0].subTwoIsList;
        String listFieldType = "" + subOneIsList1 + subTwoIsList2 + moreTableStruct[0].oneHasOne;
        boolean isReg = this.updateInfoInCache(sql, "List<T>" + listFieldType, SuidType.SELECT, entity.getClass());
        if (isReg) {
            this.initRoute(SuidType.SELECT, entity.getClass(), sql);
            Object cacheObj = this.getCache().get(sql);
            if (cacheObj != null) {
                this.clearContext(sql);
                List list = (List)cacheObj;
                this.logSelectRows(list.size());
                return list;
            }
        }
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        Object targetObj = null;
        ArrayList rsList = null;
        boolean hasException = false;
        int recordRow = 0;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            rsList = new ArrayList();
            Field[] field = entity.getClass().getDeclaredFields();
            int columnCount = field.length;
            boolean oneHasOne = moreTableStruct[0].oneHasOne;
            Field[] subField = new Field[2];
            String[] subUseTable = new String[2];
            String[] variableName = new String[2];
            Class[] subEntityFieldClass = new Class[2];
            for (int i = 1; i <= 2; ++i) {
                if (moreTableStruct[i] == null) continue;
                subField[i - 1] = moreTableStruct[i].subEntityField;
                variableName[i - 1] = subField[i - 1].getName();
                if (subOneIsList1 && i == 1) {
                    subEntityFieldClass[0] = moreTableStruct[1].subClass;
                } else if (subTwoIsList2 && i == 2) {
                    subEntityFieldClass[1] = moreTableStruct[2].subClass;
                } else {
                    subEntityFieldClass[i - 1] = subField[i - 1].getType();
                }
                subUseTable[i - 1] = moreTableStruct[i].useSubTableName;
            }
            Field[] fields1 = subEntityFieldClass[0].getDeclaredFields();
            Field[] fields2 = null;
            if (subField[1] != null) {
                fields2 = subEntityFieldClass[1].getDeclaredFields();
            }
            Map<String, String> dulSubFieldMap = moreTableStruct[0].subDulFieldMap;
            boolean sub1_first = true;
            boolean sub2_first = true;
            Object v1 = null;
            Object v2 = null;
            HashMap subOneMap = null;
            HashMap<String, ArrayList<Object>> subTwoMap = null;
            if (subOneIsList1) {
                subOneMap = new HashMap();
            }
            if (subTwoIsList2) {
                subTwoMap = new HashMap<String, ArrayList<Object>>();
            }
            StringBuffer checkKey = null;
            StringBuffer checkKey2ForOneHasOne = null;
            String tableName = moreTableStruct[0].tableName;
            while (true) {
                Object subObj2;
                String dulField;
                boolean isDul;
                block94: {
                    String columnName;
                    block95: {
                        block93: {
                            if (!rs.next()) break block93;
                            ++recordRow;
                            isDul = false;
                            dulField = "";
                            sub2_first = true;
                            subObj2 = null;
                            if (subField[1] == null) break block94;
                            columnName = "";
                            break block95;
                        }
                        this.addInCache(sql, rsList, "List<T>" + listFieldType, SuidType.SELECT, rsList.size());
                        this.closeRs(rs);
                        this.clearContext(sql);
                        if (hasException) {
                            this.checkClose(pst, null);
                            this.closeConn(conn);
                        } else {
                            this.checkClose(pst, conn);
                        }
                        entity = null;
                        targetObj = null;
                        if (subOneIsList1 || subTwoIsList2) {
                            Logger.logSQL(" | <--  ( select raw record rows: ", recordRow + " )");
                        }
                        this.logSelectRows(rsList.size());
                        return rsList;
                    }
                    for (int i = 0; i < fields2.length; ++i) {
                        if (HoneyUtil.isSkipField(fields2[i])) continue;
                        boolean isRegHandlerPriority2 = false;
                        if (openFieldTypeHandler) {
                            isRegHandlerPriority2 = TypeHandlerRegistry.isPriorityType(fields2[i].getType());
                        }
                        v2 = null;
                        fields2[i].setAccessible(true);
                        isDul = false;
                        dulField = "";
                        try {
                            TypeHandler<Json> jsonHandler;
                            columnName = SqlLib._toColumnName(fields2[i].getName(), subEntityFieldClass[1]);
                            if (this.isConfuseDuplicateFieldDB()) {
                                dulField = dulSubFieldMap.get(subUseTable[1] + "." + columnName);
                                if (dulField != null) {
                                    isDul = true;
                                    v2 = rs.getObject(dulField);
                                } else {
                                    v2 = rs.getObject(columnName);
                                }
                            } else {
                                v2 = rs.getObject(subUseTable[1] + "." + columnName);
                            }
                            boolean processAsJson = false;
                            if (this.isJoson(fields2[i]) && (jsonHandler = TypeHandlerRegistry.getHandler(Json.class)) != null) {
                                v2 = this.jsonHandlerProcess(fields2[i], v2, jsonHandler);
                                processAsJson = true;
                            }
                            if (!processAsJson && isRegHandlerPriority2) {
                                v2 = TypeHandlerRegistry.handlerProcess(fields2[i].getType(), v2);
                            }
                            if (v2 == null) continue;
                            if (sub2_first) {
                                subObj2 = this.createObject(subEntityFieldClass[1]);
                                sub2_first = false;
                            }
                            fields2[i].set(subObj2, v2);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            v2 = this.isConfuseDuplicateFieldDB() ? this._getObjectForMoreTable_ConfuseField(rs, fields2[i], isDul, dulField, subEntityFieldClass[1]) : this._getObjectForMoreTable_NoConfuse(rs, subUseTable[1], fields2[i], subEntityFieldClass[1]);
                            boolean alreadyProcess = false;
                            try {
                                Object newV2;
                                Class<?> type;
                                TypeHandler<?> handler;
                                if (openFieldTypeHandler && (handler = TypeHandlerRegistry.getHandler(type = fields2[i].getType())) != null && (newV2 = handler.process(type, v2)) != null) {
                                    if (sub2_first) {
                                        subObj2 = this.createObject(subEntityFieldClass[1]);
                                        sub2_first = false;
                                    }
                                    fields2[i].set(subObj2, newV2);
                                    alreadyProcess = true;
                                }
                            }
                            catch (Exception e2) {
                                alreadyProcess = false;
                            }
                            if (alreadyProcess || v2 == null) continue;
                            if (sub2_first) {
                                subObj2 = this.createObject(subEntityFieldClass[1]);
                                sub2_first = false;
                            }
                            fields2[i].set(subObj2, v2);
                            continue;
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                }
                sub1_first = true;
                Field subField2InOneHasOne = null;
                if (oneHasOne) {
                    checkKey2ForOneHasOne = new StringBuffer();
                }
                Object subObj1 = subEntityFieldClass[0].newInstance();
                for (int i = 0; i < fields1.length; ++i) {
                    if (oneHasOne ? HoneyUtil.isSkipFieldForMoreTable(fields1[i]) : HoneyUtil.isSkipField(fields1[i])) continue;
                    boolean isRegHandlerPriority1 = false;
                    if (openFieldTypeHandler) {
                        isRegHandlerPriority1 = TypeHandlerRegistry.isPriorityType(fields1[i].getType());
                    }
                    v1 = null;
                    fields1[i].setAccessible(true);
                    isDul = false;
                    dulField = "";
                    try {
                        TypeHandler<Json> jsonHandler;
                        if (oneHasOne && fields1[i] != null && fields1[i].isAnnotationPresent(JoinTable.class)) {
                            if (subField[1] == null || !fields1[i].getName().equals(variableName[1]) || subObj2 == null) continue;
                            fields1[i].setAccessible(true);
                            if (subTwoIsList2) {
                                subField2InOneHasOne = fields1[i];
                            } else {
                                fields1[i].set(subObj1, subObj2);
                            }
                            if (!sub1_first) continue;
                            sub1_first = false;
                            continue;
                        }
                        String columnName = SqlLib._toColumnName(fields1[i].getName(), subEntityFieldClass[0]);
                        if (this.isConfuseDuplicateFieldDB()) {
                            dulField = dulSubFieldMap.get(subUseTable[0] + "." + columnName);
                            if (dulField != null) {
                                isDul = true;
                                v1 = rs.getObject(dulField);
                            } else {
                                v1 = rs.getObject(columnName);
                            }
                        } else {
                            v1 = rs.getObject(subUseTable[0] + "." + columnName);
                        }
                        boolean processAsJson = false;
                        if (this.isJoson(fields1[i]) && (jsonHandler = TypeHandlerRegistry.getHandler(Json.class)) != null) {
                            v1 = this.jsonHandlerProcess(fields1[i], v1, jsonHandler);
                            processAsJson = true;
                        }
                        if (!processAsJson && isRegHandlerPriority1) {
                            v1 = TypeHandlerRegistry.handlerProcess(fields1[i].getType(), v1);
                        }
                        if (v1 != null) {
                            if (sub1_first) {
                                sub1_first = false;
                            }
                            fields1[i].set(subObj1, v1);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        v1 = this.isConfuseDuplicateFieldDB() ? this._getObjectForMoreTable_ConfuseField(rs, fields1[i], isDul, dulField, subEntityFieldClass[0]) : this._getObjectForMoreTable_NoConfuse(rs, subUseTable[0], fields1[i], subEntityFieldClass[0]);
                        boolean alreadyProcess = false;
                        try {
                            Object newV1;
                            Class<?> type;
                            TypeHandler<?> handler;
                            if (openFieldTypeHandler && (handler = TypeHandlerRegistry.getHandler(type = fields1[i].getType())) != null && (newV1 = handler.process(type, v1)) != null) {
                                if (sub1_first) {
                                    sub1_first = false;
                                }
                                fields1[i].set(subObj1, newV1);
                                alreadyProcess = true;
                            }
                        }
                        catch (Exception e2) {
                            alreadyProcess = false;
                        }
                        if (!alreadyProcess && v1 != null) {
                            if (sub1_first) {
                                sub1_first = false;
                            }
                            fields1[i].set(subObj1, v1);
                        }
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    if (!oneHasOne) continue;
                    checkKey2ForOneHasOne.append(v1);
                }
                if (sub1_first && (!oneHasOne || oneHasOne && sub2_first)) {
                    subObj1 = null;
                }
                checkKey = new StringBuffer();
                Field subOneListField = null;
                Field subTwoListField = null;
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    if (HoneyUtil.isSkipFieldForMoreTable(field[i])) continue;
                    if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                        field[i].setAccessible(true);
                        if (field[i].getName().equals(variableName[0])) {
                            if (subOneIsList1) {
                                subOneListField = field[i];
                                continue;
                            }
                            field[i].set(targetObj, subObj1);
                            continue;
                        }
                        if (oneHasOne || subField[1] == null || !field[i].getName().equals(variableName[1])) continue;
                        if (subTwoIsList2) {
                            subTwoListField = field[i];
                            continue;
                        }
                        field[i].set(targetObj, subObj2);
                        continue;
                    }
                    boolean isRegHandlerPriority = false;
                    if (openFieldTypeHandler) {
                        isRegHandlerPriority = TypeHandlerRegistry.isPriorityType(field[i].getType());
                    }
                    field[i].setAccessible(true);
                    Object v = null;
                    try {
                        TypeHandler<Json> jsonHandler;
                        if (this.isConfuseDuplicateFieldDB()) {
                            v = rs.getObject(SqlLib._toColumnName(field[i].getName(), entity.getClass()));
                        } else {
                            try {
                                v = rs.getObject(tableName + "." + SqlLib._toColumnName(field[i].getName(), entity.getClass()));
                            }
                            catch (SQLException e) {
                                v = rs.getObject(SqlLib._toColumnName(field[i].getName(), entity.getClass()));
                            }
                        }
                        boolean processAsJson = false;
                        if (this.isJoson(field[i]) && (jsonHandler = TypeHandlerRegistry.getHandler(Json.class)) != null) {
                            v = this.jsonHandlerProcess(field[i], v, jsonHandler);
                            processAsJson = true;
                        }
                        if (!processAsJson && isRegHandlerPriority) {
                            v = TypeHandlerRegistry.handlerProcess(field[i].getType(), v);
                        }
                        field[i].set(targetObj, v);
                        checkKey.append(v);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        v = this._getObjectForMoreTable(rs, tableName, field[i], entity.getClass());
                        boolean alreadyProcess = false;
                        try {
                            Class<?> type;
                            TypeHandler<?> handler;
                            if (openFieldTypeHandler && (handler = TypeHandlerRegistry.getHandler(type = field[i].getType())) != null) {
                                Object newV = handler.process(type, v);
                                field[i].set(targetObj, newV);
                                alreadyProcess = true;
                            }
                        }
                        catch (Exception e2) {
                            alreadyProcess = false;
                        }
                        if (alreadyProcess) continue;
                        field[i].set(targetObj, v);
                        continue;
                    }
                    catch (SQLException e) {
                        field[i].set(targetObj, null);
                    }
                }
                if (oneHasOne) {
                    checkKey2ForOneHasOne.insert(0, checkKey);
                }
                if (subTwoIsList2 && oneHasOne && subObj1 != null && subField2InOneHasOne != null) {
                    ArrayList<Object> subTwoList = (ArrayList<Object>)subTwoMap.get(checkKey2ForOneHasOne.toString());
                    if (subTwoList == null) {
                        subTwoList = new ArrayList<Object>();
                        subTwoList.add(subObj2);
                        subField2InOneHasOne.set(subObj1, subTwoList);
                        subTwoMap.put(checkKey2ForOneHasOne.toString(), subTwoList);
                    } else {
                        subTwoList.add(subObj2);
                    }
                }
                if (subOneIsList1 && subObj1 != null) {
                    ArrayList subOneList = (ArrayList)subOneMap.get(checkKey.toString());
                    if (subOneList == null) {
                        subOneList = new ArrayList();
                        subOneList.add(subObj1);
                        subOneListField.set(targetObj, subOneList);
                        subOneMap.put(checkKey.toString(), subOneList);
                        rsList.add(targetObj);
                        continue;
                    }
                    if (!oneHasOne) {
                        subOneList.add(subObj1);
                        continue;
                    }
                    if (subObj2 != null) continue;
                    subOneList.add(subObj1);
                    continue;
                }
                if (subTwoIsList2 && !oneHasOne && subObj2 != null) {
                    ArrayList<Object> subTwoList = (ArrayList<Object>)subTwoMap.get(checkKey.toString());
                    if (subTwoList == null) {
                        subTwoList = new ArrayList<Object>();
                        subTwoList.add(subObj2);
                        subTwoListField.set(targetObj, subTwoList);
                        subTwoMap.put(checkKey.toString(), subTwoList);
                        rsList.add(targetObj);
                        continue;
                    }
                    subTwoList.add(subObj2);
                    continue;
                }
                rsList.add(targetObj);
            }
        }
        catch (SQLException e) {
            try {
                hasException = true;
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    hasException = true;
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    hasException = true;
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.closeRs(rs);
                this.clearContext(sql);
                if (hasException) {
                    this.checkClose(pst, null);
                    this.closeConn(conn);
                    throw throwable;
                }
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
    }

    private void setPreparedValues(PreparedStatement pst, String sql) throws SQLException {
        List<PreparedValue> list = HoneyContext.justGetPreparedValue(sql);
        if (null != list && list.size() > 0) {
            this._setPreparedValues(pst, list);
        }
    }

    private void setAndClearPreparedValues(PreparedStatement pst, String sql) throws SQLException {
        List<PreparedValue> list = HoneyContext.getAndClearPreparedValue(sql);
        if (null != list && list.size() > 0) {
            this._setPreparedValues(pst, list);
        }
    }

    private void _setPreparedValues(PreparedStatement pst, List<PreparedValue> list) throws SQLException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Field f = list.get(i).getField();
            if (f != null && f.isAnnotationPresent(Json.class)) {
                HoneyUtil.setPreparedValues(pst, 26, i, list.get(i).getValue());
                continue;
            }
            int k = HoneyUtil.getJavaTypeIndex(list.get(i).getType());
            HoneyUtil.setPreparedValues(pst, k, i, list.get(i).getValue());
        }
    }

    private Object _getObjectForMoreTable(ResultSet rs, String tableName, Field field, Class entityClass) throws SQLException {
        if (this.isConfuseDuplicateFieldDB()) {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName(), entityClass));
        }
        try {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), tableName + "." + SqlLib._toColumnName(field.getName(), entityClass));
        }
        catch (SQLException e) {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName(), entityClass));
        }
    }

    private Object _getObjectForMoreTable_NoConfuse(ResultSet rs, String tableName, Field field, Class entityClass) throws SQLException {
        try {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), tableName + "." + SqlLib._toColumnName(field.getName(), entityClass));
        }
        catch (SQLException e) {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName(), entityClass));
        }
    }

    private Object _getObjectForMoreTable_ConfuseField(ResultSet rs, Field field, boolean isDul, String otherName, Class entityClass) throws SQLException {
        if (isDul) {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), otherName);
        }
        return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName(), entityClass));
    }

    private Object _getObjectByindex(ResultSet rs, Field field, int index) throws SQLException {
        return HoneyUtil.getResultObjectByIndex(rs, field.getType().getName(), index);
    }

    protected static String _toColumnName(String fieldName, Class entityClass) {
        return NameTranslateHandle.toColumnName(fieldName, entityClass);
    }

    private static String _toFieldName(String columnName, Class entityClass) {
        return NameTranslateHandle.toFieldName(columnName, entityClass);
    }

    protected void addInCache(String sql, Object rs, String returnType, SuidType suidType, int resultSetSize) {
        if (resultSetSize > this.cacheWorkResultSetSize) {
            HoneyContext.deleteCacheInfo(sql);
            return;
        }
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            this.getCache().add(sql, rs);
        }
    }

    protected boolean updateInfoInCache(String sql, String returnType, SuidType suidType, Class entityClass) {
        return HoneyContext.updateInfoInCache(sql, returnType, suidType, entityClass);
    }

    protected void clearInCache(String sql, String returnType, SuidType suidType, int affectRow) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            HoneyContext.setCacheInfo(sql, struct);
        }
        this.clearContext(sql);
        if (affectRow > 0) {
            this.getCache().clear(sql);
        }
    }

    protected void clearContext(String sql) {
        HoneyContext.clearPreparedValue(sql);
    }

    protected void initRoute(SuidType suidType, Class clazz, String sql) {
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().multiDS_enable;
        if (!enableMultiDs && !HoneyContext.useStructForLevel2()) {
            return;
        }
        if (HoneyContext.isNeedRealTimeDb() && HoneyContext.isAlreadySetRoute()) {
            return;
        }
        HoneyContext.initRoute(suidType, clazz, sql);
    }

    protected boolean isConfuseDuplicateFieldDB() {
        return HoneyUtil.isConfuseDuplicateFieldDB();
    }

    protected void logSelectRows(int size) {
        Logger.logSQL(" | <--  select rows: ", size + "");
    }
}

