/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.bee.osql.exception.BeeIllegalSQLException;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.util.StringUtils;

public class TokenUtil {
    private static final String SPACE = " ";

    private TokenUtil() {
    }

    static SqlValueWrap process(String text, String startToken, String endToken, String replaceStr) {
        int len3;
        if (StringUtils.isEmpty(text)) {
            return null;
        }
        int start = text.indexOf(startToken);
        if (start < 0) {
            return null;
        }
        SqlValueWrap wrap = new SqlValueWrap();
        StringBuffer sbf = new StringBuffer(text);
        StringBuffer value = new StringBuffer();
        int len1 = startToken.length();
        int len2 = endToken.length();
        int n = len3 = replaceStr == null ? 0 : replaceStr.length();
        while (start > -1) {
            if (start > 0 && sbf.charAt(start - 1) == '\\') {
                sbf.deleteCharAt(start - 1);
                start = sbf.indexOf(startToken, start + len1);
                continue;
            }
            int end = sbf.indexOf(endToken, start);
            if (end > 0) {
                value.append(",");
                value.append(sbf.substring(start + len1, end));
                if (replaceStr != null) {
                    sbf.replace(start, end + len2, replaceStr);
                }
            }
            if (replaceStr != null) {
                start = sbf.indexOf(startToken, start + len3);
                continue;
            }
            start = sbf.indexOf(startToken, end + len2);
        }
        if (value.length() > 0) {
            value.deleteCharAt(0);
        }
        wrap.setSql(sbf.toString());
        wrap.setValueBuffer(value);
        return wrap;
    }

    public static String processWithMap(String text, String startToken, String endToken, Map<String, String> map) {
        if (StringUtils.isEmpty(text) || map == null) {
            return text;
        }
        int start = text.indexOf(startToken);
        if (start < 0) {
            return text;
        }
        StringBuffer sbf = new StringBuffer(text);
        int len1 = startToken.length();
        int len2 = endToken.length();
        int len3 = 0;
        String key = "";
        String mapValue = null;
        while (start > -1) {
            if (start > 0 && sbf.charAt(start - 1) == '\\') {
                sbf.deleteCharAt(start - 1);
                start = sbf.indexOf(startToken, start + len1);
                continue;
            }
            int end = sbf.indexOf(endToken, start);
            if (end > 0) {
                key = sbf.substring(start + len1, end);
                if (key.endsWith("?up1")) {
                    key = key.substring(0, key.length() - 4);
                    mapValue = map.get(key);
                    mapValue = mapValue.substring(0, 1).toUpperCase() + mapValue.substring(1, mapValue.length());
                } else {
                    mapValue = map.get(key);
                }
                if (mapValue != null) {
                    sbf.replace(start, end + len2, mapValue);
                    len3 = mapValue.length();
                }
            } else {
                return sbf.toString();
            }
            start = mapValue != null ? sbf.indexOf(startToken, start + len3) : sbf.indexOf(startToken, start + len1);
            len3 = 0;
            mapValue = null;
        }
        return sbf.toString();
    }

    static SqlValueWrap process2(String text, String startToken, String endToken, String replaceStr, Map map) {
        int len3;
        if (StringUtils.isBlank(text)) {
            return null;
        }
        int start = text.indexOf(startToken);
        if (start < 0) {
            return null;
        }
        SqlValueWrap wrap = new SqlValueWrap();
        PreparedValue preparedValue = null;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        StringBuffer sbf = new StringBuffer(text.trim());
        TokenUtil.doProcessJudgeToken(sbf, map);
        start = sbf.indexOf(startToken);
        int len1 = startToken.length();
        int len2 = endToken.length();
        int len3Init = len3 = replaceStr == null ? 0 : replaceStr.length();
        int goBack = 0;
        String key = "";
        String newReplaceStr = "";
        boolean isInToken = false;
        boolean isToIsNULL = false;
        while (start > -1) {
            if (start > 0 && sbf.charAt(start - 1) == '\\') {
                sbf.deleteCharAt(start - 1);
                start = sbf.indexOf(startToken, start + len1);
                continue;
            }
            int end = sbf.indexOf(endToken, start);
            if (end > 0) {
                key = sbf.substring(start + len1, end);
                len3 = len3Init;
                isInToken = false;
                isToIsNULL = false;
                goBack = 0;
                preparedValue = new PreparedValue();
                if (key.contains("%")) {
                    Object v = TokenUtil.processPecent(key, map);
                    preparedValue.setValue(v);
                    if (v != null) {
                        preparedValue.setType(v.getClass().getName());
                    } else {
                        preparedValue.setType(Object.class.getName());
                    }
                    list.add(preparedValue);
                } else if (key.endsWith("@in")) {
                    String keyIn = key.replace("@in", "").trim();
                    Object objIn = map.get(keyIn);
                    if (objIn != null && (List.class.isAssignableFrom(objIn.getClass()) || Set.class.isAssignableFrom(objIn.getClass()))) {
                        Collection c = (Collection)objIn;
                        for (Object e : c) {
                            TokenUtil.setPreValue(list, e);
                        }
                        isInToken = true;
                        newReplaceStr = HoneyUtil.getPlaceholderValue(c.size());
                        len3 = newReplaceStr.length();
                    }
                } else if (key.endsWith("@toIsNULL1") || key.endsWith("@toIsNULL2")) {
                    String keyIsNull = key.replace("@toIsNULL1", "").replace("@toIsNULL2", "").trim();
                    Object v = map.get(keyIsNull);
                    if (v == null) {
                        isToIsNULL = true;
                        newReplaceStr = SPACE + K.isNull + SPACE;
                    } else {
                        TokenUtil.setPreValue(list, v);
                    }
                    goBack = key.endsWith("@toIsNULL1") ? -1 : -2;
                } else {
                    Object value = map.get(key);
                    TokenUtil.setPreValue(list, value);
                }
                if (isInToken || isToIsNULL) {
                    sbf.replace(start + goBack, end + len2, newReplaceStr);
                } else if (replaceStr != null) {
                    sbf.replace(start, end + len2, replaceStr);
                }
            }
            start = replaceStr != null || isInToken || isToIsNULL ? sbf.indexOf(startToken, start + len3) : sbf.indexOf(startToken, end + len2);
            len3 = 0;
        }
        wrap.setList(list);
        wrap.setSql(sbf.toString());
        return wrap;
    }

    private static void setPreValue(List<PreparedValue> list, Object value) {
        PreparedValue preparedValue = new PreparedValue();
        preparedValue.setValue(value);
        if (value != null) {
            preparedValue.setType(value.getClass().getName());
        } else {
            preparedValue.setType(Object.class.getName());
        }
        list.add(preparedValue);
    }

    private static Object processPecent(String key, Map map) {
        int len = key.length();
        String value = "";
        if (key.startsWith("%")) {
            if (key.endsWith("%")) {
                key = key.substring(1, len - 1);
                String v = (String)map.get(key);
                TokenUtil.logNullTip(v);
                value = v == null ? v : "%" + TokenUtil.escapeLikeForCustomSql(v) + "%";
            } else {
                key = key.substring(1, len);
                String v = (String)map.get(key);
                TokenUtil.logNullTip(v);
                value = v == null ? v : "%" + TokenUtil.escapeLikeForCustomSql(v);
            }
        } else if (key.endsWith("%")) {
            key = key.substring(0, len - 1);
            String v = (String)map.get(key);
            TokenUtil.logNullTip(v);
            value = v == null ? v : TokenUtil.escapeLikeForCustomSql(v) + "%";
        } else {
            value = map.get(key);
            TokenUtil.checkLike(value);
        }
        return value;
    }

    private static void checkLike(String value) {
        if ("".equals(value) || StringUtils.justLikeChar(value)) {
            throw new BeeIllegalSQLException("Like has SQL injection risk!  like '" + value + "'");
        }
    }

    private static String escapeLikeForCustomSql(String value) {
        TokenUtil.checkLike(value);
        return StringUtils.escapeLike(value);
    }

    private static void logNullTip(String v) {
        if (v == null) {
            Logger.warn("the parameter value in like is null !", (Throwable)new BeeIllegalSQLException());
        }
    }

    static String getKey(String text, String startToken, String endToken) {
        if (StringUtils.isEmpty(text)) {
            return "";
        }
        int start = text.indexOf(startToken);
        if (start < 0) {
            return "";
        }
        StringBuffer sbf = new StringBuffer(text);
        int len1 = startToken.length();
        int len2 = endToken.length();
        while (start > -1) {
            if (start > 0 && sbf.charAt(start - 1) == '\\') {
                sbf.deleteCharAt(start - 1);
                start = sbf.indexOf(startToken, start + len1);
                continue;
            }
            int end = sbf.indexOf(endToken, start);
            if (end > 0) {
                return sbf.substring(start + len1, end);
            }
            start = sbf.indexOf(startToken, end + len2);
        }
        return "";
    }

    static TokenStruct getKeyStruct(StringBuffer sbf, String startToken, String endToken) {
        if (sbf == null) {
            return null;
        }
        int start = sbf.indexOf(startToken);
        if (start < 0) {
            return null;
        }
        TokenStruct struct = new TokenStruct();
        int len1 = startToken.length();
        int len2 = endToken.length();
        while (start > -1) {
            if (start > 0 && sbf.charAt(start - 1) == '\\') {
                sbf.deleteCharAt(start - 1);
                start = sbf.indexOf(startToken, start + len1);
                continue;
            }
            int end = sbf.indexOf(endToken, start);
            if (end > 0) {
                struct.key = sbf.substring(start + len1, end);
                struct.start = start;
                struct.end = end;
                return struct;
            }
            start = sbf.indexOf(startToken, end + len2);
        }
        return null;
    }

    static void doProcessJudgeToken(StringBuffer sbf, Map map) {
        TokenUtil.processJudgeToken(sbf, "<if isNotNull>", "</if>", map);
        TokenUtil.processJudgeToken(sbf, "<if isNotBlank>", "</if>", map);
    }

    static StringBuffer processJudgeToken(StringBuffer sbf, String startToken, String endToken, Map map) {
        int len1 = startToken.length();
        int len2 = endToken.length();
        TokenStruct struct = TokenUtil.getKeyStruct(sbf, startToken, endToken);
        if (struct != null) {
            String key1 = struct.key;
            String key2 = TokenUtil.getKey(key1, "#{", "}");
            if (StringUtils.isNotBlank(key2)) {
                String key3 = key2.replace("%", "").replace("@in", "").replace("@toIsNULL1", "").replace("@toIsNULL2", "");
                Object v = map.get(key3.trim());
                if (v == null && "<if isNotNull>".equals(startToken) || v instanceof String && StringUtils.isBlank((String)v) && "<if isNotBlank>".equals(startToken)) {
                    sbf.replace(struct.start, struct.end + len2, "");
                } else {
                    sbf.replace(struct.start, struct.start + len1, "");
                    sbf.replace(struct.start + key1.length(), struct.start + key1.length() + len2, "");
                }
            }
            return TokenUtil.processJudgeToken(sbf, startToken, endToken, map);
        }
        String sql = sbf.toString().trim();
        String sql2 = sql.toLowerCase();
        if (sql2.endsWith("where")) {
            return sbf.replace(sql2.length() - 5, sbf.length(), "");
        }
        return sbf;
    }

    private static class TokenStruct {
        String key;
        int start;
        int end;

        private TokenStruct() {
        }
    }
}

