/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.util.AnnoUtil;

public class TransformResultSet {
    private TransformResultSet() {
    }

    public static StringBuffer toJson(ResultSet rs, Class entityClass) throws SQLException {
        StringBuffer json = new StringBuffer("");
        ResultSetMetaData rmeta = rs.getMetaData();
        int columnCount = rmeta.getColumnCount();
        boolean ignoreNull = HoneyConfig.getHoneyConfig().selectJson_ignoreNull;
        String temp = "";
        boolean dateWithMillisecond = HoneyConfig.getHoneyConfig().selectJson_dateWithMillisecond;
        boolean timeWithMillisecond = HoneyConfig.getHoneyConfig().selectJson_timeWithMillisecond;
        boolean timestampWithMillisecond = HoneyConfig.getHoneyConfig().selectJson_timestampWithMillisecond;
        boolean longToString = HoneyConfig.getHoneyConfig().selectJson_longToString;
        boolean isJsonString = false;
        Field currField = null;
        String fieldName = "";
        String fieldTypeName = "";
        while (rs.next()) {
            json.append(",{");
            for (int i = 1; i <= columnCount; ++i) {
                if (rs.getString(i) == null && ignoreNull) continue;
                isJsonString = false;
                fieldName = TransformResultSet._toFieldName(rmeta.getColumnLabel(i), entityClass);
                fieldTypeName = HoneyUtil.getFieldType(rmeta.getColumnTypeName(i));
                json.append("\"");
                json.append(fieldName);
                json.append("\":");
                if (rs.getString(i) != null) {
                    temp = rs.getString(i);
                    if ("JSON".equals(fieldTypeName)) {
                        isJsonString = true;
                    } else if (entityClass != null) {
                        try {
                            currField = entityClass.getDeclaredField(fieldName);
                            isJsonString = TransformResultSet.isJoson(currField);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    if (isJsonString) {
                        json.append(temp);
                    } else if ("String".equals(fieldTypeName)) {
                        json.append("\"");
                        temp = temp.replace("\\", "\\\\");
                        temp = temp.replace("\"", "\\\"");
                        json.append(temp);
                        json.append("\"");
                    } else if ("Date".equals(fieldTypeName)) {
                        if (dateWithMillisecond) {
                            json.append(rs.getDate(i).getTime());
                        } else {
                            try {
                                Long.valueOf(temp);
                                json.append(temp);
                            }
                            catch (NumberFormatException e) {
                                json.append("\"");
                                json.append(temp.replace("\"", "\\\""));
                                json.append("\"");
                            }
                        }
                    } else if ("Time".equals(fieldTypeName)) {
                        if (timeWithMillisecond) {
                            json.append(rs.getTime(i).getTime());
                        } else {
                            try {
                                Long.valueOf(temp);
                                json.append(temp);
                            }
                            catch (NumberFormatException e) {
                                json.append("\"");
                                json.append(temp.replace("\"", "\\\""));
                                json.append("\"");
                            }
                        }
                    } else if ("Timestamp".equals(fieldTypeName)) {
                        if (timestampWithMillisecond) {
                            json.append(rs.getTimestamp(i).getTime());
                        } else {
                            try {
                                Long.valueOf(temp);
                                json.append(temp);
                            }
                            catch (NumberFormatException e) {
                                json.append("\"");
                                json.append(temp.replace("\"", "\\\""));
                                json.append("\"");
                            }
                        }
                    } else if (longToString && "Long".equals(fieldTypeName)) {
                        json.append("\"");
                        json.append(rs.getString(i));
                        json.append("\"");
                    } else {
                        json.append(rs.getString(i));
                    }
                } else {
                    json.append(rs.getString(i));
                }
                if (i == columnCount) continue;
                json.append(",");
            }
            if (json.toString().endsWith(",")) {
                json.deleteCharAt(json.length() - 1);
            }
            json.append("}");
        }
        if (json.length() > 0) {
            json.deleteCharAt(0);
        }
        json.insert(0, "[");
        json.append("]");
        return json;
    }

    private static String _toFieldName(String columnName, Class entityClass) {
        return NameTranslateHandle.toFieldName(columnName, entityClass);
    }

    private static boolean isJoson(Field field) {
        return AnnoUtil.isJson(field);
    }

    public static List<String[]> toStringsList(ResultSet rs) throws SQLException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        ResultSetMetaData rmeta = rs.getMetaData();
        int columnCount = rmeta.getColumnCount();
        boolean nullToEmptyString = HoneyConfig.getHoneyConfig().returnStringList_nullToEmptyString;
        String[] str = null;
        while (rs.next()) {
            str = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                str[i] = nullToEmptyString && rs.getString(i + 1) == null ? "" : rs.getString(i + 1);
            }
            list.add(str);
        }
        return list;
    }

    public static List<Map<String, Object>> toMapList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData rmeta = rs.getMetaData();
        int columnCount = rmeta.getColumnCount();
        LinkedHashMap<String, Object> rowMap = null;
        while (rs.next()) {
            rowMap = new LinkedHashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                rowMap.put(TransformResultSet._toFieldName(rmeta.getColumnLabel(i), null), rs.getObject(i));
            }
            list.add(rowMap);
        }
        return list;
    }
}

