/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.dialect.sqlserver;

import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.dialect.sqlserver.AbstractSqlServerFeature;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerPagingStruct;
import org.teasoft.honey.util.StringUtils;

public class SqlServerFeature
extends AbstractSqlServerFeature
implements DbFeature {
    private static String part1 = "select * from (select top ? row_number() over (order by id) as rownum,";
    private static String part2 = ") as table_ where table_.rownum >=?";
    private static String part1_1 = "select * from (";
    private static String part1_2 = " top ? row_number() over (order by id) as rownum,";

    public SqlServerFeature() {
        if (HoneyUtil.isSqlKeyWordUpper()) {
            SqlServerFeature.setStr();
        }
    }

    private static void setStr() {
        part1 = part1.toUpperCase();
        part2 = part2.toUpperCase();
        part1_1 = part1_1.toUpperCase();
        part1_2 = part1_2.toUpperCase();
    }

    public String toPageSql(String sql, int start, int size) {
        if (start <= 1) {
            return this.toPageSql(sql, size);
        }
        sql = HoneyUtil.deleteLastSemicolon(sql);
        sql = sql.trim();
        String sql2 = "";
        int index2 = sql.toLowerCase().indexOf("select distinct");
        String processSql = "";
        processSql = index2 < 0 ? part1 : part1_2;
        SqlServerPagingStruct struct = HoneyContext.getAndRemoveSqlServerPagingStruct(sql);
        if (struct != null) {
            boolean justChangePk = struct.isJustChangeOrderColumn();
            String pkName = struct.getOrderColumn();
            String orderType = struct.getOrderType().getName();
            processSql = justChangePk ? this.adjustSqlServerPagingPk10(processSql, pkName, orderType) : this.adjustSqlServerPaging10(processSql, pkName, orderType);
        }
        sql2 = index2 < 0 ? processSql.replace("?", start + size - 1 + "") + sql.substring(6) + part2.replace("?", start + "") : part1_1 + sql.substring(0, index2 + 15) + processSql.replace("?", start + size - 1 + "") + sql.substring(index2 + 15, sql.length()) + part2.replace("?", start + "");
        return sql2;
    }

    private String adjustSqlServerPagingPk10(String processSql, String pkName, String orderType) {
        String replaceStr = " over (order by id) ";
        String ID = "id";
        if (HoneyUtil.isSqlKeyWordUpper()) {
            replaceStr = replaceStr.toUpperCase();
            ID = ID.toUpperCase();
            if ("desc".equals(orderType)) {
                orderType = "DESC";
            }
        }
        if (StringUtils.isBlank(pkName)) {
            return processSql;
        }
        String newStr = pkName;
        if ("desc".equalsIgnoreCase(orderType)) {
            newStr = pkName + " " + orderType;
        }
        return processSql.replace(replaceStr, replaceStr.replace(ID, newStr));
    }

    private String adjustSqlServerPaging10(String processSql, String pkName, String orderType) {
        String replaceStr = " over (order by id) ";
        String ID = "id";
        String newStr = replaceStr;
        boolean orign = true;
        if (HoneyUtil.isSqlKeyWordUpper()) {
            replaceStr = replaceStr.toUpperCase();
            ID = ID.toUpperCase();
            if ("desc".equals(orderType)) {
                orderType = "DESC";
            }
        }
        if ("desc".equalsIgnoreCase(orderType)) {
            newStr = newStr.replace(ID, ID + " " + orderType);
            orign = false;
        }
        if (StringUtils.isNotBlank(pkName)) {
            newStr = newStr.replace(ID, pkName);
            orign = false;
        }
        if (orign) {
            return processSql;
        }
        return processSql.replace(replaceStr, newStr);
    }
}

