/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.interccept.annotation;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Date;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.Createtime;
import org.teasoft.bee.osql.annotation.Datetime;
import org.teasoft.bee.osql.annotation.Updatetime;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.util.DateUtil;
import org.teasoft.honey.util.StringUtils;

public class DatetimeHandler {
    private DatetimeHandler() {
    }

    public static void process(Field field, Object entity, SuidType suidType) {
        Datetime datetime = field.getAnnotation(Datetime.class);
        String formatter = datetime.formatter();
        boolean override = datetime.override();
        SuidType setSuidType = datetime.suidType();
        DatetimeHandler.process(field, entity, suidType, formatter, override, setSuidType);
    }

    public static void processCreatetime(Field field, Object entity, SuidType suidType) {
        Createtime datetime = field.getAnnotation(Createtime.class);
        String formatter = datetime.formatter();
        boolean override = datetime.override();
        SuidType setSuidType = SuidType.INSERT;
        DatetimeHandler.process(field, entity, suidType, formatter, override, setSuidType);
    }

    public static void processUpdatetime(Field field, Object entity, SuidType suidType) {
        Updatetime datetime = field.getAnnotation(Updatetime.class);
        String formatter = datetime.formatter();
        boolean override = datetime.override();
        SuidType setSuidType = SuidType.UPDATE;
        DatetimeHandler.process(field, entity, suidType, formatter, override, setSuidType);
    }

    private static void process(Field field, Object entity, SuidType sqlSuidType, String formatter, boolean override, SuidType setSuidType) {
        try {
            if (setSuidType != sqlSuidType && setSuidType != SuidType.SUID && (setSuidType != SuidType.MODIFY || sqlSuidType != SuidType.UPDATE && sqlSuidType != SuidType.INSERT && sqlSuidType != SuidType.DELETE)) {
                return;
            }
            field.setAccessible(true);
            if (!override && field.get(entity) != null) {
                return;
            }
            if (field.getType().equals(Timestamp.class)) {
                field.set(entity, DateUtil.currentTimestamp());
            } else if (field.getType().equals(java.sql.Date.class)) {
                field.set(entity, DateUtil.currentSqlDate());
            } else if (field.getType().equals(Date.class)) {
                field.set(entity, new Date());
            } else if (StringUtils.isNotBlank(formatter)) {
                field.set(entity, DateUtil.currentDate(formatter));
            } else {
                field.set(entity, DateUtil.currentDate());
            }
        }
        catch (Exception e) {
            Logger.warn(e.getMessage(), e);
        }
    }
}

