/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.logging;

import java.util.HashMap;
import java.util.Map;
import org.teasoft.bee.logging.Log;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.util.DateUtil;

public class SystemLogger
implements Log {
    private static final String TRACE = "TRACE";
    private static final String DEBUG = "DEBUG";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";
    private static final String SPACE = " ";
    private static final String LEFT = "[";
    private static final String RIGHT = "]";
    private static boolean donotPrintCurrentDate = HoneyConfig.getHoneyConfig().showSql_donotPrintCurrentDate;
    private static boolean donotPrintLevel = HoneyConfig.getHoneyConfig().logDonotPrintLevel;
    private String className = null;
    private static Map<String, Integer> levelMap;
    private static String systemLoggerLevel;
    private static int level;
    private static final int DEBUG_NUM = 1;
    private static final int INFO_NUM = 2;
    private static final int WARN_NUM = 3;

    public SystemLogger() {
    }

    public SystemLogger(String className) {
        this.className = className;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        if (this.className != null) {
            this.print(TRACE, msg, this.className);
        } else {
            this.print(TRACE, msg);
        }
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        if (level > 1) {
            return;
        }
        if (this.className != null) {
            this.print(DEBUG, msg, this.className);
        } else {
            this.print(DEBUG, msg);
        }
    }

    public void debug(String msg, Throwable t) {
        if (level > 1) {
            return;
        }
        this.debug(msg);
        this._printStackTrace(t);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        if (level > 2) {
            return;
        }
        if (this.className != null) {
            this.print(INFO, msg, this.className);
        } else {
            this.print(INFO, msg);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        if (level > 3) {
            return;
        }
        if (this.className != null) {
            this.print(WARN, msg, this.className);
        } else {
            this.print(WARN, msg);
        }
    }

    public void warn(String msg, Throwable t) {
        if (level > 3) {
            return;
        }
        this.warn(msg);
        this._printStackTrace(t);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        if (this.className != null) {
            this.print(ERROR, msg, this.className);
        } else {
            this.print(ERROR, msg);
        }
    }

    public void error(String msg, Throwable t) {
        this.error(msg);
        this._printStackTrace(t);
    }

    private void _printStackTrace(Throwable t) {
        if (t != null) {
            t.printStackTrace();
        }
    }

    private void print(String level, String msg) {
        StringBuffer b = new StringBuffer();
        if (!donotPrintCurrentDate) {
            b.append(DateUtil.currentDate());
            b.append(SPACE);
        }
        if (!donotPrintLevel) {
            b.append(LEFT).append(level).append(RIGHT).append(SPACE);
        }
        b.append(msg);
        if (ERROR.equals(level) || WARN.equals(level)) {
            this.printerr(b.toString());
        } else {
            this.printout(b.toString());
        }
    }

    private void print(String level, String msg, String className) {
        StringBuffer b = new StringBuffer();
        if (!donotPrintCurrentDate) {
            b.append(DateUtil.currentDate());
            b.append(SPACE);
        }
        if (!donotPrintLevel) {
            b.append(LEFT).append(level).append(RIGHT).append(SPACE);
        }
        b.append(LEFT).append(className).append(RIGHT).append(SPACE).append(msg);
        if (ERROR.equals(level) || WARN.equals(level)) {
            this.printerr(b.toString());
        } else {
            this.printout(b.toString());
        }
    }

    private void printerr(String str) {
        System.err.println(str);
    }

    private void printout(String str) {
        System.out.println(str);
    }

    static {
        systemLoggerLevel = HoneyConfig.getHoneyConfig().systemLoggerLevel;
        levelMap = new HashMap<String, Integer>();
        levelMap.put(DEBUG, 1);
        levelMap.put(INFO, 2);
        levelMap.put(WARN, 3);
        levelMap.put(ERROR, 4);
        level = levelMap.get(systemLoggerLevel.toUpperCase());
    }
}

