/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.MapSql;
import org.teasoft.bee.osql.MapSqlKey;
import org.teasoft.bee.osql.MapSqlSetting;
import org.teasoft.bee.osql.MapSuid;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidRich;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.ObjSQL;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.util.SuidHelper;

public class ObjSQLRich
extends ObjSQL
implements SuidRich {
    private ObjToSQLRich objToSQLRich;
    private static final String SELECT_SQL = "select SQL: ";
    private static final String SELECT_JSON_SQL = "selectJson SQL: ";
    private static final String DELETE_BY_ID_SQL = "deleteById SQL: ";
    private static final String SELECT_BY_ID_SQL = "selectById SQL: ";
    private static final String UPDATE_SQL_WHERE_FIELDS = "update SQL(whereFields) :";
    private static final String UPDATE_SQL_UPDATE_FIELDS = "update SQL(updateFields) :";
    private static final String ID_IS_NULL = "in method selectById,id is null! ";
    private static final String START_GREAT_EQ_0 = "Parameter 'start' need great equal 0!";
    private static final String SIZE_GREAT_0 = "Parameter 'size' need great than 0!";
    private static final String TIP_SIZE_0 = "The size is 0, but it should be greater than 0 (>0)";

    public ObjToSQLRich getObjToSQLRich() {
        if (this.objToSQLRich == null) {
            this.objToSQLRich = BeeFactory.getHoneyFactory().getObjToSQLRich();
        }
        return this.objToSQLRich;
    }

    public void setObjToSQLRich(ObjToSQLRich objToSQLRich) {
        this.objToSQLRich = objToSQLRich;
    }

    public <T> List<T> select(T entity, int size) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return Collections.emptyList();
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, size);
        sql = this.doAfterCompleteSql(sql);
        List list = this.getBeeSql().select(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return Collections.emptyList();
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, start, size);
        sql = this.doAfterCompleteSql(sql);
        List list = this.getBeeSql().select(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, String selectField) {
        if (entity == null) {
            return null;
        }
        List list = null;
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, new String[]{selectField});
        sql = this.doAfterCompleteSql(sql);
        list = this.getBeeSql().selectSomeField(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> select(T entity, String selectFields, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return Collections.emptyList();
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields, start, size);
        sql = this.doAfterCompleteSql(sql);
        list = this.getBeeSql().selectSomeField(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFields) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectOrderBySQL(entity, orderFields);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFields, OrderType[] orderTypes) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectOrderBySQL(entity, orderFields, orderTypes);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> int insert(T[] entity) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        this.checkNull(entity);
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity);
        this._regEntityClass1(entity[0]);
        insertSql[0] = this.doAfterCompleteSql(insertSql[0]);
        HoneyUtil.revertId(entity);
        int a = this.getBeeSql().batch(insertSql);
        this.doBeforeReturn();
        return a;
    }

    private <T> void checkNull(T[] entity) {
        for (int i = 0; i < entity.length; ++i) {
            if (entity[i] != null) continue;
            throw new ObjSQLException("entity[] have null element, index: " + i);
        }
    }

    public <T> int insert(T[] entity, String excludeFields) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        this.checkNull(entity);
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity, excludeFields);
        this._regEntityClass1(entity[0]);
        insertSql[0] = this.doAfterCompleteSql(insertSql[0]);
        HoneyUtil.revertId(entity);
        int a = this.getBeeSql().batch(insertSql);
        this.doBeforeReturn();
        return a;
    }

    public <T> int insert(T[] entity, int batchSize) {
        return this.insert(entity, batchSize, "");
    }

    public <T> int insert(T[] entity, int batchSize, String excludeFields) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        this.checkNull(entity);
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        if (batchSize <= 0) {
            batchSize = 10;
        }
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity, batchSize, excludeFields);
        this._regEntityClass1(entity[0]);
        insertSql[0] = this.doAfterCompleteSql(insertSql[0]);
        HoneyUtil.revertId(entity);
        int a = this.getBeeSql().batch(insertSql, batchSize);
        this.doBeforeReturn();
        return a;
    }

    public <T> int update(T entity, String updateFields) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_UPDATE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> T selectOne(T entity) {
        if (entity == null) {
            return null;
        }
        List<T> list = this.select(entity);
        if (list == null || list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun) {
        return this.selectWithFun(entity, functionType, fieldForFun, null);
    }

    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String s = null;
        String sql = this.getObjToSQLRich().toSelectFunSQL(entity, functionType, fieldForFun, condition);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        s = this.getBeeSql().selectFun(sql);
        this.doBeforeReturn();
        return s;
    }

    public <T> int count(T entity) {
        return this.count(entity, null);
    }

    public <T> int count(T entity, Condition condition) {
        String total = this.selectWithFun(entity, FunctionType.COUNT, "*", condition);
        return total == null ? 0 : Integer.parseInt(total);
    }

    public <T> int update(T entity, String updateFields, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_UPDATE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> List<T> select(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> int update(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("update SQL: ", sql);
        int r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int insert(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        String sql = this.getObjToSQLRich().toInsertSQL(entity, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("insert SQL: ", sql);
        int r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> long insertAndReturnId(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1L;
        }
        this.doBeforePasreEntity(entity, SuidType.INSERT);
        String sql = this.getObjToSQLRich().toInsertSQL(entity, includeType);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("insert SQL: ", sql);
        return this._insertAndReturnId(entity, sql);
    }

    public <T> int delete(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.DELETE);
        String sql = this.getObjToSQLRich().toDeleteSQL(entity, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("delete SQL: ", sql);
        int r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> List<String[]> selectString(T entity) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("select SQL(return List<String[]>): ", sql);
        list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public <T> List<String[]> selectString(T entity, String ... selectFields) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public <T> List<String[]> selectString(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, condition.getIncludeType(), condition);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("select SQL(return List<String[]>): ", sql);
        list = this.getBeeSql().select(sql);
        this.doBeforeReturn();
        return list;
    }

    public <T> String selectJson(T entity) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> String selectJson(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> String selectJson(T entity, String selectField) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, new String[]{selectField});
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectJson(T entity, String selectField) SQL: ", sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> String selectJson(T entity, String selectFields, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size == 0) {
            Logger.warn(TIP_SIZE_0);
            return null;
        }
        if (size < 0) {
            throw new BeeIllegalParameterException(SIZE_GREAT_0);
        }
        if (start < 0) {
            throw new BeeIllegalParameterException(START_GREAT_EQ_0);
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields, start, size);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectJson(T entity, String selectField, int start, int size) SQL: ", sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> T selectById(T entity, Integer id) {
        if (entity == null) {
            return null;
        }
        if (id == null) {
            Logger.warn(ID_IS_NULL);
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, id);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_BY_ID_SQL, sql);
        List list = this.getBeeSql().select(sql, entity);
        return this.getIdEntity(list);
    }

    public <T> T selectById(T entity, Long id) {
        if (entity == null) {
            return null;
        }
        if (id == null) {
            Logger.warn(ID_IS_NULL);
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, id);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_BY_ID_SQL, sql);
        List list = this.getBeeSql().select(sql, entity);
        return this.getIdEntity(list);
    }

    public <T> T selectById(T entity, String id) {
        if (entity == null) {
            return null;
        }
        if (id == null) {
            Logger.warn(ID_IS_NULL);
            return null;
        }
        if (id.contains(",")) {
            throw new BeeIllegalParameterException("The parameter 'id' of method selectById does not allow to contain comma!");
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, id);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_BY_ID_SQL, sql);
        List list = this.getBeeSql().select(sql, entity);
        return this.getIdEntity(list);
    }

    public <T> List<T> selectByIds(T entity, String ids) {
        if (entity == null) {
            return null;
        }
        if (ids == null) {
            Logger.warn("in method selectByIds,ids is null! ");
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, ids);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("selectByIds SQL: ", sql);
        List list = this.getBeeSql().select(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    private <T> T getIdEntity(List<T> list) {
        if (list == null || list.size() < 1) {
            this.doBeforeReturn();
            return null;
        }
        this.doBeforeReturn(list);
        return list.get(0);
    }

    public int deleteById(Class c, Integer id) {
        if (id == null) {
            Logger.warn("in method deleteById,id is null! ");
        }
        if (c == null || id == null) {
            return 0;
        }
        this.doBeforePasreEntity(c, SuidType.DELETE);
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, id);
        this._regEntityClass2(c);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(DELETE_BY_ID_SQL, sql);
        int a = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return a;
    }

    public int deleteById(Class c, Long id) {
        if (id == null) {
            Logger.warn("in method deleteById,id is null! ");
        }
        if (c == null || id == null) {
            return 0;
        }
        this.doBeforePasreEntity(c, SuidType.DELETE);
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, id);
        this._regEntityClass2(c);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(DELETE_BY_ID_SQL, sql);
        int a = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return a;
    }

    public int deleteById(Class c, String ids) {
        if (ids == null) {
            Logger.warn("in method deleteById,ids is null! ");
        }
        if (c == null || ids == null) {
            return 0;
        }
        this.doBeforePasreEntity(c, SuidType.DELETE);
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, ids);
        this._regEntityClass2(c);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(DELETE_BY_ID_SQL, sql);
        int a = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return a;
    }

    @Deprecated
    public <T> List<T> select(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType, condition);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_SQL, sql);
        List list = this.getBeeSql().select(sql, entity);
        this.doBeforeReturn(list);
        return list;
    }

    public <T> String selectJson(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType, condition);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> String selectJson(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        this.doBeforePasreEntity(entity, SuidType.SELECT);
        String sql = this.getObjToSQLRich().toSelectSQL(entity, condition.getIncludeType(), condition);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(SELECT_JSON_SQL, sql);
        String json = this.getBeeSql().selectJson(sql);
        this.doBeforeReturn();
        return json;
    }

    public <T> int updateBy(T entity, String whereFields) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_WHERE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int updateBy(T entity, String whereFields, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields, includeType);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_WHERE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int updateBy(T entity, String whereFields, Condition condition) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields, condition);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_WHERE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int updateById(T entity, Condition condition) {
        String pkName = "";
        try {
            entity.getClass().getDeclaredField("id");
            pkName = "id";
        }
        catch (NoSuchFieldException e) {
            pkName = HoneyUtil.getPkFieldName(entity);
        }
        return this.updateBy(entity, pkName, condition);
    }

    public <T> int update(T entity, String updateFields, Condition condition) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields, condition);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL(UPDATE_SQL_UPDATE_FIELDS, sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int update(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        this.doBeforePasreEntity(entity, SuidType.UPDATE);
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, "", condition);
        this._regEntityClass1(entity);
        sql = this.doAfterCompleteSql(sql);
        Logger.logSQL("update SQL(condition) :", sql);
        r = this.getBeeSql().modify(sql);
        this.doBeforeReturn();
        return r;
    }

    public <T> int insert(List<T> entityList) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity);
    }

    public <T> int insert(List<T> entityList, int batchSize) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, batchSize);
    }

    public <T> int insert(List<T> entityList, String excludeFields) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, excludeFields);
    }

    public <T> int insert(List<T> entityList, int batchSize, String excludeFields) {
        if (entityList == null || entityList.size() < 1) {
            return -1;
        }
        T[] entity = this.toEntityArray(entityList);
        return this.insert(entity, batchSize, excludeFields);
    }

    private <T> void _regEntityClass1(T entity) {
        if (entity == null) {
            return;
        }
        HoneyContext.regEntityClass(entity.getClass());
    }

    private void _regEntityClass2(Class clazz) {
        HoneyContext.regEntityClass(clazz);
    }

    private <T> T[] toEntityArray(List<T> entityList) {
        int len = entityList.size();
        Object[] entity = new Object[len];
        for (int i = 0; i < len; ++i) {
            entity[i] = entityList.get(i);
        }
        return entity;
    }

    public SuidRich setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    public <T> boolean exist(T entity) {
        int r = this.count(entity);
        return r > 0;
    }

    public <T> int update(T oldEntity, T newEntity) {
        String newEntityFullName;
        if (oldEntity == null || newEntity == null) {
            return -1;
        }
        String oldEntityFullName = oldEntity.getClass().getName();
        if (!oldEntityFullName.equals(newEntityFullName = newEntity.getClass().getName())) {
            throw new BeeErrorGrammarException("BeeErrorGrammarException: the oldEntity and newEntity must be same type!");
        }
        this.doBeforePasreEntity(newEntity, SuidType.UPDATE);
        Map<String, Object> oldMap = SuidHelper.entityToMap(oldEntity);
        Map<String, Object> newMap = SuidHelper.entityToMap(newEntity);
        MapSql updateMapSql = BeeFactoryHelper.getMapSql();
        updateMapSql.put(MapSqlKey.Table, ObjSQLRich._toTableName(oldEntity));
        updateMapSql.put(MapSqlSetting.IsNamingTransfer, true);
        updateMapSql.put(oldMap);
        updateMapSql.putNew(newMap);
        Logger.logSQL("update(T oldEntity, T newEntity) with MapSuid, ", "");
        MapSuid mapSuid = BeeFactoryHelper.getMapSuid();
        return mapSuid.update(updateMapSql);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    public <T> int save(T entity) {
        Object id = HoneyUtil.getIdValue(entity);
        if (id == null) {
            return this.insert(entity);
        }
        T one = this.selectById(entity, id.toString());
        if (one != null) {
            return this.update(entity);
        }
        return this.insert(entity);
    }

    void doBeforePasreEntity(Object[] entity, SuidType SuidType2) {
        this.getInterceptorChain().beforePasreEntity(entity, SuidType2);
    }
}

