/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.logging;

import org.teasoft.bee.logging.Log;
import org.teasoft.honey.osql.util.DateUtil;

public class SystemLogger
implements Log {
    private static String TRACE = "TRACE";
    private static String DEBUG = "DEBUG";
    private static String INFO = "INFO";
    private static String WARN = "WARN";
    private static String ERROR = "ERROR";
    private static String APACE = " ";
    private static String LEFT = "[";
    private static String RIGHT = "]";
    private String className = null;

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        if (this.className != null) {
            this.print(TRACE, msg, this.className);
        } else {
            this.print(TRACE, msg);
        }
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        if (this.className != null) {
            this.print(DEBUG, msg, this.className);
        } else {
            this.print(DEBUG, msg);
        }
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        if (this.className != null) {
            this.print(INFO, msg, this.className);
        } else {
            this.print(INFO, msg);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        if (this.className != null) {
            this.print(WARN, msg, this.className);
        } else {
            this.print(WARN, msg);
        }
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        if (this.className != null) {
            this.print(ERROR, msg, this.className);
        } else {
            this.print(ERROR, msg);
        }
    }

    public void error(String msg, Throwable t) {
    }

    public boolean isOff() {
        return false;
    }

    private void print(String level, String msg) {
        StringBuffer b = new StringBuffer(DateUtil.currentDate());
        b.append(APACE).append(LEFT).append(level).append(RIGHT).append(APACE).append(msg);
        if (ERROR.equals(level) || WARN.equals(level)) {
            System.err.println(b.toString());
        } else {
            System.out.println(b.toString());
        }
    }

    private void print(String level, String msg, String className) {
        StringBuffer b = new StringBuffer(DateUtil.currentDate());
        b.append(APACE).append(LEFT).append(level).append(RIGHT).append(APACE).append(LEFT).append(className).append(RIGHT).append(APACE).append(msg);
        if (ERROR.equals(level) || WARN.equals(level)) {
            System.err.println(b.toString());
        } else {
            System.out.println(b.toString());
        }
    }

    public Log getLogger() {
        this.className = null;
        return this;
    }

    public Log getLogger(String name) {
        SystemLogger sLog = new SystemLogger();
        sLog.className = name;
        return sLog;
    }

    public Log getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }
}

