/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.chain;

import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.chain.Select;
import org.teasoft.honey.osql.chain.AbstractSelectToSql;

public class SelectImpl
extends AbstractSelectToSql
implements Select {
    private static String STAR = "*";
    private static String DISTINCT = "distinct";
    private static String L_PARENTHESES = "(";
    private static String R_PARENTHESES = ")";
    private static String COMMA = ",";
    private static String ONE_SPACE = " ";
    private boolean isStartField = true;
    private boolean isStartWhere = true;
    private boolean isStartOn = true;
    private boolean isAddAnd = false;
    private boolean isStartGroupBy = true;
    private boolean isStartHaving = true;
    private boolean isStartOrderBy = true;

    public SelectImpl() {
        this.sql.append("select ");
    }

    public Select select() {
        if (this.isStartField) {
            this.sql.append(STAR);
            this.isStartField = false;
        }
        return this;
    }

    public Select select(String column) {
        if (this.isStartField) {
            this.sql.append(column);
            this.isStartField = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(column);
        }
        return this;
    }

    public Select distinct(String field) {
        return this.select(DISTINCT + L_PARENTHESES + field + R_PARENTHESES);
    }

    public Select from(String table) {
        this.sql.append(" from ");
        this.sql.append(table);
        return this;
    }

    public Select join(String anotherTable) {
        this.sql.append(" join ");
        this.sql.append(anotherTable);
        return this;
    }

    public Select innerjoin(String anotherTable) {
        this.sql.append(" inner join ");
        this.sql.append(anotherTable);
        return this;
    }

    public Select leftjoin(String anotherTable) {
        this.sql.append(" left join ");
        this.sql.append(anotherTable);
        return this;
    }

    public Select rightjoin(String anotherTable) {
        this.sql.append(" right join ");
        this.sql.append(anotherTable);
        return this;
    }

    public Select on() {
        this.sql.append(" on ");
        this.isStartOn = false;
        return this;
    }

    public Select on(String expression) {
        if (this.isStartOn) {
            this.sql.append(" on ");
            this.sql.append(expression);
            this.isStartOn = false;
        } else {
            if (this.isAddAnd) {
                this.sql.append(" and ");
            }
            this.sql.append(expression);
            this.isAddAnd = true;
        }
        return this;
    }

    public Select between(String field, Number low, Number high) {
        if (this.isAddAnd) {
            this.sql.append(" and ");
        }
        this.sql.append(field);
        this.sql.append(" between ");
        this.sql.append(low);
        this.sql.append(" and ");
        this.sql.append(high);
        this.isAddAnd = true;
        return this;
    }

    public Select notBetween(String field, Number low, Number high) {
        if (this.isAddAnd) {
            this.sql.append(" and ");
        }
        this.sql.append(field);
        this.sql.append(" not between ");
        this.sql.append(low);
        this.sql.append(" and ");
        this.sql.append(high);
        this.isAddAnd = true;
        return this;
    }

    public Select isNull(String field) {
        if (this.isAddAnd) {
            this.sql.append(" and ");
        }
        this.sql.append(field + " is null ");
        return this;
    }

    public Select isNotNull(String field) {
        if (this.isAddAnd) {
            this.sql.append(" and ");
        }
        this.sql.append(field + " is not null ");
        return this;
    }

    public Select in(String field, Number ... valueList) {
        return this.inOrNotIn(field, "in", valueList);
    }

    public Select notIn(String field, Number ... valueList) {
        return this.inOrNotIn(field, "not in", valueList);
    }

    private Select inOrNotIn(String field, String op, Number ... valueList) {
        if (this.isAddAnd) {
            this.sql.append(" and ");
        }
        String value = "";
        for (int i = 0; i < valueList.length; ++i) {
            value = i == 0 ? value + valueList[i] : value + "," + valueList[i];
        }
        this.sql.append(field + " " + op + " (" + value + ")");
        return this;
    }

    public Select in(String field, String valueList) {
        return this.inOrNotIn(field, "in", valueList);
    }

    public Select notIn(String field, String valueList) {
        return this.inOrNotIn(field, "not in", valueList);
    }

    private Select inOrNotIn(String field, String op, String valueList) {
        if (this.isAddAnd) {
            this.sql.append(" and ");
        }
        valueList = valueList.replace(",", "','");
        this.sql.append(field + " " + op + " ('" + valueList + "')");
        return this;
    }

    public Select groupBy(String field) {
        if (this.isStartGroupBy) {
            this.sql.append(" group by ");
            this.sql.append(field);
            this.isStartGroupBy = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(field);
        }
        return this;
    }

    public Select having(String expression) {
        if (this.isStartHaving) {
            this.sql.append(" having ");
            this.sql.append(expression);
            this.isStartHaving = false;
        } else {
            this.sql.append(" and ");
            this.sql.append(expression);
        }
        return this;
    }

    public Select orderBy(String field) {
        if (this.isStartOrderBy) {
            this.sql.append(" order by ");
            this.sql.append(field);
            this.isStartOrderBy = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(field);
        }
        return this;
    }

    public Select orderBy(String field, OrderType orderType) {
        if (this.isStartOrderBy) {
            this.sql.append(" order by ");
            this.sql.append(field);
            this.sql.append(ONE_SPACE);
            this.sql.append(orderType.getName());
            this.isStartOrderBy = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(field);
            this.sql.append(ONE_SPACE);
            this.sql.append(orderType.getName());
        }
        return this;
    }

    private Select useSubSelect(String keyword, String subSelect) {
        this.sql.append(ONE_SPACE);
        this.sql.append(keyword);
        this.sql.append(ONE_SPACE);
        this.sql.append(L_PARENTHESES);
        this.sql.append(subSelect);
        this.sql.append(R_PARENTHESES);
        return this;
    }

    public Select exists(Select subSelect) {
        return this.exists(subSelect.toSQL(true));
    }

    public Select exists(String subSelect) {
        return this.useSubSelect("exists", subSelect);
    }

    public Select notExists(Select subSelect) {
        return this.notExists(subSelect.toSQL(true));
    }

    public Select notExists(String subSelect) {
        return this.useSubSelect("not exists", subSelect);
    }

    public Select in(Select subSelect) {
        return this.in(subSelect.toSQL(true));
    }

    public Select in(String subSelect) {
        return this.useSubSelect("in", subSelect);
    }

    public Select notIn(Select subSelect) {
        return this.notIn(subSelect.toSQL(true));
    }

    public Select notIn(String subSelect) {
        return this.useSubSelect("not in", subSelect);
    }

    public Select start(int start) {
        this.start = start;
        return this;
    }

    public Select size(int size) {
        this.size = size;
        return this;
    }

    public Select lParentheses() {
        this.sql.append(L_PARENTHESES);
        return this;
    }

    public Select rParentheses() {
        this.sql.append(R_PARENTHESES);
        return this;
    }

    public Select where() {
        this.sql.append(" where ");
        this.isStartWhere = false;
        return this;
    }

    public Select where(String expression) {
        if (this.isStartWhere) {
            this.sql.append(" where ");
            this.sql.append(expression);
            this.isStartWhere = false;
        } else {
            if (this.isAddAnd) {
                this.sql.append(" and ");
            }
            this.sql.append(expression);
            this.isAddAnd = true;
        }
        return this;
    }

    public Select op(String field, Op opType, String value) {
        if (opType == Op.in) {
            return this.in(field, value);
        }
        if (opType == Op.notIn) {
            return this.notIn(field, value);
        }
        if (this.isAddAnd) {
            this.sql.append(" and ");
        }
        this.sql.append(field);
        this.sql.append(opType.getOperator());
        this.sql.append("'");
        this.sql.append(value);
        this.sql.append("'");
        this.isAddAnd = true;
        return this;
    }

    public Select op(String field, Op opType, Number value) {
        if (opType == Op.in) {
            return this.in(field, value);
        }
        if (opType == Op.notIn) {
            return this.notIn(field, value);
        }
        if (this.isAddAnd) {
            this.sql.append(" and ");
        }
        this.sql.append(field);
        this.sql.append(opType.getOperator());
        this.sql.append(value);
        this.isAddAnd = true;
        return this;
    }

    public Select op(String field, String value) {
        return this.op(field, Op.eq, value);
    }

    public Select op(String field, Number value) {
        return this.op(field, Op.eq, value);
    }

    public Select and() {
        this.sql.append(" and ");
        this.isAddAnd = false;
        return this;
    }

    public Select or() {
        this.sql.append(" or ");
        this.isAddAnd = false;
        return this;
    }
}

