/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.CallableSql;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.SessionFactory;
import org.teasoft.honey.osql.core.TransformResultSet;

public class CallableSqlLib
implements CallableSql {
    public static ThreadLocal<Connection> connLocal2 = new ThreadLocal();
    public static ThreadLocal<Map<String, Connection>> connLocal = new ThreadLocal();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> select(String callSql, T entity, Object[] preValues) {
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement cstmt = null;
        ArrayList<Object> rsList = null;
        Object targetObj = null;
        try {
            conn = this.getConn();
            callSql = "{call " + callSql + "}";
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL("Callable SQL: ", callSql + "  values: " + values);
            rs = cstmt.executeQuery();
            rsList = new ArrayList<Object>();
            Field[] field = entity.getClass().getDeclaredFields();
            int columnCount = field.length;
            while (true) {
                if (!rs.next()) {
                    this.checkClose(cstmt, conn);
                    return rsList;
                }
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    if ("serialVersionUID".equals(field[i].getName())) continue;
                    field[i].setAccessible(true);
                    try {
                        field[i].set(targetObj, rs.getObject(CallableSqlLib._toColumnName(field[i].getName())));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field[i].set(targetObj, this._getObject(rs, field[i]));
                    }
                }
                rsList.add(targetObj);
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                throw throwable;
            }
        }
    }

    public int modify(String callSql, Object[] preValues) {
        int result = 0;
        Connection conn = null;
        CallableStatement cstmt = null;
        try {
            conn = this.getConn();
            callSql = "{call " + callSql + "}";
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL("Callable SQL: ", callSql + "  values: " + values);
            result = cstmt.executeUpdate();
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                throw throwable;
            }
        }
        return result;
    }

    public CallableStatement getCallableStatement(String callSql) {
        Connection conn = null;
        CallableStatement cstmt = null;
        try {
            conn = this.getConn();
            callSql = "{call " + callSql + "}";
            cstmt = conn.prepareCall(callSql);
            this.setConnLocal(this.getIdString(cstmt), conn);
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        return cstmt;
    }

    public int modify(CallableStatement cstmt) {
        int result = 0;
        try {
            Connection conn = this.getConnLocal(this.getIdString(cstmt));
            result = cstmt.executeUpdate();
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        return result;
    }

    public List<String[]> select(String callSql, Object[] preValues) {
        List<String[]> list = null;
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement cstmt = null;
        try {
            conn = this.getConn();
            callSql = "{call " + callSql + "}";
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL("Callable SQL: ", callSql + "  values: " + values);
            rs = cstmt.executeQuery();
            list = TransformResultSet.toStringsList(rs);
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                throw throwable;
            }
        }
        return list;
    }

    public String selectJson(String callSql, Object[] preValues) {
        StringBuffer json = new StringBuffer("");
        Connection conn = null;
        ResultSet rs = null;
        CallableStatement cstmt = null;
        try {
            conn = this.getConn();
            callSql = "{call " + callSql + "}";
            cstmt = conn.prepareCall(callSql);
            StringBuffer values = this.initPreparedValues(cstmt, preValues);
            Logger.logSQL("Callable SQL: ", callSql + "  values: " + values);
            rs = cstmt.executeQuery();
            json = TransformResultSet.toJson(rs);
            this.checkClose(cstmt, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(cstmt, conn);
                throw throwable;
            }
        }
        return json.toString();
    }

    private void setConnLocal(String key, Connection conn) {
        if (conn == null) {
            return;
        }
        Map<String, Connection> map = connLocal.get();
        if (null == map) {
            map = new HashMap<String, Connection>();
        }
        map.put(key, conn);
        connLocal.set(map);
    }

    private Connection getConnLocal(String key) {
        Map<String, Connection> map = connLocal.get();
        if (null == map) {
            return null;
        }
        Connection s = map.get(key);
        if (s != null) {
            map.remove(key);
        }
        return s;
    }

    private String getIdString(CallableStatement cstmt) {
        return cstmt.toString();
    }

    private StringBuffer initPreparedValues(CallableStatement cstmt, Object[] preValues) throws SQLException {
        if (preValues == null) {
            return new StringBuffer("preValues is null!");
        }
        StringBuffer valueBuffer = new StringBuffer();
        int len = preValues.length;
        for (int i = 0; i < len; ++i) {
            int k = HoneyUtil.getJavaTypeIndex(preValues[i].getClass().getName());
            HoneyUtil.setPreparedValues(cstmt, k, i, preValues[i]);
            valueBuffer.append(",");
            valueBuffer.append(preValues[i]);
        }
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        return valueBuffer;
    }

    private Connection getConn() throws SQLException {
        Connection conn = null;
        conn = HoneyContext.getCurrentConnection();
        if (conn == null) {
            conn = SessionFactory.getConnection();
        }
        return conn;
    }

    protected void checkClose(Statement stmt, Connection conn) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw ExceptionHelper.convert(e);
            }
        }
        try {
            if (conn != null && conn.getAutoCommit()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private Object _getObject(ResultSet rs, Field field) throws SQLException {
        return HoneyUtil.getResultObject(rs, field.getType().getName(), CallableSqlLib._toColumnName(field.getName()));
    }
}

