/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.ObjSQLIllegalSQLStringException;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeErrorFieldException;
import org.teasoft.bee.osql.exception.BeeIllegalEntityException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.ObjectToSQL;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlStrFilter;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;
import org.teasoft.honey.osql.name.NameUtil;

public class ObjectToSQLRich
extends ObjectToSQL
implements ObjToSQLRich {
    private DbFeature dbFeature = BeeFactory.getHoneyFactory().getDbFeature();
    private static final String ASC = "asc";
    private static String index1 = "[index";
    private static String index2 = "]";

    public <T> String toSelectSQL(T entity, int size) {
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = this.dbFeature.toPageSql(sql, size);
        this.setPreparedValue(sql, wrap);
        Logger.logSQL("select SQL(entity,size): ", sql);
        return sql;
    }

    public <T> String toSelectSQL(T entity, int from, int size) {
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = this.dbFeature.toPageSql(sql, from, size);
        this.setPreparedValue(sql, wrap);
        Logger.logSQL("select(entity,from,size) SQL:", sql);
        return sql;
    }

    public <T> String toSelectSQL(T entity, String selectFields, int from, int size) {
        SqlValueWrap wrap = this.toSelectSQL_0(entity, selectFields);
        String sql = wrap.getSql();
        sql = this.dbFeature.toPageSql(sql, from, size);
        this.setPreparedValue(sql, wrap);
        Logger.logSQL("select(entity,selectFields,from,size) SQL:", sql);
        return sql;
    }

    public <T> String toSelectSQL(T entity, String fieldList) throws ObjSQLException {
        String newSelectFields = this.checkSelectField(entity, fieldList);
        String sql = _ObjectToSQLHelper._toSelectSQL(entity, newSelectFields);
        Logger.logSQL("select SQL(selectFields) :", sql);
        return sql;
    }

    public <T> String toSelectOrderBySQL(T entity, String orderFieldList) throws ObjSQLException {
        String[] orderFields = orderFieldList.split(",");
        int lenA = orderFields.length;
        String orderBy = "";
        for (int i = 0; i < lenA; ++i) {
            orderBy = orderBy + orderFields[i] + " " + ASC;
            if (i >= lenA - 1) continue;
            orderBy = orderBy + ",";
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = sql + "order by " + orderBy + " ;";
        this.setPreparedValue(sql, wrap);
        return sql;
    }

    public <T> String toSelectOrderBySQL(T entity, String orderFieldList, OrderType[] orderTypes) throws ObjSQLException {
        String[] orderFields = orderFieldList.split(",");
        int lenA = orderFields.length;
        if (lenA != orderTypes.length) {
            throw new ObjSQLException("ObjSQLException :The lenth of orderField is not equal orderTypes'.");
        }
        String orderBy = "";
        for (int i = 0; i < lenA; ++i) {
            orderBy = orderBy + orderFields[i] + " " + orderTypes[i].getName();
            if (i >= lenA - 1) continue;
            orderBy = orderBy + ",";
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = sql + "order by " + orderBy + " ;";
        this.setPreparedValue(sql, wrap);
        return sql;
    }

    public <T> String toUpdateSQL(T entity, String updateFieldList) throws ObjSQLException {
        if (updateFieldList == null) {
            return null;
        }
        String sql = "";
        try {
            String[] updateFields = updateFieldList.split(",");
            if (updateFields.length == 0 || "".equals(updateFieldList.trim())) {
                throw new ObjSQLException("ObjSQLException:updateFieldList at least include one field.");
            }
            sql = _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, -1);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toUpdateSQL(T entity, String updateFieldList, IncludeType includeType) throws ObjSQLException {
        if (updateFieldList == null) {
            return null;
        }
        String sql = "";
        try {
            String[] updateFields = updateFieldList.split(",");
            if (updateFields.length == 0 || "".equals(updateFieldList.trim())) {
                throw new ObjSQLException("ObjSQLException:updateFieldList at least include one field.");
            }
            sql = _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, includeType.getValue());
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toSelectFunSQL(T entity, FunctionType functionType, String fieldForFun) throws ObjSQLException {
        return this._toSelectFunSQL(entity, functionType.getName(), fieldForFun);
    }

    private <T> String _toSelectFunSQL(T entity, String funType, String fieldForFun) throws ObjSQLException {
        ObjectToSQLRich.checkPackage(entity);
        if (fieldForFun == null || funType == null) {
            return null;
        }
        boolean isContainField = false;
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        String sql = null;
        try {
            String tableName = this._toTableName(entity);
            String selectAndFun = "count".equalsIgnoreCase(funType) && "*".equals(fieldForFun) ? "select count(*) from " : "select " + funType + "(" + ObjectToSQLRich._toColumnName(fieldForFun) + ") from ";
            sqlBuffer.append(selectAndFun);
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i].get(entity) == null || "serialVersionUID".equals(fields[i].getName())) {
                    if (!fields[i].getName().equals(fieldForFun) && (!"count".equalsIgnoreCase(funType) || !"*".equals(fieldForFun))) continue;
                    isContainField = true;
                    continue;
                }
                if (fields[i].getName().equals(fieldForFun)) {
                    isContainField = true;
                }
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(ObjectToSQLRich._toColumnName(fields[i].getName()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            sql = sqlBuffer.toString();
            if (valueBuffer.length() > 0) {
                valueBuffer.deleteCharAt(0);
            }
            HoneyContext.setPreparedValue(sql, list);
            HoneyContext.setSqlValue(sql, valueBuffer.toString());
            ObjectToSQLRich.addInContextForCache(sql, valueBuffer.toString(), tableName);
            if (SqlStrFilter.checkFunSql(sql, funType)) {
                throw new ObjSQLIllegalSQLStringException("ObjSQLIllegalSQLStringException:sql statement with function is illegal. " + sql);
            }
            Logger.logSQL("select fun SQL :", sql);
            if (!isContainField) {
                throw new ObjSQLException("ObjSQLException:Miss The Field! The entity(" + tableName + ") don't contain the field:" + fieldForFun);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toSelectSQL(T entity, IncludeType includeType) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType.getValue());
    }

    public <T> String toDeleteSQL(T entity, IncludeType includeType) {
        return _ObjectToSQLHelper._toDeleteSQL(entity, includeType.getValue());
    }

    public <T> String toInsertSQL(T entity, IncludeType includeType) {
        String sql = null;
        try {
            sql = _ObjectToSQLHelper._toInsertSQL(entity, includeType.getValue());
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toUpdateSQL(T entity, IncludeType includeType) {
        String sql = "";
        try {
            sql = _ObjectToSQLHelper._toUpdateSQL(entity, "id", includeType.getValue());
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        catch (ObjSQLException e) {
            throw e;
        }
        return sql;
    }

    public <T> String[] toInsertSQL(T[] entity) {
        return this.toInsertSQL(entity, "");
    }

    public <T> String[] toInsertSQL(T[] entity, String excludeFieldList) {
        String[] sql = null;
        try {
            int len = entity.length;
            sql = new String[len];
            String t_sql = "";
            SqlValueWrap wrap = _ObjectToSQLHelper._toInsertSQL0(entity[0], 2, excludeFieldList);
            sql[0] = t_sql = wrap.getSql();
            t_sql = t_sql + "[index0]";
            this.setPreparedValue(t_sql, wrap);
            Logger.logSQL("insert[] SQL :", t_sql);
            for (int i = 1; i < len; ++i) {
                wrap = _ObjectToSQLHelper._toInsertSQL_for_ValueList(entity[i], excludeFieldList);
                this.setPreparedValue_ForArray(sql[0] + index1 + i + index2, wrap);
                Logger.logSQL("insert[] SQL :", sql[0] + index1 + i + index2);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public String toDeleteByIdSQL(Class c, Integer id) {
        if (id == null) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Integer");
    }

    public String toDeleteByIdSQL(Class c, Long id) {
        if (id == null) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Long");
    }

    public String toDeleteByIdSQL(Class c, String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, ids);
    }

    private SqlValueWrap toDeleteByIdSQL0(Class c) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        String tableName = this._toTableNameByClass(c);
        sqlBuffer.append("delete from ").append(tableName).append(" where ");
        wrap.setValueBuffer(sqlBuffer);
        wrap.setTableNames(tableName);
        return wrap;
    }

    public <T> String toSelectByIdSQL(T entity, Integer id) {
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entity);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Integer");
    }

    public <T> String toSelectByIdSQL(T entity, Long id) {
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entity);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Long");
    }

    public <T> String toSelectByIdSQL(T entity, String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return null;
        }
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entity);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, ids);
    }

    private <T> String _toSelectAndDeleteByIdSQL(SqlValueWrap wrap, Number id, String numType) {
        if (id == null) {
            return null;
        }
        StringBuffer sqlBuffer = wrap.getValueBuffer();
        sqlBuffer.append("id=").append("?");
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        preparedValue = new PreparedValue();
        preparedValue.setType(numType);
        preparedValue.setValue(id);
        list.add(preparedValue);
        HoneyContext.setPreparedValue(sqlBuffer.toString(), list);
        HoneyContext.setSqlValue(sqlBuffer.toString(), id + "");
        ObjectToSQLRich.addInContextForCache(sqlBuffer.toString(), id + "", wrap.getTableNames());
        return sqlBuffer.toString();
    }

    private <T> String _toSelectAndDeleteByIdSQL(SqlValueWrap wrap, String ids) {
        StringBuffer sqlBuffer = wrap.getValueBuffer();
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        String[] idArray = ids.split(",");
        String t_ids = "id=?";
        preparedValue = new PreparedValue();
        preparedValue.setValue(idArray[0]);
        list.add(preparedValue);
        for (int i = 1; i < idArray.length; ++i) {
            preparedValue = new PreparedValue();
            t_ids = t_ids + " or id=?";
            preparedValue.setValue(idArray[i]);
            list.add(preparedValue);
        }
        sqlBuffer.append(t_ids);
        HoneyContext.setPreparedValue(sqlBuffer.toString(), list);
        HoneyContext.setSqlValue(sqlBuffer.toString(), ids);
        ObjectToSQLRich.addInContextForCache(sqlBuffer.toString(), ids, wrap.getTableNames());
        return sqlBuffer.toString();
    }

    private <T> SqlValueWrap toSelectByIdSQL0(T entity) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        String tableName = this._toTableName(entity);
        Field[] fields = entity.getClass().getDeclaredFields();
        String packageAndClassName = entity.getClass().getName();
        String columnNames = HoneyContext.getBeanField(packageAndClassName);
        if (columnNames == null) {
            columnNames = HoneyUtil.getBeanField(fields);
            HoneyContext.addBeanField(packageAndClassName, columnNames);
        }
        sqlBuffer.append("select " + columnNames + " from ");
        sqlBuffer.append(tableName).append(" where ");
        wrap.setValueBuffer(sqlBuffer);
        wrap.setTableNames(tableName);
        return wrap;
    }

    private <T> SqlValueWrap toSelectSQL_0(T entity) {
        return this.toSelectSQL_0(entity, null);
    }

    private <T> SqlValueWrap toSelectSQL_0(T entity, String selectField) {
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        try {
            String tableName = this._toTableName(entity);
            Field[] fields = entity.getClass().getDeclaredFields();
            String fieldNames = "";
            if (selectField != null && !"".equals(selectField.trim())) {
                fieldNames = this.checkSelectField(entity, selectField);
            } else {
                String packageAndClassName = entity.getClass().getName();
                fieldNames = HoneyContext.getBeanField(packageAndClassName);
                if (fieldNames == null) {
                    fieldNames = HoneyUtil.getBeanField(fields);
                    HoneyContext.addBeanField(packageAndClassName, fieldNames);
                }
            }
            sqlBuffer.append("select " + fieldNames + " from ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i].get(entity) == null || "serialVersionUID".equals(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(ObjectToSQLRich._toColumnName(fields[i].getName()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            if (valueBuffer.length() > 0) {
                valueBuffer.deleteCharAt(0);
            }
            wrap.setTableNames(tableName);
            wrap.setSql(sqlBuffer.toString());
            wrap.setList(list);
            wrap.setValueBuffer(valueBuffer);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return wrap;
    }

    private void setPreparedValue(String sql, SqlValueWrap wrap) {
        HoneyContext.setPreparedValue(sql, wrap.getList());
        HoneyContext.setSqlValue(sql, wrap.getValueBuffer().toString());
        ObjectToSQLRich.addInContextForCache(sql, wrap.getValueBuffer().toString(), wrap.getTableNames());
    }

    private void setPreparedValue_ForArray(String sql, SqlValueWrap wrap) {
        HoneyContext.setPreparedValue(sql, wrap.getList());
        HoneyContext.setSqlValue(sql, wrap.getValueBuffer().toString());
    }

    private <T> String checkSelectField(T entity, String fieldList) {
        Field[] fields = entity.getClass().getDeclaredFields();
        String packageAndClassName = entity.getClass().getName();
        String columnsdNames = HoneyContext.getBeanField(packageAndClassName);
        if (columnsdNames == null) {
            columnsdNames = HoneyUtil.getBeanField(fields);
            HoneyContext.addBeanField(packageAndClassName, columnsdNames);
        }
        String errorField = "";
        boolean isFirstError = true;
        String[] selectFields = fieldList.split(",");
        String newSelectFields = "";
        boolean isFisrt = true;
        for (String s : selectFields) {
            if (!columnsdNames.contains(ObjectToSQLRich._toColumnName(s))) {
                if (isFirstError) {
                    errorField = errorField + s;
                    isFirstError = false;
                } else {
                    errorField = errorField + "," + s;
                }
            }
            if (isFisrt) {
                newSelectFields = newSelectFields + ObjectToSQLRich._toColumnName(s);
                isFisrt = false;
                continue;
            }
            newSelectFields = newSelectFields + ", " + ObjectToSQLRich._toColumnName(s);
        }
        if (!"".equals(errorField)) {
            throw new BeeErrorFieldException("ErrorField: " + errorField);
        }
        return newSelectFields;
    }

    private static void addInContextForCache(String sql, String sqlValue, String tableName) {
        _ObjectToSQLHelper.addInContextForCache(sql, sqlValue, tableName);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    public static void checkPackageByClass(Class c) {
        if (c == null) {
            return;
        }
        String packageName = c.getPackage().getName();
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            throw new BeeIllegalEntityException("BeeIllegalEntityException: Illegal Entity, " + c.getName());
        }
    }

    private String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private String _toTableNameByClass(Class c) {
        return NameTranslateHandle.toTableName(c.getName());
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }
}

