/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.teasoft.bee.osql.exception.NoConfigException;
import org.teasoft.bee.osql.transaction.Transaction;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.transaction.JdbcTransaction;

public final class SessionFactory {
    private static BeeFactory beeFactory = null;

    public static BeeFactory getBeeFactory() {
        if (beeFactory == null) {
            beeFactory = new BeeFactory();
        }
        return beeFactory;
    }

    public void setBeeFactory(BeeFactory beeFactory) {
        SessionFactory.beeFactory = beeFactory;
    }

    public static Connection getConnection() {
        Connection conn = null;
        try {
            conn = SessionFactory.getBeeFactory().getDataSource() == null ? SessionFactory.getOriginalConn() : SessionFactory.getBeeFactory().getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        catch (ClassNotFoundException e) {
            Logger.error("Can not find the Database driver!  " + e.getMessage());
            throw new NoConfigException("Can not find the Database driver(maybe miss the jar file).");
        }
        catch (Exception e) {
            Logger.error("==========================Have Exception when getConnection===: " + e.getMessage());
            throw ExceptionHelper.convert(e);
        }
        return conn;
    }

    public static Transaction getTransaction() {
        Transaction tran = null;
        tran = SessionFactory.getBeeFactory().getTransaction() == null ? new JdbcTransaction() : SessionFactory.getBeeFactory().getTransaction();
        return tran;
    }

    private static Connection getOriginalConn() throws ClassNotFoundException, SQLException {
        String driverName = HoneyConfig.getHoneyConfig().getDriverName();
        String url = HoneyConfig.getHoneyConfig().getUrl();
        String username = HoneyConfig.getHoneyConfig().getUsername();
        String password = HoneyConfig.getHoneyConfig().getPassword();
        String nullInfo = "";
        if (driverName == null) {
            nullInfo = nullInfo + "bee.db.driverName do not config; ";
        }
        if (url == null) {
            nullInfo = nullInfo + "bee.db.url do not config; ";
        }
        if (username == null) {
            nullInfo = nullInfo + "bee.db.username do not config; ";
        }
        if (password == null) {
            nullInfo = nullInfo + "bee.db.password do not config; ";
        }
        if (!"".equals(nullInfo)) {
            throw new NoConfigException("NoConfigException,Do not set the database info: " + nullInfo);
        }
        Connection conn = null;
        Class.forName(driverName);
        conn = DriverManager.getConnection(url, username, password);
        return conn;
    }
}

