/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Cache;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SessionFactory;
import org.teasoft.honey.osql.core.TransformResultSet;

public class SqlLib
implements BeeSql {
    private Cache cache = BeeFactory.getHoneyFactory().getCache();
    private static String index1 = "[index";
    private static String index2 = "]";

    private Connection getConn() throws SQLException {
        Connection conn = null;
        conn = HoneyContext.getCurrentConnection();
        if (conn == null) {
            conn = SessionFactory.getConnection();
        }
        return conn;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> select(String sql, T entity) {
        this.updateInfoInCache(sql, "List<T>", SuidType.SELECT);
        Object cacheObj = this.cache.get(sql);
        if (cacheObj != null) {
            return (List)cacheObj;
        }
        Connection conn = null;
        PreparedStatement pst = null;
        Object targetObj = null;
        ArrayList<Object> rsList = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            ResultSet rs = pst.executeQuery();
            rsList = new ArrayList<Object>();
            Field[] field = entity.getClass().getDeclaredFields();
            int columnCount = field.length;
            while (true) {
                if (!rs.next()) {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.checkClose(pst, conn);
                    return rsList;
                }
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    if ("serialVersionUID".equals(field[i].getName())) continue;
                    field[i].setAccessible(true);
                    try {
                        field[i].set(targetObj, rs.getObject(SqlLib._toColumnName(field[i].getName())));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field[i].set(targetObj, this._getObject(rs, field[i]));
                    }
                }
                rsList.add(targetObj);
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> selectSomeField(String sql, T entity) {
        this.updateInfoInCache(sql, "List<T>", SuidType.SELECT);
        Object cacheObj = this.cache.get(sql);
        if (cacheObj != null) {
            return (List)cacheObj;
        }
        Connection conn = null;
        PreparedStatement pst = null;
        Object targetObj = null;
        ArrayList<Object> rsList = null;
        Hashtable<String, Field> map = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            ResultSet rs = pst.executeQuery();
            ResultSetMetaData rmeta = rs.getMetaData();
            int columnCount = rmeta.getColumnCount();
            rsList = new ArrayList<Object>();
            map = new Hashtable<String, Field>();
            Field field = null;
            String name = null;
            boolean isFirst = true;
            while (true) {
                if (!rs.next()) {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.checkClose(pst, conn);
                    return rsList;
                }
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    block17: {
                        try {
                            name = SqlLib._toFieldName(rmeta.getColumnName(i + 1));
                            if (isFirst) {
                                field = entity.getClass().getDeclaredField(name);
                                map.put(name, field);
                                break block17;
                            } else {
                                field = (Field)map.get(name);
                                if (field == null) {
                                }
                            }
                        }
                        catch (NoSuchFieldException e) {}
                        continue;
                    }
                    field.setAccessible(true);
                    try {
                        field.set(targetObj, rs.getObject(i + 1));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field.set(targetObj, this._getObjectByindex(rs, field, i + 1));
                    }
                }
                rsList.add(targetObj);
                isFirst = false;
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
    }

    public String selectFun(String sql) throws ObjSQLException {
        this.updateInfoInCache(sql, "String", SuidType.SELECT);
        Object cacheObj = this.cache.get(sql);
        if (cacheObj != null) {
            return (String)cacheObj;
        }
        String result = null;
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            if (rs.next()) {
                result = rs.getObject(1) == null ? "" : rs.getObject(1).toString();
            }
            rs.last();
            if (rs.getRow() > 1) {
                throw new ObjSQLException("ObjSQLException:The size of ResultSet more than 1.");
            }
            this.addInCache(sql, result, "String", SuidType.SELECT, 1);
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return result;
    }

    public List<String[]> select(String sql) {
        this.updateInfoInCache(sql, "List<String[]>", SuidType.SELECT);
        Object cacheObj = this.cache.get(sql);
        if (cacheObj != null) {
            return (List)cacheObj;
        }
        List<Object> list = new ArrayList();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            list = TransformResultSet.toStringsList(rs);
            this.addInCache(sql, list, "List<String[]>", SuidType.SELECT, list.size());
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return list;
    }

    public int modify(String sql) {
        int num = 0;
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            num = pst.executeUpdate();
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        if (num > 0) {
            this.clearInCache(sql, "int", SuidType.MODIFY);
        }
        return num;
    }

    public String selectJson(String sql) {
        this.updateInfoInCache(sql, "StringJson", SuidType.SELECT);
        Object cacheObj = this.cache.get(sql);
        if (cacheObj != null) {
            return (String)cacheObj;
        }
        StringBuffer json = new StringBuffer("");
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            json = TransformResultSet.toJson(rs);
            this.addInCache(sql, json.toString(), "StringJson", SuidType.SELECT, -1);
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return json.toString();
    }

    public int[] batch(String[] sql) {
        if (sql == null) {
            return null;
        }
        int batchSize = HoneyConfig.getHoneyConfig().getBatchSize();
        this.clearInCache(sql[0] + "[index0]", "int[]", SuidType.INSERT);
        return this.batch(sql, batchSize);
    }

    public int[] batch(String[] sql, int batchSize) {
        int len = sql.length;
        int[] total = new int[len];
        int[] part = new int[batchSize];
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConn();
            boolean oldAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql[0]);
            pst = conn.prepareStatement(exe_sql);
            if (len <= batchSize) {
                total = this.batch(sql, 0, len, conn, pst);
            } else {
                for (int i = 0; i < len / batchSize; ++i) {
                    part = this.batch(sql, i * batchSize, (i + 1) * batchSize, conn, pst);
                    total = HoneyUtil.mergeArray(total, part, i * batchSize, (i + 1) * batchSize);
                    pst.clearBatch();
                }
                if (len % batchSize != 0) {
                    int[] t2 = this.batch(sql, len - len % batchSize, len, conn, pst);
                    total = HoneyUtil.mergeArray(total, t2, len - len % batchSize, len);
                }
            }
            conn.setAutoCommit(oldAutoCommit);
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return total;
    }

    private int[] batch(String[] sql, int start, int end, Connection conn, PreparedStatement pst) throws SQLException {
        int[] a = new int[end - start];
        for (int i = start; i < end; ++i) {
            this.setPreparedValues(pst, sql[0] + index1 + i + index2);
            pst.addBatch();
        }
        a = pst.executeBatch();
        conn.commit();
        return a;
    }

    protected void checkClose(Statement stmt, Connection conn) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw ExceptionHelper.convert(e);
            }
        }
        try {
            if (conn != null && conn.getAutoCommit()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    private void setPreparedValues(PreparedStatement pst, String sql) throws SQLException {
        List<PreparedValue> list = HoneyContext.getPreparedValue(sql);
        if (null != list && list.size() > 0) {
            this._setPreparedValues(pst, list);
        }
    }

    private void _setPreparedValues(PreparedStatement pst, List<PreparedValue> list) throws SQLException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int k = HoneyUtil.getJavaTypeIndex(list.get(i).getType());
            HoneyUtil.setPreparedValues(pst, k, i, list.get(i).getValue());
        }
    }

    private Object _getObject(ResultSet rs, Field field) throws SQLException {
        return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName()));
    }

    private Object _getObjectByindex(ResultSet rs, Field field, int index) throws SQLException {
        return HoneyUtil.getResultObjectByIndex(rs, field.getType().getName(), index);
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toFieldName(String columnName) {
        return NameTranslateHandle.toFieldName(columnName);
    }

    private void addInCache(String sql, Object rs, String returnType, SuidType suidType, int resultSetSize) {
        int cacheWorkResultSetSize = HoneyConfig.getHoneyConfig().getCacheWorkResultSetSize();
        if (resultSetSize > cacheWorkResultSetSize) {
            HoneyContext.deleteCacheInfo(sql);
            return;
        }
        this.cache.add(sql, rs);
    }

    private void updateInfoInCache(String sql, String returnType, SuidType suidType) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            HoneyContext.setCacheInfo(sql, struct);
        }
    }

    private void clearInCache(String sql, String returnType, SuidType suidType) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            HoneyContext.setCacheInfo(sql, struct);
        }
        this.cache.clear(sql);
    }
}

