/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.osql.name.NameUtil;

final class _ObjectToSQLHelper {
    private static final String INSERT_INTO = "insert into ";

    private _ObjectToSQLHelper() {
    }

    static <T> String _toSelectSQL(T entity, String fieldNameList) {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        try {
            String tableName = _ObjectToSQLHelper._toTableName(entity);
            Field[] fields = entity.getClass().getDeclaredFields();
            sqlBuffer.append("select " + fieldNameList + " from ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i].get(entity) == null || "serialVersionUID".equals(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            sql = sqlBuffer.toString();
            if (valueBuffer.length() > 0) {
                valueBuffer.deleteCharAt(0);
            }
            HoneyContext.setPreparedValue(sql, list);
            HoneyContext.setSqlValue(sql, valueBuffer.toString());
            _ObjectToSQLHelper.addInContextForCache(sql, valueBuffer.toString(), tableName);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    static <T> String _toSelectSQL(T entity, int includeType) {
        _ObjectToSQLHelper.checkPackage(entity);
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        try {
            String tableName = _ObjectToSQLHelper._toTableName(entity);
            Field[] fields = entity.getClass().getDeclaredFields();
            String packageAndClassName = entity.getClass().getName();
            String columnNames = HoneyContext.getBeanField(packageAndClassName);
            if (columnNames == null) {
                columnNames = HoneyUtil.getBeanField(fields);
                HoneyContext.addBeanField(packageAndClassName, columnNames);
            }
            sqlBuffer.append("select " + columnNames + " from ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i].getName()) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer.append(" is null");
                    continue;
                }
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            if (valueBuffer.length() > 0) {
                valueBuffer.deleteCharAt(0);
            }
            HoneyContext.setPreparedValue(sqlBuffer.toString(), list);
            HoneyContext.setSqlValue(sqlBuffer.toString(), valueBuffer.toString());
            _ObjectToSQLHelper.addInContextForCache(sqlBuffer.toString(), valueBuffer.toString(), tableName);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sqlBuffer.toString();
    }

    static <T> String _toUpdateSQL(T entity, String whereColmn, int includeType) throws ObjSQLException, IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        StringBuffer whereValueBuffer = new StringBuffer();
        boolean firstSet = true;
        boolean isExistWhere = false;
        StringBuffer whereStament = new StringBuffer();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        sqlBuffer.append(" update ");
        sqlBuffer.append(tableName);
        sqlBuffer.append(" set ");
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        ArrayList<PreparedValue> whereList = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        int k = 0;
        int w = 0;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if ("id".equalsIgnoreCase(whereColmn) && fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) {
                throw new ObjSQLException("ObjSQLException: in the update(T entity), the id field of entity must not be null !");
            }
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i].getName())) continue;
            if (whereColmn.equalsIgnoreCase(fields[i].getName())) {
                whereStament.append(" where ");
                whereStament.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    whereValueBuffer.append(" is null");
                } else {
                    whereStament.append("=");
                    whereStament.append("?");
                    whereValueBuffer.append(",");
                    whereValueBuffer.append(fields[i].get(entity));
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    whereList.add(w++, preparedValue);
                }
                isExistWhere = true;
                continue;
            }
            if (firstSet) {
                sqlBuffer.append(" ");
                firstSet = false;
            } else {
                sqlBuffer.append(" , ");
            }
            sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
            if (fields[i].get(entity) == null) {
                sqlBuffer.append(" =null");
                continue;
            }
            sqlBuffer.append("=");
            sqlBuffer.append("?");
            valueBuffer.append(",");
            valueBuffer.append(fields[i].get(entity));
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            list.add(k++, preparedValue);
        }
        sqlBuffer.append(whereStament);
        sql = sqlBuffer.toString();
        list.addAll(whereList);
        valueBuffer.append(whereValueBuffer);
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        HoneyContext.setPreparedValue(sql, list);
        HoneyContext.setSqlValue(sql, valueBuffer.toString());
        _ObjectToSQLHelper.addInContextForCache(sqlBuffer.toString(), valueBuffer.toString(), tableName);
        return sql;
    }

    static <T> String _toUpdateSQL(T entity, String[] setColmn, int includeType) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        StringBuffer whereValueBuffer = new StringBuffer();
        boolean firstSet = true;
        boolean firstWhere = true;
        boolean isExistWhere = false;
        StringBuffer whereStament = new StringBuffer();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        sqlBuffer.append(" update ");
        sqlBuffer.append(tableName);
        sqlBuffer.append(" set ");
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        ArrayList<PreparedValue> whereList = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        int k = 0;
        int w = 0;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if (_ObjectToSQLHelper.isContainField(setColmn, fields[i].getName())) {
                if (firstSet) {
                    sqlBuffer.append(" ");
                    firstSet = false;
                } else {
                    sqlBuffer.append(" , ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer.append(" =null");
                    continue;
                }
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
                continue;
            }
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i].getName()) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
            if (firstWhere) {
                whereStament.append(" where ");
                firstWhere = false;
            } else {
                whereStament.append(" and ");
            }
            whereStament.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
            if (fields[i].get(entity) == null) {
                whereStament.append(" is null");
            } else {
                whereStament.append("=");
                whereStament.append("?");
                whereValueBuffer.append(",");
                whereValueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                whereList.add(w++, preparedValue);
            }
            isExistWhere = true;
        }
        sqlBuffer.append(whereStament);
        sql = sqlBuffer.toString();
        list.addAll(whereList);
        valueBuffer.append(whereValueBuffer);
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        HoneyContext.setPreparedValue(sql, list);
        HoneyContext.setSqlValue(sql, valueBuffer.toString());
        _ObjectToSQLHelper.addInContextForCache(sqlBuffer.toString(), valueBuffer.toString(), tableName);
        return sql;
    }

    static <T> String _toInsertSQL(T entity, int includeType) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlValue = new StringBuffer(") values (");
        StringBuffer valueBuffer = new StringBuffer();
        String sql = "";
        boolean isFirst = true;
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        sqlBuffer.append(INSERT_INTO);
        sqlBuffer.append(tableName);
        sqlBuffer.append("(");
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        int k = 0;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i].getName())) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sqlBuffer.append(",");
                sqlValue.append(",");
            }
            sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
            if (fields[i].get(entity) == null) {
                sqlValue.append("null");
                continue;
            }
            sqlValue.append("?");
            valueBuffer.append(",");
            valueBuffer.append(fields[i].get(entity));
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            list.add(k++, preparedValue);
        }
        sqlBuffer.append(sqlValue);
        sqlBuffer.append(")");
        sql = sqlBuffer.toString();
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        HoneyContext.setPreparedValue(sql, list);
        HoneyContext.setSqlValue(sql, valueBuffer.toString());
        _ObjectToSQLHelper.addInContextForCache(sqlBuffer.toString(), valueBuffer.toString(), tableName);
        return sql;
    }

    static <T> SqlValueWrap _toInsertSQL0(T entity, int includeType, String excludeFieldList) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlValue = new StringBuffer(") values (");
        StringBuffer valueBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        boolean isFirst = true;
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        wrap.setTableNames(tableName);
        sqlBuffer.append(INSERT_INTO);
        sqlBuffer.append(tableName);
        sqlBuffer.append("(");
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        int k = 0;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i].getName()) || !"".equals(excludeFieldList) && _ObjectToSQLHelper.isExcludeField(excludeFieldList, fields[i].getName())) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sqlBuffer.append(",");
                sqlValue.append(",");
            }
            sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
            sqlValue.append("?");
            valueBuffer.append(",");
            valueBuffer.append(fields[i].get(entity));
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            list.add(k++, preparedValue);
        }
        sqlBuffer.append(sqlValue);
        sqlBuffer.append(")");
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        wrap.setSql(sqlBuffer.toString());
        wrap.setList(list);
        wrap.setValueBuffer(valueBuffer);
        return wrap;
    }

    static <T> SqlValueWrap _toInsertSQL_for_ValueList(T entity, String excludeFieldList) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        StringBuffer valueBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        int k = 0;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if ("serialVersionUID".equals(fields[i].getName()) || !"".equals(excludeFieldList) && _ObjectToSQLHelper.isExcludeField(excludeFieldList, fields[i].getName())) continue;
            valueBuffer.append(",");
            valueBuffer.append(fields[i].get(entity));
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            list.add(k++, preparedValue);
        }
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        wrap.setList(list);
        wrap.setValueBuffer(valueBuffer);
        return wrap;
    }

    static <T> String _toDeleteSQL(T entity, int includeType) {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        boolean firstWhere = true;
        try {
            String tableName = _ObjectToSQLHelper._toTableName(entity);
            sqlBuffer.append("delete from ");
            sqlBuffer.append(tableName);
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i].getName()) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer.append(" is null");
                    continue;
                }
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            sql = sqlBuffer.toString();
            if (valueBuffer.length() > 0) {
                valueBuffer.deleteCharAt(0);
            }
            HoneyContext.setPreparedValue(sql, list);
            HoneyContext.setSqlValue(sql, valueBuffer.toString());
            _ObjectToSQLHelper.addInContextForCache(sqlBuffer.toString(), valueBuffer.toString(), tableName);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private static boolean isContainField(String[] fields, String fieldName) {
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            if (!fields[i].equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludeField(String excludeFieldList, String checkField) {
        String[] excludeFields;
        for (String f : excludeFields = excludeFieldList.split(",")) {
            if (!f.equals(checkField)) continue;
            return true;
        }
        return false;
    }

    static void addInContextForCache(String sql, String sqlValue, String tableName) {
        CacheSuidStruct struct = new CacheSuidStruct();
        struct.setSql(sql);
        struct.setSqlValue(sqlValue);
        struct.setTableNames(tableName);
        HoneyContext.setCacheInfo(sql, struct);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }
}

