/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.atuogen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.teasoft.honey.osql.atuogen.GenConfig;
import org.teasoft.honey.osql.atuogen.Table;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.SessionFactory;

public class GenBean {
    private GenConfig config;
    private String LINE_SEPARATOR = System.getProperty("line.separator");
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public GenBean(GenConfig config) {
        this.config = config;
    }

    private void genBeanFile(Table table) {
        String entitySaveDir;
        File folder;
        String tableName = table.getTableName();
        List<String> columnNames = table.getColumNames();
        List<String> columTypes = table.getColumTypes();
        String entityName = "";
        entityName = NameTranslateHandle.toEntityName(tableName);
        Logger.print("The Honey gen the JavaBean: " + this.config.getPackagePath() + "." + entityName);
        String authorComment = "/**" + this.LINE_SEPARATOR;
        authorComment = authorComment + "*@author Honey" + this.LINE_SEPARATOR;
        authorComment = authorComment + "*Create on " + this.format.format(new Date()) + this.LINE_SEPARATOR;
        authorComment = authorComment + "*/";
        String packageStr = "package " + this.config.getPackagePath() + ";" + this.LINE_SEPARATOR;
        String importStr = "";
        String propertyName = "";
        String propertiesStr = "";
        String getsetStr = "";
        String getsetProNameStr = "";
        String javaType = "";
        boolean bigIntegerFlag = true;
        boolean bigDecimalFlag = true;
        boolean dateFlag = true;
        boolean timeFlag = true;
        boolean timestampFlag = true;
        boolean blobFlag = true;
        boolean clobFlag = true;
        boolean arrayFlag = true;
        StringBuffer tostr = new StringBuffer();
        if (this.config.isGenSerializable()) {
            importStr = importStr + "import java.io.Serializable;" + this.LINE_SEPARATOR;
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            String columnType = columTypes.get(i);
            propertyName = NameTranslateHandle.toFieldName(columnName);
            getsetProNameStr = HoneyUtil.firstLetterToUpperCase(propertyName);
            javaType = HoneyUtil.getFieldType(columnType);
            if ("BigDecimal".equals(javaType) && bigDecimalFlag) {
                importStr = importStr + "import java.math.BigDecimal;" + this.LINE_SEPARATOR;
                bigDecimalFlag = false;
            } else if ("BigInteger".equals(javaType) && bigIntegerFlag) {
                importStr = importStr + "import java.math.BigInteger;" + this.LINE_SEPARATOR;
                bigIntegerFlag = false;
            } else if ("Date".equals(javaType) && dateFlag) {
                importStr = importStr + "import java.sql.Date;" + this.LINE_SEPARATOR;
                dateFlag = false;
            } else if ("Time".equals(javaType) && timeFlag) {
                importStr = importStr + "import java.sql.Time;" + this.LINE_SEPARATOR;
                timeFlag = false;
            } else if ("Timestamp".equals(javaType) && timestampFlag) {
                importStr = importStr + "import java.sql.Timestamp;" + this.LINE_SEPARATOR;
                timestampFlag = false;
            } else if ("Blob".equals(javaType) && blobFlag) {
                importStr = importStr + "import java.sql.Blob;" + this.LINE_SEPARATOR;
                blobFlag = false;
            } else if ("Clob".equals(javaType) && clobFlag) {
                importStr = importStr + "import java.sql.Clob;" + this.LINE_SEPARATOR;
                clobFlag = false;
            } else if ("Array".equals(javaType) && arrayFlag) {
                importStr = importStr + "import java.sql.Array;" + this.LINE_SEPARATOR;
                arrayFlag = false;
            }
            propertiesStr = propertiesStr + "\tprivate " + javaType + " " + propertyName + ";" + this.LINE_SEPARATOR;
            getsetStr = getsetStr + "\tpublic " + javaType + " get" + getsetProNameStr + "() {" + this.LINE_SEPARATOR + "\t\t" + "return " + propertyName + ";" + this.LINE_SEPARATOR + "\t}" + this.LINE_SEPARATOR + this.LINE_SEPARATOR + "\t" + "public void set" + getsetProNameStr + "(" + javaType + " " + propertyName + ") {" + this.LINE_SEPARATOR + "\t\t" + "this." + propertyName + " = " + propertyName + ";" + this.LINE_SEPARATOR + "\t}" + this.LINE_SEPARATOR + this.LINE_SEPARATOR;
            if (!this.config.isGenToString()) continue;
            tostr.append("\t\t str.append(\",").append(propertyName).append("=\").append(").append(propertyName).append(");");
            tostr.append("\t\t " + this.LINE_SEPARATOR);
        }
        String basePath = this.config.getBaseDir();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        if (!(folder = new File(entitySaveDir = basePath + this.config.getPackagePath().replace(".", File.separator) + File.separator)).exists()) {
            folder.mkdirs();
        }
        File entityFile = new File(entitySaveDir + entityName + ".java");
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(entityFile)));
            bw.write(packageStr + this.LINE_SEPARATOR);
            if (!"".equals(importStr)) {
                bw.write(importStr + this.LINE_SEPARATOR);
            }
            bw.write(authorComment + this.LINE_SEPARATOR);
            bw.write("public class " + entityName);
            if (this.config.isGenSerializable()) {
                bw.write(" implements Serializable");
            }
            bw.write(" {" + this.LINE_SEPARATOR + this.LINE_SEPARATOR);
            if (this.config.isGenSerializable()) {
                bw.write("\tprivate static final long serialVersionUID = " + HoneyUtil.genSerializableNum() + ";" + this.LINE_SEPARATOR);
                bw.write(this.LINE_SEPARATOR);
            }
            bw.write(propertiesStr);
            bw.write(this.LINE_SEPARATOR);
            bw.write(getsetStr);
            if (this.config.isGenToString()) {
                tostr.deleteCharAt(tostr.indexOf(","));
                tostr.insert(0, "\t\t" + this.LINE_SEPARATOR);
                tostr.append("\t\t str.append(\"]\");\t");
                tostr.append("\t\t " + this.LINE_SEPARATOR);
                tostr.append("\t\t return str.toString();\t");
                tostr.append("\t\t " + this.LINE_SEPARATOR);
                tostr.append("\t }");
                tostr.append("\t\t " + this.LINE_SEPARATOR);
                tostr.insert(0, "\t\t str.append(\"" + entityName + "[\");\t");
                tostr.insert(0, "\t" + this.LINE_SEPARATOR);
                tostr.insert(0, "\t\t StringBuffer str=new StringBuffer();");
                tostr.insert(0, "\t" + this.LINE_SEPARATOR);
                tostr.insert(0, "\t public String toString(){");
                bw.write(tostr.toString());
            }
            bw.write("}");
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExceptionHelper.convert(e);
        }
    }

    public void genAllBeanFile() {
        Logger.print("Generating...");
        List<Table> tables = this.getAllTables();
        Table table = null;
        for (int i = 0; i < tables.size(); ++i) {
            table = tables.get(i);
            this.genBeanFile(table);
        }
        Logger.print("Generate Success!");
        Logger.print("Please check: " + this.config.getBaseDir() + this.config.getPackagePath().replace(".", "\\"));
    }

    public void genSomeBeanFile(String tableList) {
        String[] tables = tableList.split(",");
        Connection con = null;
        try {
            con = SessionFactory.getConnection();
            Table table = null;
            for (int i = 0; i < tables.length; ++i) {
                table = this.getTable(tables[i], con);
                this.genBeanFile(table);
            }
            con.close();
        }
        catch (Exception e) {
            Logger.print(e.getMessage());
            if (e.getMessage().contains("You have an error in your SQL syntax;") && e.getMessage().contains("where 1<>1")) {
                Logger.print("Maybe the table name is the database key work. Please rename the tableName and test again.", e.getMessage());
            }
            throw ExceptionHelper.convert(e);
        }
        Logger.print("Generate Success!");
        Logger.print("Please check: " + this.config.getBaseDir() + this.config.getPackagePath().replace(".", "\\"));
    }

    private List<Table> getAllTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = SessionFactory.getConnection();
            String showTablesSql = "";
            if (!"".equals(this.config.getQueryTableSql().trim())) {
                showTablesSql = this.config.getQueryTableSql();
            } else if (this.config.getDbName().equalsIgnoreCase("mysql")) {
                showTablesSql = "show tables";
            } else if (this.config.getDbName().equalsIgnoreCase("oracle")) {
                showTablesSql = "select table_name from user_tables";
            } else if (this.config.getDbName().equalsIgnoreCase("sqlserver")) {
                showTablesSql = "select table_name from edp.information_schema.tables where table_type='base table'";
            }
            ps = con.prepareStatement(showTablesSql);
            rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getString(1) == null) continue;
                tables.add(this.getTable(rs.getString(1).trim(), con));
            }
            rs.close();
            ps.close();
            con.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw ExceptionHelper.convert(e);
        }
        return tables;
    }

    private Table getTable(String tableName, Connection con) throws SQLException {
        PreparedStatement ps = con.prepareStatement("select * from " + tableName + " where 1<>1");
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rmeta = rs.getMetaData();
        Table table = new Table();
        table.setTableName(tableName);
        int columCount = rmeta.getColumnCount();
        for (int i = 1; i <= columCount; ++i) {
            table.getColumNames().add(rmeta.getColumnName(i).trim());
            table.getColumTypes().add(rmeta.getColumnTypeName(i).trim());
        }
        rs.close();
        ps.close();
        return table;
    }
}

