/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.Expression;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;

public class ConditionHelper {
    static boolean isNeedAnd = true;
    private static String ONE_SPACE = " ";
    private static DbFeature dbFeature = BeeFactory.getHoneyFactory().getDbFeature();

    static void processCondition(StringBuffer sqlBuffer, StringBuffer valueBuffer, List<PreparedValue> list, Condition condition, boolean firstWhere) {
        ConditionHelper.processCondition(sqlBuffer, valueBuffer, list, condition, firstWhere, null);
    }

    static void processCondition(StringBuffer sqlBuffer, StringBuffer valueBuffer, List<PreparedValue> list, Condition condition, boolean firstWhere, String[] useSubTableNames) {
        PreparedValue preparedValue = null;
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List expList = conditionImpl.getExpList();
        Expression expression = null;
        for (int j = 0; j < expList.size(); ++j) {
            expression = (Expression)expList.get(j);
            String opType = expression.getOpType();
            if (firstWhere) {
                if ("orderBy".equalsIgnoreCase(opType) || "groupBy".equalsIgnoreCase(opType) || "having".equalsIgnoreCase(opType)) {
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                    isNeedAnd = false;
                }
            }
            if (Op.in.getOperator().equalsIgnoreCase(opType) || Op.notIn.getOperator().equalsIgnoreCase(opType)) {
                int i;
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                sqlBuffer.append(" ");
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append(" (");
                sqlBuffer.append("?");
                String str = expression.getValue().toString();
                String[] values = str.trim().split(",");
                for (i = 1; i < values.length; ++i) {
                    sqlBuffer.append(",?");
                }
                sqlBuffer.append(")");
                valueBuffer.append(",");
                valueBuffer.append(expression.getValue());
                for (i = 0; i < values.length; ++i) {
                    preparedValue = new PreparedValue();
                    preparedValue.setType(values[i].getClass().getName());
                    preparedValue.setValue(values[i]);
                    list.add(preparedValue);
                }
                isNeedAnd = true;
                continue;
            }
            if (Op.like.getOperator().equalsIgnoreCase(opType) || Op.notLike.getOperator().equalsIgnoreCase(opType)) {
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(expression.getValue());
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue().getClass().getName());
                preparedValue.setValue(expression.getValue());
                list.add(preparedValue);
                isNeedAnd = true;
                continue;
            }
            if (" between ".equalsIgnoreCase(opType) || " not between ".equalsIgnoreCase(opType)) {
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                sqlBuffer.append(opType);
                sqlBuffer.append("?");
                sqlBuffer.append(" and ");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(expression.getValue());
                valueBuffer.append(",");
                valueBuffer.append(expression.getValue2());
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue().getClass().getName());
                preparedValue.setValue(expression.getValue());
                list.add(preparedValue);
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue2().getClass().getName());
                preparedValue.setValue(expression.getValue2());
                list.add(preparedValue);
                isNeedAnd = true;
                continue;
            }
            if ("groupBy".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'group by' !");
                }
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                continue;
            }
            if ("having".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'having' !");
                }
                if (2 == expression.getOpNum()) {
                    sqlBuffer.append(expression.getValue());
                    sqlBuffer.append(expression.getValue2());
                    continue;
                }
                if (5 != expression.getOpNum()) continue;
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(expression.getValue3());
                sqlBuffer.append("(");
                if (FunctionType.COUNT.getName().equals(expression.getValue3()) && expression.getFieldName() != null && "*".equals(expression.getFieldName().trim())) {
                    sqlBuffer.append("*");
                } else {
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                }
                sqlBuffer.append(")");
                sqlBuffer.append(expression.getValue4());
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(expression.getValue2());
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue2().getClass().getName());
                preparedValue.setValue(expression.getValue2());
                list.add(preparedValue);
                continue;
            }
            if ("orderBy".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'order by' !");
                }
                sqlBuffer.append(expression.getValue());
                if (4 == expression.getOpNum()) {
                    sqlBuffer.append(expression.getValue3());
                    sqlBuffer.append("(");
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                    sqlBuffer.append(")");
                } else {
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                }
                if (3 != expression.getOpNum() && 4 != expression.getOpNum()) continue;
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(expression.getValue2());
                continue;
            }
            if (expression.getOpNum() == -2) {
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(expression.getValue());
                continue;
            }
            if (expression.getOpNum() == -1) {
                sqlBuffer.append(expression.getValue());
                isNeedAnd = true;
                continue;
            }
            if (expression.getOpNum() == 1) {
                sqlBuffer.append(" ");
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(" ");
                isNeedAnd = false;
                continue;
            }
            ConditionHelper.adjustAnd(sqlBuffer);
            sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
            if (expression.getValue() == null) {
                sqlBuffer.append(" is null");
            } else {
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(expression.getValue());
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue().getClass().getName());
                preparedValue.setValue(expression.getValue());
                list.add(preparedValue);
            }
            isNeedAnd = true;
        }
        if (SuidType.SELECT != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support paging !");
        }
        Integer start = conditionImpl.getStart();
        Integer size = conditionImpl.getSize();
        String sql = "";
        if (start != null && size != null) {
            sql = dbFeature.toPageSql(sqlBuffer.toString(), start.intValue(), size.intValue());
            sqlBuffer.delete(0, sqlBuffer.length());
            sqlBuffer.append(sql);
        } else if (size != null) {
            sql = dbFeature.toPageSql(sqlBuffer.toString(), size.intValue());
            sqlBuffer.delete(0, sqlBuffer.length());
            sqlBuffer.append(sql);
        }
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toColumnName(String fieldName, String[] useSubTableNames) {
        if (useSubTableNames == null) {
            return ConditionHelper._toColumnName(fieldName);
        }
        String t_fieldName = "";
        String t_tableName = "";
        String find_tableName = "";
        int index = fieldName.indexOf(".");
        if (index > -1) {
            t_fieldName = fieldName.substring(index + 1);
            t_tableName = fieldName.substring(0, index);
            String t_tableName_dot = fieldName.substring(0, index + 1);
            find_tableName = useSubTableNames[0] != null && useSubTableNames[0].startsWith(t_tableName_dot) ? t_tableName : (useSubTableNames[1] != null && useSubTableNames[1].startsWith(t_tableName_dot) ? t_tableName : NameTranslateHandle.toTableName(t_tableName));
            return find_tableName + "." + NameTranslateHandle.toColumnName(t_fieldName);
        }
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static void adjustAnd(StringBuffer sqlBuffer) {
        if (isNeedAnd) {
            sqlBuffer.append(" and ");
            isNeedAnd = false;
        }
    }
}

