/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidRich;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.ObjSQL;

public class ObjSQLRich
extends ObjSQL
implements SuidRich {
    private ObjToSQLRich objToSQLRich = BeeFactory.getHoneyFactory().getObjToSQLRich();

    public <T> List<T> select(T entity, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        String sql = this.objToSQLRich.toSelectSQL(entity, size);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        String sql = this.objToSQLRich.toSelectSQL(entity, start, size);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(T entity, String selectField) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.objToSQLRich.toSelectSQL(entity, selectField);
        list = this.getBeeSql().selectSomeField(sql, entity);
        return list;
    }

    public <T> List<T> select(T entity, String selectFields, int start, int size) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.objToSQLRich.toSelectSQL(entity, selectFields, start, size);
        list = this.getBeeSql().selectSomeField(sql, entity);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFieldList) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.objToSQLRich.toSelectOrderBySQL(entity, orderFieldList);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFieldList, OrderType[] orderTypes) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.objToSQLRich.toSelectOrderBySQL(entity, orderFieldList, orderTypes);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> int[] insert(T[] entity) {
        if (entity == null) {
            return null;
        }
        int len = entity.length;
        String[] insertSql = new String[len];
        insertSql = this.objToSQLRich.toInsertSQL((Object[])entity);
        return this.getBeeSql().batch(insertSql);
    }

    public <T> int[] insert(T[] entity, String excludeFieldList) {
        if (entity == null) {
            return null;
        }
        int len = entity.length;
        String[] insertSql = new String[len];
        insertSql = this.objToSQLRich.toInsertSQL((Object[])entity, excludeFieldList);
        return this.getBeeSql().batch(insertSql);
    }

    public <T> int[] insert(T[] entity, int batchSize) {
        if (entity == null) {
            return null;
        }
        int len = entity.length;
        String[] insertSql = new String[len];
        insertSql = this.objToSQLRich.toInsertSQL((Object[])entity);
        return this.getBeeSql().batch(insertSql, batchSize);
    }

    public <T> int[] insert(T[] entity, int batchSize, String excludeFieldList) {
        if (entity == null) {
            return null;
        }
        int len = entity.length;
        String[] insertSql = new String[len];
        insertSql = this.objToSQLRich.toInsertSQL((Object[])entity, excludeFieldList);
        return this.getBeeSql().batch(insertSql, batchSize);
    }

    public <T> int update(T entity, String updateFieldList) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.objToSQLRich.toUpdateSQL(entity, updateFieldList);
        Logger.logSQL("update SQL(updateFieldList) :", sql);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> T selectOne(T entity) {
        if (entity == null) {
            return null;
        }
        List<T> list = this.select(entity);
        if (list == null || list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun) {
        if (entity == null) {
            return null;
        }
        String s = null;
        String sql = this.objToSQLRich.toSelectFunSQL(entity, functionType, fieldForFun);
        s = this.getBeeSql().selectFun(sql);
        return s;
    }

    public <T> int update(T entity, String updateFieldList, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.objToSQLRich.toUpdateSQL(entity, updateFieldList, includeType);
        Logger.logSQL("update SQL(updateFieldList) :", sql);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> List<T> select(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        String sql = this.objToSQLRich.toSelectSQL(entity, includeType);
        Logger.logSQL("select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> int update(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        String sql = this.objToSQLRich.toUpdateSQL(entity, includeType);
        Logger.logSQL("update SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    public <T> int insert(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        String sql = this.objToSQLRich.toInsertSQL(entity, includeType);
        Logger.logSQL("insert SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    public <T> int delete(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        String sql = this.objToSQLRich.toDeleteSQL(entity, includeType);
        Logger.logSQL("delete SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    public <T> List<String[]> selectString(T entity) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.objToSQLRich.toSelectSQL(entity);
        Logger.logSQL("List<String[]> select SQL: ", sql);
        list = this.getBeeSql().select(sql);
        return list;
    }

    public <T> List<String[]> selectString(T entity, String selectFields) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.objToSQLRich.toSelectSQL(entity, selectFields);
        list = this.getBeeSql().select(sql);
        return list;
    }

    public <T> String selectJson(T entity) {
        if (entity == null) {
            return null;
        }
        String sql = this.objToSQLRich.toSelectSQL(entity);
        Logger.logSQL("selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> String selectJson(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        String sql = this.objToSQLRich.toSelectSQL(entity, includeType);
        Logger.logSQL("selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> List<T> selectById(T entity, Integer id) {
        if (entity == null) {
            return null;
        }
        String sql = this.objToSQLRich.toSelectByIdSQL(entity, id);
        Logger.logSQL("selectById SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> selectById(T entity, Long id) {
        if (entity == null) {
            return null;
        }
        String sql = this.objToSQLRich.toSelectByIdSQL(entity, id);
        Logger.logSQL("selectById SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> selectById(T entity, String ids) {
        if (entity == null) {
            return null;
        }
        String sql = this.objToSQLRich.toSelectByIdSQL(entity, ids);
        Logger.logSQL("selectById SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public int deleteById(Class c, Integer id) {
        if (c == null) {
            return 0;
        }
        String sql = this.objToSQLRich.toDeleteByIdSQL(c, id);
        Logger.logSQL("deleteById SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    public int deleteById(Class c, Long id) {
        if (c == null) {
            return 0;
        }
        String sql = this.objToSQLRich.toDeleteByIdSQL(c, id);
        Logger.logSQL("deleteById SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    public int deleteById(Class c, String ids) {
        if (c == null) {
            return 0;
        }
        String sql = this.objToSQLRich.toDeleteByIdSQL(c, ids);
        Logger.logSQL("deleteById SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    @Deprecated
    public <T> List<T> select(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        String sql = this.objToSQLRich.toSelectSQL(entity, includeType, condition);
        Logger.logSQL("select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> String selectJson(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        String sql = this.objToSQLRich.toSelectSQL(entity, includeType, condition);
        Logger.logSQL("selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> int updateBy(T entity, String whereFieldList) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.objToSQLRich.toUpdateBySQL(entity, whereFieldList);
        Logger.logSQL("update SQL(whereFieldList) :", sql);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int updateBy(T entity, String whereFieldList, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.objToSQLRich.toUpdateBySQL(entity, whereFieldList, includeType);
        Logger.logSQL("update SQL(whereFieldList) :", sql);
        r = this.getBeeSql().modify(sql);
        return r;
    }
}

