/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.PreparedSql;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.bee.osql.exception.SqlNullException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.osql.core.TokenUtil;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;
import org.teasoft.honey.osql.name.NameUtil;

public class PreparedSqlLib
implements PreparedSql {
    private BeeSql beeSql;
    private DbFeature dbFeature = BeeFactory.getHoneyFactory().getDbFeature();

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public <T> List<T> select(String sql, T entity, Object[] preValues) {
        this.initPreparedValues(sql, preValues, entity);
        Logger.logSQL("PreparedSqlLib select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(String sql, T entity, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        sql = this.dbFeature.toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues, entity);
        Logger.logSQL("PreparedSqlLib select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(String sqlStr, T entity, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map, entity);
        Logger.logSQL("PreparedSqlLib select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(String sqlStr, T entity, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        String pageSql = this.dbFeature.toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map, entity);
        Logger.logSQL("PreparedSqlLib select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> selectSomeField(String sql, T entity, Object[] preValues) {
        this.initPreparedValues(sql, preValues, entity);
        Logger.logSQL("PreparedSqlLib selectSomeField SQL: ", sql);
        return this.getBeeSql().selectSomeField(sql, entity);
    }

    public <T> List<T> selectSomeField(String sql, T entity, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        sql = this.dbFeature.toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues, entity);
        Logger.logSQL("PreparedSqlLib selectSomeField SQL: ", sql);
        return this.getBeeSql().selectSomeField(sql, entity);
    }

    public <T> List<T> selectSomeField(String sqlStr, T entity, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map, entity);
        Logger.logSQL("PreparedSqlLib selectSomeField SQL: ", sql);
        return this.getBeeSql().selectSomeField(sql, entity);
    }

    public <T> List<T> selectSomeField(String sqlStr, T entity, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        String pageSql = this.dbFeature.toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map, entity);
        Logger.logSQL("PreparedSqlLib selectSomeField SQL: ", sql);
        return this.getBeeSql().selectSomeField(sql, entity);
    }

    public String selectFun(String sql, Object[] preValues) throws ObjSQLException {
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSqlLib selectFun SQL: ", sql);
        return this.getBeeSql().selectFun(sql);
    }

    public String selectFun(String sqlStr, Map<String, Object> map) throws ObjSQLException {
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        Logger.logSQL("PreparedSqlLib selectFun SQL: ", sql);
        return this.getBeeSql().selectFun(sql);
    }

    public List<String[]> select(String sql, Object[] preValues) {
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSqlLib select SQL: ", sql);
        return this.getBeeSql().select(sql);
    }

    public List<String[]> select(String sql, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        sql = this.dbFeature.toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSqlLib select SQL: ", sql);
        return this.getBeeSql().select(sql);
    }

    public List<String[]> select(String sqlStr, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        Logger.logSQL("PreparedSqlLib select SQL: ", sql);
        return this.getBeeSql().select(sql);
    }

    public List<String[]> select(String sqlStr, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        String pageSql = this.dbFeature.toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map);
        Logger.logSQL("PreparedSqlLib select SQL: ", sql);
        return this.getBeeSql().select(sql);
    }

    @Deprecated
    public int modify(String sql, Object[] preValues) {
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSqlLib modify SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    @Deprecated
    public int modify(String sqlStr, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        Logger.logSQL("PreparedSqlLib modify SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    public String selectJson(String sql, Object[] preValues) {
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSqlLib selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public String selectJson(String sql, Object[] preValues, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        sql = this.dbFeature.toPageSql(sql, start, size);
        this.initPreparedValues(sql, preValues);
        Logger.logSQL("PreparedSqlLib selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public String selectJson(String sqlStr, Map<String, Object> map) {
        String sql = this.initPrepareValuesViaMap(sqlStr, map);
        Logger.logSQL("PreparedSqlLib selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public String selectJson(String sqlStr, Map<String, Object> map, int start, int size) {
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        String pageSql = this.dbFeature.toPageSql(sqlStr, start, size);
        String sql = this.initPrepareValuesViaMap(pageSql, map);
        Logger.logSQL("PreparedSqlLib selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    private <T> void initPreparedValues(String sql, Object[] preValues, T entity) {
        StringBuffer valueBuffer = this.initPreparedValues(sql, preValues);
        String tableName = PreparedSqlLib._toTableName(entity);
        PreparedSqlLib.addInContextForCache(sql, valueBuffer.toString(), tableName);
    }

    private StringBuffer initPreparedValues(String sql, Object[] preValues) {
        if (sql == null || "".equals(sql.trim())) {
            throw new SqlNullException("sql statement string is Null !");
        }
        PreparedValue preparedValue = null;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        StringBuffer valueBuffer = new StringBuffer();
        for (int i = 0; i < preValues.length; ++i) {
            preparedValue = new PreparedValue();
            preparedValue.setType(preValues[i].getClass().getName());
            preparedValue.setValue(preValues[i]);
            list.add(preparedValue);
            valueBuffer.append(",");
            valueBuffer.append(preValues[i]);
        }
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
            HoneyContext.setPreparedValue(sql, list);
            HoneyContext.setSqlValue(sql, valueBuffer.toString());
        }
        return valueBuffer;
    }

    private <T> Map<String, Object> mergeMap(Map<String, Object> prameterMap, T entity) {
        Map<String, Object> columnMap = HoneyUtil.getColumnMapByEntity(entity);
        columnMap.putAll(prameterMap);
        return columnMap;
    }

    private <T> String initPrepareValuesViaMap(String sqlStr, Map<String, Object> parameterMap, T entity) {
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            throw new SqlNullException("sql statement string is Null !");
        }
        parameterMap = this.mergeMap(parameterMap, entity);
        SqlValueWrap wrap = this.processSql(sqlStr);
        if (wrap == null) {
            String tableName = PreparedSqlLib._toTableName(entity);
            PreparedSqlLib.addInContextForCache(sqlStr, null, tableName);
            return sqlStr;
        }
        String sql = wrap.getSql();
        String mapKeys = wrap.getValueBuffer().toString();
        StringBuffer valueBuffer = this._initPreparedValues(sql, mapKeys, parameterMap);
        String tableName = PreparedSqlLib._toTableName(entity);
        PreparedSqlLib.addInContextForCache(sql, valueBuffer.toString(), tableName);
        return sql;
    }

    private String initPrepareValuesViaMap(String sqlStr, Map<String, Object> map) {
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            throw new SqlNullException("sql statement string is Null !");
        }
        SqlValueWrap wrap = this.processSql(sqlStr);
        if (wrap == null) {
            return sqlStr;
        }
        String sql = wrap.getSql();
        String mapKeys = wrap.getValueBuffer().toString();
        this._initPreparedValues(sql, mapKeys, map);
        return sql;
    }

    private StringBuffer _initPreparedValues(String sql, String mapKeys, Map<String, Object> map) {
        PreparedValue preparedValue = null;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        StringBuffer valueBuffer = new StringBuffer();
        String[] keys = mapKeys.split(",");
        int k = 0;
        for (int i = 0; i < keys.length; ++i) {
            preparedValue = new PreparedValue();
            Object value = null;
            int len = keys[i].length();
            if (keys[i].startsWith("%")) {
                if (keys[i].endsWith("%")) {
                    keys[i] = keys[i].substring(1, len - 1);
                    value = "%" + map.get(keys[i]) + "%";
                    preparedValue.setValue(value);
                } else {
                    keys[i] = keys[i].substring(1, len);
                    value = "%" + map.get(keys[i]);
                    preparedValue.setValue(value);
                }
            } else if (keys[i].endsWith("%")) {
                keys[i] = keys[i].substring(0, len - 1);
                value = map.get(keys[i]) + "%";
                preparedValue.setValue(value);
            } else {
                value = map.get(keys[i]);
                preparedValue.setValue(value);
            }
            preparedValue.setType(map.get(keys[i]).getClass().getName());
            list.add(k++, preparedValue);
            valueBuffer.append(",");
            valueBuffer.append(value);
        }
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
            HoneyContext.setPreparedValue(sql, list);
            HoneyContext.setSqlValue(sql, valueBuffer.toString());
        }
        return valueBuffer;
    }

    private SqlValueWrap processSql(String sql) {
        return TokenUtil.process(sql, "#{", "}", "?");
    }

    private static void addInContextForCache(String sql, String sqlValue, String tableName) {
        _ObjectToSQLHelper.addInContextForCache(sql, sqlValue, tableName);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }
}

