/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.ObjToSQL;
import org.teasoft.bee.osql.Suid;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.Logger;

public class ObjSQL
implements Suid {
    private BeeSql beeSql;
    private ObjToSQL objToSQL = BeeFactory.getHoneyFactory().getObjToSQL();

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.objToSQL.toSelectSQL(entity);
        Logger.logSQL("select SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> int update(T entity) {
        if (entity == null) {
            return -1;
        }
        String sql = "";
        int updateNum = -1;
        sql = this.objToSQL.toUpdateSQL(entity);
        Logger.logSQL("update SQL: ", sql);
        updateNum = this.getBeeSql().modify(sql);
        return updateNum;
    }

    public <T> int insert(T entity) {
        if (entity == null) {
            return -1;
        }
        String sql = this.objToSQL.toInsertSQL(entity);
        int insertNum = -1;
        Logger.logSQL("insert SQL: ", sql);
        insertNum = this.getBeeSql().modify(sql);
        return insertNum;
    }

    public int delete(Object entity) {
        if (entity == null) {
            return -1;
        }
        String sql = this.objToSQL.toDeleteSQL(entity);
        int deleteNum = -1;
        Logger.logSQL("delete SQL: ", sql);
        deleteNum = this.getBeeSql().modify(sql);
        return deleteNum;
    }

    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.objToSQL.toSelectSQL(entity, condition);
        Logger.logSQL("select SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> int delete(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        String sql = this.objToSQL.toDeleteSQL(entity, condition);
        int deleteNum = -1;
        if (!"".equals(sql)) {
            Logger.logSQL("delete SQL: ", sql);
        }
        deleteNum = this.getBeeSql().modify(sql);
        return deleteNum;
    }
}

