/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Cache;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SessionFactory;
import org.teasoft.honey.osql.core.TransformResultSet;
import org.teasoft.honey.osql.name.NameUtil;

public class SqlLib
implements BeeSql {
    private Cache cache = BeeFactory.getHoneyFactory().getCache();
    private static String index1 = "[index";
    private static String index2 = "]";

    private Connection getConn() throws SQLException {
        Connection conn = null;
        conn = HoneyContext.getCurrentConnection();
        if (conn == null) {
            conn = SessionFactory.getConnection();
        }
        return conn;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> select(String sql, T entity) {
        Object cacheObj;
        if (sql == null) return null;
        if ("".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "List<T>", SuidType.SELECT);
        if (isReg && (cacheObj = this.cache.get(sql)) != null) {
            return (List)cacheObj;
        }
        Connection conn = null;
        PreparedStatement pst = null;
        Object targetObj = null;
        ArrayList<Object> rsList = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            ResultSet rs = pst.executeQuery();
            rsList = new ArrayList<Object>();
            Field[] field = entity.getClass().getDeclaredFields();
            int columnCount = field.length;
            while (true) {
                if (!rs.next()) {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.checkClose(pst, conn);
                    return rsList;
                }
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    if ("serialVersionUID".equals(field[i].getName()) || field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) continue;
                    field[i].setAccessible(true);
                    try {
                        field[i].set(targetObj, rs.getObject(SqlLib._toColumnName(field[i].getName())));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field[i].set(targetObj, this._getObject(rs, field[i]));
                    }
                }
                rsList.add(targetObj);
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> selectSomeField(String sql, T entity) {
        Object cacheObj;
        if (sql == null) return null;
        if ("".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "List<T>", SuidType.SELECT);
        if (isReg && (cacheObj = this.cache.get(sql)) != null) {
            return (List)cacheObj;
        }
        Connection conn = null;
        PreparedStatement pst = null;
        Object targetObj = null;
        ArrayList<Object> rsList = null;
        Hashtable<String, Field> map = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            ResultSet rs = pst.executeQuery();
            ResultSetMetaData rmeta = rs.getMetaData();
            int columnCount = rmeta.getColumnCount();
            rsList = new ArrayList<Object>();
            map = new Hashtable<String, Field>();
            Field field = null;
            String name = null;
            boolean isFirst = true;
            while (true) {
                if (!rs.next()) {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.checkClose(pst, conn);
                    return rsList;
                }
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    block18: {
                        try {
                            name = SqlLib._toFieldName(rmeta.getColumnName(i + 1));
                            if (isFirst) {
                                field = entity.getClass().getDeclaredField(name);
                                map.put(name, field);
                                break block18;
                            } else {
                                field = (Field)map.get(name);
                                if (field == null) {
                                }
                            }
                        }
                        catch (NoSuchFieldException e) {}
                        continue;
                    }
                    field.setAccessible(true);
                    try {
                        field.set(targetObj, rs.getObject(i + 1));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field.set(targetObj, this._getObjectByindex(rs, field, i + 1));
                    }
                }
                rsList.add(targetObj);
                isFirst = false;
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
    }

    public String selectFun(String sql) throws ObjSQLException {
        Object cacheObj;
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "String", SuidType.SELECT);
        if (isReg && (cacheObj = this.cache.get(sql)) != null) {
            return (String)cacheObj;
        }
        String result = null;
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            if (rs.next()) {
                result = rs.getObject(1) == null ? "" : rs.getObject(1).toString();
            }
            rs.last();
            if (rs.getRow() > 1) {
                throw new ObjSQLException("ObjSQLException:The size of ResultSet more than 1.");
            }
            this.addInCache(sql, result, "String", SuidType.SELECT, 1);
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return result;
    }

    public List<String[]> select(String sql) {
        Object cacheObj;
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "List<String[]>", SuidType.SELECT);
        if (isReg && (cacheObj = this.cache.get(sql)) != null) {
            return (List)cacheObj;
        }
        List<Object> list = new ArrayList();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            list = TransformResultSet.toStringsList(rs);
            this.addInCache(sql, list, "List<String[]>", SuidType.SELECT, list.size());
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return list;
    }

    public int modify(String sql) {
        if (sql == null || "".equals(sql)) {
            return -2;
        }
        int num = 0;
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            num = pst.executeUpdate();
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        if (num > 0) {
            this.clearInCache(sql, "int", SuidType.MODIFY);
        }
        return num;
    }

    public String selectJson(String sql) {
        Object cacheObj;
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "StringJson", SuidType.SELECT);
        if (isReg && (cacheObj = this.cache.get(sql)) != null) {
            return (String)cacheObj;
        }
        StringBuffer json = new StringBuffer("");
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            json = TransformResultSet.toJson(rs);
            this.addInCache(sql, json.toString(), "StringJson", SuidType.SELECT, -1);
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return json.toString();
    }

    public int[] batch(String[] sql) {
        if (sql == null) {
            return null;
        }
        int batchSize = HoneyConfig.getHoneyConfig().getBatchSize();
        this.clearInCache(sql[0] + "[index0]", "int[]", SuidType.INSERT);
        return this.batch(sql, batchSize);
    }

    public int[] batch(String[] sql, int batchSize) {
        if (sql == null) {
            return null;
        }
        int len = sql.length;
        int[] total = new int[len];
        int[] part = new int[batchSize];
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConn();
            boolean oldAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql[0]);
            pst = conn.prepareStatement(exe_sql);
            if (len <= batchSize) {
                total = this.batch(sql, 0, len, conn, pst);
            } else {
                for (int i = 0; i < len / batchSize; ++i) {
                    part = this.batch(sql, i * batchSize, (i + 1) * batchSize, conn, pst);
                    total = HoneyUtil.mergeArray(total, part, i * batchSize, (i + 1) * batchSize);
                    pst.clearBatch();
                }
                if (len % batchSize != 0) {
                    int[] t2 = this.batch(sql, len - len % batchSize, len, conn, pst);
                    total = HoneyUtil.mergeArray(total, t2, len - len % batchSize, len);
                }
            }
            conn.setAutoCommit(oldAutoCommit);
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return total;
    }

    private int[] batch(String[] sql, int start, int end, Connection conn, PreparedStatement pst) throws SQLException {
        int[] a = new int[end - start];
        for (int i = start; i < end; ++i) {
            this.setPreparedValues(pst, sql[0] + index1 + i + index2);
            pst.addBatch();
        }
        a = pst.executeBatch();
        conn.commit();
        return a;
    }

    protected void checkClose(Statement stmt, Connection conn) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw ExceptionHelper.convert(e);
            }
        }
        try {
            if (conn != null && conn.getAutoCommit()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> moreTableSelect(String sql, T entity) {
        Object cacheObj;
        if (sql == null) return null;
        if ("".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "List<T>", SuidType.SELECT);
        if (isReg && (cacheObj = this.cache.get(sql)) != null) {
            return (List)cacheObj;
        }
        Connection conn = null;
        PreparedStatement pst = null;
        Object targetObj = null;
        ArrayList rsList = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            ResultSet rs = pst.executeQuery();
            rsList = new ArrayList();
            Field[] field = entity.getClass().getDeclaredFields();
            int columnCount = field.length;
            MoreTableStruct[] moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity);
            Field[] subField = new Field[2];
            String[] subUseTable = new String[2];
            String[] variableName = new String[2];
            Class[] subEntityFieldClass = new Class[2];
            for (int i = 1; i <= 2; ++i) {
                if (moreTableStruct[i] == null) continue;
                subField[i - 1] = moreTableStruct[i].subEntityField;
                variableName[i - 1] = subField[i - 1].getName();
                subEntityFieldClass[i - 1] = subField[i - 1].getType();
                subUseTable[i - 1] = moreTableStruct[i].useSubTableName;
            }
            Field[] fields1 = subEntityFieldClass[0].getDeclaredFields();
            Field[] fields2 = null;
            if (subField[1] != null) {
                fields2 = subEntityFieldClass[1].getDeclaredFields();
            }
            String tableName = SqlLib._toTableName(entity);
            while (true) {
                if (!rs.next()) {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.checkClose(pst, conn);
                    return rsList;
                }
                Object subObj1 = subEntityFieldClass[0].newInstance();
                for (int i = 0; i < fields1.length; ++i) {
                    if ("serialVersionUID".equals(fields1[i].getName()) || fields1[i] != null && fields1[i].isAnnotationPresent(JoinTable.class)) continue;
                    fields1[i].setAccessible(true);
                    try {
                        fields1[i].set(subObj1, rs.getObject(subUseTable[0] + "." + SqlLib._toColumnName(fields1[i].getName())));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        fields1[i].set(subObj1, this._getObjectForMoreTable(rs, subUseTable[0], fields1[i]));
                    }
                }
                Object subObj2 = null;
                if (subField[1] != null) {
                    subObj2 = subEntityFieldClass[1].newInstance();
                    for (int i = 0; i < fields2.length; ++i) {
                        if ("serialVersionUID".equals(fields2[i].getName()) || fields2[i] != null && fields2[i].isAnnotationPresent(JoinTable.class)) continue;
                        fields2[i].setAccessible(true);
                        try {
                            fields2[i].set(subObj2, rs.getObject(subUseTable[1] + "." + SqlLib._toColumnName(fields2[i].getName())));
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            fields2[i].set(subObj2, this._getObjectForMoreTable(rs, subUseTable[1], fields2[i]));
                        }
                    }
                }
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    if ("serialVersionUID".equals(field[i].getName())) continue;
                    if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                        field[i].setAccessible(true);
                        if (field[i].getName().equals(variableName[0])) {
                            field[i].set(targetObj, subObj1);
                            continue;
                        }
                        if (subField[1] == null || !field[i].getName().equals(variableName[1])) continue;
                        field[i].set(targetObj, subObj2);
                        continue;
                    }
                    field[i].setAccessible(true);
                    try {
                        field[i].set(targetObj, rs.getObject(tableName + "." + SqlLib._toColumnName(field[i].getName())));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field[i].set(targetObj, this._getObjectForMoreTable(rs, tableName, field[i]));
                    }
                }
                rsList.add(targetObj);
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
    }

    private void setPreparedValues(PreparedStatement pst, String sql) throws SQLException {
        List<PreparedValue> list = HoneyContext.getPreparedValue(sql);
        if (null != list && list.size() > 0) {
            this._setPreparedValues(pst, list);
        }
    }

    private void _setPreparedValues(PreparedStatement pst, List<PreparedValue> list) throws SQLException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int k = HoneyUtil.getJavaTypeIndex(list.get(i).getType());
            HoneyUtil.setPreparedValues(pst, k, i, list.get(i).getValue());
        }
    }

    private Object _getObject(ResultSet rs, Field field) throws SQLException {
        return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName()));
    }

    private Object _getObjectForMoreTable(ResultSet rs, String tableName, Field field) throws SQLException {
        return HoneyUtil.getResultObject(rs, field.getType().getName(), tableName + "." + SqlLib._toColumnName(field.getName()));
    }

    private Object _getObjectByindex(ResultSet rs, Field field, int index) throws SQLException {
        return HoneyUtil.getResultObjectByIndex(rs, field.getType().getName(), index);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toFieldName(String columnName) {
        return NameTranslateHandle.toFieldName(columnName);
    }

    private void addInCache(String sql, Object rs, String returnType, SuidType suidType, int resultSetSize) {
        int cacheWorkResultSetSize = HoneyConfig.getHoneyConfig().getCacheWorkResultSetSize();
        if (resultSetSize > cacheWorkResultSetSize) {
            HoneyContext.deleteCacheInfo(sql);
            return;
        }
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            this.cache.add(sql, rs);
        }
    }

    private boolean updateInfoInCache(String sql, String returnType, SuidType suidType) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            HoneyContext.setCacheInfo(sql, struct);
            return true;
        }
        return false;
    }

    private void clearInCache(String sql, String returnType, SuidType suidType) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            HoneyContext.setCacheInfo(sql, struct);
        }
        this.cache.clear(sql);
    }
}

