/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.distribution;

import java.util.concurrent.atomic.AtomicLong;
import org.teasoft.bee.distribution.GenId;
import org.teasoft.bee.distribution.Worker;
import org.teasoft.honey.distribution.DefaultWorker;

public class SerialUniqueId
implements GenId {
    private AtomicLong sequenceNumber = null;
    private Worker worker;
    private long workerId = this.getWorker().getWorkerId();
    private long startTime = this._curSecond();
    private final long segment = 0L;
    private final long sequence = 1L;
    private final long timeBits = 31L;
    private final long segmentBits = 3L;
    private final long sequenceBits = 19L;
    private final long workerIdShift = 53L;
    private final long timestampLeftShift = 22L;
    private final long segmentShift = 19L;
    private long twepoch = 1483200000L;
    private long initNum = this.workerId << 53 | this.startTime - this.twepoch << 22 | 0L | 1L;

    public SerialUniqueId() {
        this.sequenceNumber = new AtomicLong(this.initNum);
    }

    private long _curSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public Worker getWorker() {
        if (this.worker == null) {
            return new DefaultWorker();
        }
        return this.worker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public synchronized long get() {
        long id = this.sequenceNumber.getAndIncrement();
        this.testSpeedLimit(id);
        return id;
    }

    public synchronized long[] getRangeId(int sizeOfIds) {
        long[] r;
        r = new long[]{this.sequenceNumber.getAndIncrement(), r[0] + (long)sizeOfIds - 1L};
        this.setSequenceNumber(r[0] + (long)sizeOfIds);
        this.testSpeedLimit(r[1]);
        return r;
    }

    private void setSequenceNumber(long newNum) {
        this.sequenceNumber.set(newNum);
    }

    private void testSpeedLimit(long currentLong) {
        long spentTime = this._curSecond() - this.startTime + 1L;
        if (spentTime > 0L && spentTime << 22 > currentLong - this.initNum) {
            return;
        }
        try {
            this.wait(10L);
            this.testSpeedLimit(currentLong);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

