/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.logging;

import org.teasoft.bee.logging.Log;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.util.DateUtil;

public class SystemLogger
implements Log {
    private static String TRACE = "TRACE";
    private static String DEBUG = "DEBUG";
    private static String INFO = "INFO";
    private static String WARN = "WARN";
    private static String ERROR = "ERROR";
    private static String SPACE = " ";
    private static String LEFT = "[";
    private static String RIGHT = "]";
    private static boolean donotPrintCurrentDate = HoneyConfig.getHoneyConfig().isShowSQL_donotPrint_currentDate();
    private static boolean donotPrintLevel = HoneyConfig.getHoneyConfig().isLog_donotPrint_level();
    private String className = null;

    public SystemLogger() {
    }

    public SystemLogger(String className) {
        this.className = className;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        if (this.className != null) {
            this.print(TRACE, msg, this.className);
        } else {
            this.print(TRACE, msg);
        }
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        if (this.className != null) {
            this.print(DEBUG, msg, this.className);
        } else {
            this.print(DEBUG, msg);
        }
    }

    public void debug(String msg, Throwable t) {
        this.debug(msg);
        if (t != null) {
            t.printStackTrace();
        }
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        if (this.className != null) {
            this.print(INFO, msg, this.className);
        } else {
            this.print(INFO, msg);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        if (this.className != null) {
            this.print(WARN, msg, this.className);
        } else {
            this.print(WARN, msg);
        }
    }

    public void warn(String msg, Throwable t) {
        this.warn(msg);
        if (t != null) {
            t.printStackTrace();
        }
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        if (this.className != null) {
            this.print(ERROR, msg, this.className);
        } else {
            this.print(ERROR, msg);
        }
    }

    public void error(String msg, Throwable t) {
        this.error(msg);
        if (t != null) {
            t.printStackTrace();
        }
    }

    private void print(String level, String msg) {
        StringBuffer b = new StringBuffer();
        if (!donotPrintCurrentDate) {
            b.append(DateUtil.currentDate());
            b.append(SPACE);
        }
        if (!donotPrintLevel) {
            b.append(LEFT).append(level).append(RIGHT).append(SPACE);
        }
        b.append(msg);
        if (ERROR.equals(level) || WARN.equals(level)) {
            System.err.println(b.toString());
        } else {
            System.out.println(b.toString());
        }
    }

    private void print(String level, String msg, String className) {
        StringBuffer b = new StringBuffer();
        if (!donotPrintCurrentDate) {
            b.append(DateUtil.currentDate());
            b.append(SPACE);
        }
        if (!donotPrintLevel) {
            b.append(LEFT).append(level).append(RIGHT).append(SPACE);
        }
        b.append(LEFT).append(className).append(RIGHT).append(SPACE).append(msg);
        if (ERROR.equals(level) || WARN.equals(level)) {
            System.err.println(b.toString());
        } else {
            System.out.println(b.toString());
        }
    }
}

