/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.teasoft.honey.distribution.ds.Router;
import org.teasoft.honey.osql.core.CacheArrayIndex;
import org.teasoft.honey.osql.core.CacheDeleteThread;
import org.teasoft.honey.osql.core.CacheKey;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.Logger;

public final class CacheUtil {
    private static final int MAX_SIZE;
    private static final int timeout;
    private static ConcurrentHashMap<String, Integer> map;
    private static long[] time;
    private static Object[] obj;
    private static String[] keys;
    private static Map<String, Set<Integer>> map_tableIndexSet;
    private static Map<String, List<String>> map_tableKeyList;
    private static CacheArrayIndex arrayIndex;
    private static Map<String, String> neverCacheTableMap;
    private static Map<String, Integer> foreverCacheTableMap;
    private static Map<String, Integer> foreverCacheTableMap_sqlkey2exist;
    private static Map<String, Integer> foreverCacheModifySynTableMap;
    private static String NEVER;
    private static Integer FOREVER;
    private static Map<String, Set<String>> map_foreverSynTableIndexSet;
    private static Map<String, Object> foreverCacheObjectMap;
    private static Map<String, Object> foreverModifySynCacheObjectMap;
    private static boolean isShowSql;

    public static Object get(String sql) {
        String key = CacheKey.genKey(sql);
        if (key == null) {
            return null;
        }
        Integer index = map.get(key);
        if (index != null) {
            if (CacheUtil._isTimeout(index)) {
                if (!arrayIndex.isStartDelete()) {
                    CacheUtil.delCache(key);
                } else {
                    new CacheDeleteThread(index).begin();
                }
                return null;
            }
            if (isShowSql) {
                Logger.info("[Bee] ==========get from cache.");
            }
            HoneyContext.deleteCacheInfo(sql);
            return obj[index];
        }
        List<String> tableKeyList = CacheKey.genTabKeyList(sql);
        if (tableKeyList != null && tableKeyList.size() == 1) {
            Integer forever = CacheUtil._getConfigCacheTableMapValue(foreverCacheTableMap, tableKeyList);
            if (forever != null && foreverCacheTableMap_sqlkey2exist.get(key) != null) {
                Object obj = foreverCacheObjectMap.get(key);
                if (obj != null) {
                    HoneyContext.deleteCacheInfo(sql);
                    if (isShowSql) {
                        Logger.info("[Bee] ==========get from cache.");
                    }
                }
                return obj;
            }
            Integer foreverModifySyn = CacheUtil._getConfigCacheTableMapValue(foreverCacheModifySynTableMap, tableKeyList);
            if (foreverModifySyn != null) {
                Object obj = foreverModifySynCacheObjectMap.get(key);
                if (obj != null) {
                    HoneyContext.deleteCacheInfo(sql);
                    if (isShowSql) {
                        Logger.info("[Bee] ==========get from cache.");
                    }
                }
                return obj;
            }
        }
        return null;
    }

    private static void delCache(String key) {
        if (key == null) {
            return;
        }
        Integer i = map.get(key);
        if (i != null) {
            map.remove(key);
            CacheUtil.time[i.intValue()] = -1L;
            CacheUtil.obj[i.intValue()] = null;
            CacheUtil.keys[i.intValue()] = null;
            CacheUtil._delTableKeyListByKey(key, i);
        }
    }

    static void delCacheInBetween(int knowIndex) {
        int low = arrayIndex.getLow();
        int high = arrayIndex.getHigh();
        int know = knowIndex;
        if (low <= high) {
            for (int i = low; i <= know; ++i) {
                CacheUtil._deleteCacheByIndex(i);
            }
            arrayIndex.setLow(know + 1);
        } else if (low < know) {
            for (int i = low; i <= know; ++i) {
                CacheUtil._deleteCacheByIndex(i);
            }
            arrayIndex.setLow((know + 1) % MAX_SIZE);
        } else if (know < high) {
            int i;
            for (i = low; i < MAX_SIZE; ++i) {
                CacheUtil._deleteCacheByIndex(i);
            }
            for (i = 0; i <= know; ++i) {
                CacheUtil._deleteCacheByIndex(i);
            }
            arrayIndex.setLow(know + 1);
        }
    }

    private static void _deleteCacheByIndex(int i) {
        CacheUtil._deleteCacheByIndex(i, true);
    }

    private static void _deleteCacheByIndex(int i, boolean includeTableKey) {
        if (keys[i] != null) {
            map.remove(keys[i]);
            if (includeTableKey) {
                CacheUtil._delTableKeyListByKey(keys[i], i);
            }
        }
        CacheUtil.time[i] = -1L;
        CacheUtil.obj[i] = null;
        CacheUtil.keys[i] = null;
    }

    private static boolean _isTimeout(int index) {
        long now = System.currentTimeMillis();
        return time[index] > 0L && now - time[index] > (long)timeout;
    }

    public static void add(String sql, Object rs) {
        CacheUtil.addInCache(sql, rs);
    }

    static void addInCache(String sql, Object rs) {
        String key = CacheKey.genKey(sql);
        List<String> tableKeyList = CacheKey.genTabKeyList(sql);
        if (tableKeyList != null && tableKeyList.size() == 1 && CacheUtil._inConfigCacheTableMap(neverCacheTableMap, tableKeyList)) {
            HoneyContext.deleteCacheInfo(sql);
            return;
        }
        if (tableKeyList != null && tableKeyList.size() == 1) {
            if (CacheUtil._inConfigCacheTableMap(foreverCacheTableMap, tableKeyList) && foreverCacheTableMap_sqlkey2exist.get(key) == null) {
                foreverCacheTableMap_sqlkey2exist.put(key, 1);
                foreverCacheObjectMap.put(key, rs);
                HoneyContext.deleteCacheInfo(sql);
                return;
            }
            if (CacheUtil._inConfigCacheTableMap(foreverCacheModifySynTableMap, tableKeyList) && CacheUtil._getConfigCacheTableMapValue(foreverCacheModifySynTableMap, tableKeyList) == 0) {
                CacheUtil._regForeverSynTable(tableKeyList.get(0), key);
                foreverModifySynCacheObjectMap.put(key, rs);
                HoneyContext.deleteCacheInfo(sql);
                return;
            }
        }
        if (arrayIndex.isWouldbeFull()) {
            if (isShowSql) {
                Logger.warn("[Bee] ==========Cache would be full!");
            }
            new CacheDeleteThread(arrayIndex.getDeleteCacheIndex()).begin();
            if (arrayIndex.getUsedRate() >= 90) {
                if (isShowSql) {
                    Logger.warn("[Bee] ==========Cache already used more than 90% !");
                }
                HoneyContext.deleteCacheInfo(sql);
                return;
            }
        }
        tableKeyList = CacheKey.genTabKeyList(sql);
        HoneyContext.deleteCacheInfo(sql);
        int i = arrayIndex.getNext();
        long ms = System.currentTimeMillis();
        map.put(key, i);
        CacheUtil.time[i] = ms;
        CacheUtil.obj[i] = rs;
        CacheUtil.keys[i] = key;
        for (int k = 0; tableKeyList != null && k < tableKeyList.size(); ++k) {
            CacheUtil._regTabCache(tableKeyList.get(k), i);
            CacheUtil._addIntableKeyList(key, tableKeyList.get(k));
        }
    }

    private static void _regTabCache(String tableKey, int index) {
        Set<Integer> set = map_tableIndexSet.get(tableKey);
        if (set != null) {
            set.add(index);
        } else {
            set = new LinkedHashSet<Integer>();
            set.add(index);
            map_tableIndexSet.put(tableKey, set);
        }
    }

    private static void _regForeverSynTable(String tableKey, String sqlKey) {
        Set<String> set = map_foreverSynTableIndexSet.get(CacheUtil.adjust(tableKey));
        if (set != null) {
            set.add(sqlKey);
        } else {
            set = new HashSet<String>();
            set.add(sqlKey);
            map_foreverSynTableIndexSet.put(CacheUtil.adjust(tableKey), set);
        }
    }

    private static String adjust(String tableKey) {
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().enableMultiDs;
        int multiDsType = HoneyConfig.getHoneyConfig().multiDsType;
        if (enableMultiDs && multiDsType == 2) {
            String ds = Router.getDsName();
            tableKey = ds + "." + tableKey;
        }
        return tableKey;
    }

    public static void clear(String sql) {
        CacheUtil._clearForeverModifySyn(sql);
        CacheUtil._clearMoreTabCache(sql);
    }

    private static void _clearMoreTabCache(String sql) {
        List<String> tableKeyList = CacheKey.genTabKeyList(sql);
        HoneyContext.deleteCacheInfo(sql);
        for (int j = 0; tableKeyList != null && j < tableKeyList.size(); ++j) {
            CacheUtil._clearOneTabCache(tableKeyList.get(j));
        }
    }

    private static void _clearForeverModifySyn(String sql) {
        List<String> tableKeyList = CacheKey.genTabKeyList(sql);
        String key = CacheKey.genKey(sql);
        if (tableKeyList != null && tableKeyList.size() > 0) {
            for (int j = 0; j < tableKeyList.size(); ++j) {
                Integer k = CacheUtil._getConfigCacheTableMapValue(foreverCacheModifySynTableMap, tableKeyList);
                if (k == null) continue;
                CacheUtil._clearOneTabCache_ForeverModifySyn(tableKeyList.get(j));
            }
        }
    }

    private static void _clearOneTabCache_ForeverModifySyn(String tableKey) {
        Set<String> set = map_foreverSynTableIndexSet.get(CacheUtil.adjust(tableKey));
        if (set != null) {
            for (String i : set) {
                foreverModifySynCacheObjectMap.remove(i);
            }
            set = null;
            map_foreverSynTableIndexSet.remove(CacheUtil.adjust(tableKey));
        }
    }

    private static void _clearOneTabCache(String tableKey) {
        Set<Integer> set = map_tableIndexSet.get(tableKey);
        if (set != null) {
            for (Integer i : set) {
                CacheUtil._deleteCacheByIndex(i, false);
            }
            set = null;
            map_tableIndexSet.remove(tableKey);
        }
    }

    private static void _addIntableKeyList(String key, String tableKey) {
        List<String> tableKeyList = map_tableKeyList.get(key);
        if (tableKeyList != null) {
            tableKeyList.add(tableKey);
        } else {
            tableKeyList = new ArrayList<String>(3);
            tableKeyList.add(tableKey);
            map_tableKeyList.put(key, tableKeyList);
        }
    }

    private static void _delTableKeyListByKey(String key, int index) {
        List<String> tableKeyList = map_tableKeyList.get(key);
        for (int i = 0; tableKeyList != null && i < tableKeyList.size(); ++i) {
            CacheUtil._deleteTableIndexSet(tableKeyList.get(i), index);
        }
    }

    private static void _deleteTableIndexSet(String tableKey, int index) {
        Set<Integer> set = map_tableIndexSet.get(tableKey);
        if (set != null) {
            set.remove(index);
        }
    }

    private static boolean _inConfigCacheTableMap(Map map, List<String> list) {
        int multiDsType;
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().enableMultiDs;
        if (enableMultiDs && (multiDsType = HoneyConfig.getHoneyConfig().multiDsType) == 2) {
            String tableName = list.get(0);
            if (map.get(tableName.toLowerCase()) != null) {
                return true;
            }
            String ds = Router.getDsName();
            return map.get((ds + "." + tableName).toLowerCase()) != null;
        }
        return map.get(list.get(0).toLowerCase()) != null;
    }

    private static Integer _getConfigCacheTableMapValue(Map<String, Integer> map, List<String> list) {
        int multiDsType;
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().enableMultiDs;
        if (enableMultiDs && (multiDsType = HoneyConfig.getHoneyConfig().multiDsType) == 2) {
            String tableName = list.get(0);
            Integer v1 = map.get(tableName.toLowerCase());
            if (v1 != null) {
                return v1;
            }
            String ds = Router.getDsName();
            Integer v2 = map.get((ds + "." + tableName).toLowerCase());
            return v2;
        }
        return map.get(list.get(0).toLowerCase());
    }

    private static void initSpecialTable(String never, String forever, String foreverModifySyn) {
        int i;
        if (never != null) {
            String[] ns = never.split(",");
            for (i = 0; i < ns.length; ++i) {
                neverCacheTableMap.put(ns[i].trim().toLowerCase(), NEVER);
            }
        }
        if (forever != null) {
            String[] fs = forever.split(",");
            for (i = 0; i < fs.length; ++i) {
                foreverCacheTableMap.put(fs[i].trim().toLowerCase(), FOREVER);
            }
        }
        if (foreverModifySyn != null) {
            String[] fs_syn = foreverModifySyn.split(",");
            for (i = 0; i < fs_syn.length; ++i) {
                foreverCacheModifySynTableMap.put(fs_syn[i].trim().toLowerCase(), FOREVER);
            }
        }
    }

    static {
        neverCacheTableMap = new HashMap<String, String>();
        foreverCacheTableMap = new HashMap<String, Integer>();
        foreverCacheTableMap_sqlkey2exist = new HashMap<String, Integer>();
        foreverCacheModifySynTableMap = new HashMap<String, Integer>();
        NEVER = "1";
        FOREVER = 0;
        map_foreverSynTableIndexSet = new HashMap<String, Set<String>>();
        foreverCacheObjectMap = new HashMap<String, Object>();
        foreverModifySynCacheObjectMap = new Hashtable<String, Object>();
        isShowSql = false;
        MAX_SIZE = HoneyConfig.getHoneyConfig().getCacheMapSize();
        isShowSql = HoneyConfig.getHoneyConfig().isShowSQL();
        map = new ConcurrentHashMap();
        time = new long[MAX_SIZE];
        obj = new Object[MAX_SIZE];
        keys = new String[MAX_SIZE];
        map_tableIndexSet = new Hashtable<String, Set<Integer>>();
        map_tableKeyList = new Hashtable<String, List<String>>();
        timeout = HoneyConfig.getHoneyConfig().getCacheTimeout();
        arrayIndex = new CacheArrayIndex();
        CacheUtil.initSpecialTable(HoneyConfig.getHoneyConfig().getNeverCacheTableList(), HoneyConfig.getHoneyConfig().getForeverCacheTableList(), HoneyConfig.getHoneyConfig().getForeverCacheModifySynTableList());
    }
}

