/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.bee.osql.annotation.Entity;
import org.teasoft.bee.osql.annotation.Table;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.TokenUtil;

public class NameTranslateHandle {
    private static NameTranslate nameTranslat = BeeFactory.getHoneyFactory().getNameTranslate();
    private static ConcurrentMap<String, String> entity2tableMap;
    private static ConcurrentMap<String, String> table2entityMap;

    public static void setNameTranslat(NameTranslate nameTranslat) {
        NameTranslateHandle.nameTranslat = nameTranslat;
    }

    public static String toTableName(String entityName) {
        try {
            String flag = (String)OneTimeParameter.getAttribute("_SYS_Bee_DoNotCheckAnnotation");
            if (!"tRue".equals(flag)) {
                Class<?> obj = Class.forName(entityName);
                if (obj.isAnnotationPresent(Table.class)) {
                    Table tab = obj.getAnnotation(Table.class);
                    return NameTranslateHandle.processAutoPara(tab.value());
                }
                if (obj.isAnnotationPresent(Entity.class)) {
                    Entity tntity = obj.getAnnotation(Entity.class);
                    entityName = NameTranslateHandle.processAutoPara(tntity.value());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String tableName = (String)entity2tableMap.get(entityName);
        if (tableName != null && !"".equals(tableName.trim())) {
            return tableName;
        }
        int index = entityName.lastIndexOf(".");
        if (index > 0 && (tableName = (String)entity2tableMap.get(entityName = entityName.substring(index + 1))) != null && !"".equals(tableName.trim())) {
            return tableName;
        }
        return nameTranslat.toTableName(entityName);
    }

    public static String toColumnName(String fieldName) {
        return nameTranslat.toColumnName(fieldName);
    }

    public static String toEntityName(String tableName) {
        String entityName;
        if (table2entityMap == null) {
            table2entityMap = HoneyContext.getTable2entityMap();
        }
        if ((entityName = (String)table2entityMap.get(tableName)) != null && !"".equals(entityName.trim())) {
            return entityName;
        }
        return nameTranslat.toEntityName(tableName);
    }

    public static String toFieldName(String columnName) {
        return nameTranslat.toFieldName(columnName);
    }

    private static String processAutoPara(String autoPara) {
        int start = autoPara.indexOf("${");
        int end = autoPara.indexOf("}");
        if (start > 0 && end > 0 && start + 2 < end) {
            String key = autoPara.substring(start + 2, end);
            HashMap<String, String> map = new HashMap<String, String>();
            String value = (String)OneTimeParameter.getAttribute(key);
            if (value == null) {
                Logger.error("Auto table error: parameter  ${" + key + "} in " + autoPara + " still has not value!");
                return autoPara;
            }
            map.put(key, value);
            return TokenUtil.processWithMap(autoPara, "${", "}", map);
        }
        return autoPara;
    }

    static {
        table2entityMap = null;
        entity2tableMap = HoneyContext.getEntity2tableMap();
    }
}

