/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.ObjSQLIllegalSQLStringException;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeIllegalEntityException;
import org.teasoft.honey.distribution.GenIdFactory;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.ObjectToSQL;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlStrFilter;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.osql.core._ObjectToSQLHelper;
import org.teasoft.honey.osql.name.NameUtil;

public class ObjectToSQLRich
extends ObjectToSQL
implements ObjToSQLRich {
    private DbFeature dbFeature = BeeFactory.getHoneyFactory().getDbFeature();
    private static final String ASC = "asc";
    private static boolean showSQL = HoneyConfig.getHoneyConfig().isShowSQL();
    private int batchSize = HoneyConfig.getHoneyConfig().getBatchSize();
    private static String index1 = "_SYS[index";
    private static String index2 = "]_End ";
    private static String index3 = "]";

    public <T> String toSelectSQL(T entity, int size) {
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        this.regPagePlaceholder();
        sql = this.dbFeature.toPageSql(sql, size);
        HoneyUtil.setPageNum(wrap.getList());
        ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        Logger.logSQL("select SQL(entity,size): ", sql);
        return sql;
    }

    private void regPagePlaceholder() {
        HoneyUtil.regPagePlaceholder();
    }

    public <T> String toSelectSQL(T entity, int start, int size) {
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        this.regPagePlaceholder();
        sql = this.dbFeature.toPageSql(sql, start, size);
        HoneyUtil.setPageNum(wrap.getList());
        ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        Logger.logSQL("select(entity,start,size) SQL: ", sql);
        return sql;
    }

    public <T> String toSelectSQL(T entity, String selectFields, int start, int size) {
        SqlValueWrap wrap = this.toSelectSQL_0(entity, selectFields);
        String sql = wrap.getSql();
        this.regPagePlaceholder();
        sql = this.dbFeature.toPageSql(sql, start, size);
        HoneyUtil.setPageNum(wrap.getList());
        ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        Logger.logSQL("select(entity,selectFields,start,size) SQL: ", sql);
        return sql;
    }

    public <T> String toSelectSQL(T entity, String fields) throws ObjSQLException {
        String newSelectFields = HoneyUtil.checkSelectField(entity, fields);
        String sql = _ObjectToSQLHelper._toSelectSQL(entity, newSelectFields);
        Logger.logSQL("select SQL(selectFields) : ", sql);
        return sql;
    }

    public <T> String toSelectOrderBySQL(T entity, String orderFieldList) throws ObjSQLException {
        String[] orderFields = orderFieldList.split(",");
        int lenA = orderFields.length;
        String orderBy = "";
        for (int i = 0; i < lenA; ++i) {
            orderBy = orderBy + orderFields[i] + " " + ASC;
            if (i >= lenA - 1) continue;
            orderBy = orderBy + ",";
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = sql + "order by " + orderBy + " ;";
        ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        return sql;
    }

    public <T> String toSelectOrderBySQL(T entity, String orderFieldList, OrderType[] orderTypes) throws ObjSQLException {
        String[] orderFields = orderFieldList.split(",");
        int lenA = orderFields.length;
        if (lenA != orderTypes.length) {
            throw new ObjSQLException("ObjSQLException :The lenth of orderField is not equal orderTypes'.");
        }
        String orderBy = "";
        for (int i = 0; i < lenA; ++i) {
            orderBy = orderBy + orderFields[i] + " " + orderTypes[i].getName();
            if (i >= lenA - 1) continue;
            orderBy = orderBy + ",";
        }
        SqlValueWrap wrap = this.toSelectSQL_0(entity);
        String sql = wrap.getSql();
        sql = sql + "order by " + orderBy + " ;";
        ObjectToSQLRich.setContext(sql, wrap.getList(), wrap.getTableNames());
        return sql;
    }

    public <T> String toUpdateSQL(T entity, String updateFieldList) {
        if (updateFieldList == null) {
            return null;
        }
        String sql = "";
        String[] updateFields = updateFieldList.split(",");
        if (updateFields.length == 0 || "".equals(updateFieldList.trim())) {
            throw new ObjSQLException("ObjSQLException:updateFieldList at least include one field.");
        }
        sql = _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, -1);
        return sql;
    }

    public <T> String toUpdateSQL(T entity, String updateFieldList, IncludeType includeType) {
        if (updateFieldList == null) {
            return null;
        }
        String sql = "";
        String[] updateFields = updateFieldList.split(",");
        if (updateFields.length == 0 || "".equals(updateFieldList.trim())) {
            throw new ObjSQLException("ObjSQLException:updateFieldList at least include one field.");
        }
        sql = _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, includeType.getValue());
        return sql;
    }

    public <T> String toSelectFunSQL(T entity, FunctionType functionType, String fieldForFun) throws ObjSQLException {
        return this._toSelectFunSQL(entity, functionType.getName(), fieldForFun);
    }

    private <T> String _toSelectFunSQL(T entity, String funType, String fieldForFun) throws ObjSQLException {
        ObjectToSQLRich.checkPackage(entity);
        if (fieldForFun == null || funType == null) {
            return null;
        }
        boolean isContainField = false;
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = null;
        try {
            String tableName = this._toTableName(entity);
            String selectAndFun = "count".equalsIgnoreCase(funType) && "*".equals(fieldForFun) ? "select count(*) from " : "select " + funType + "(" + ObjectToSQLRich._toColumnName(fieldForFun) + ") from ";
            sqlBuffer.append(selectAndFun);
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i] != null && fields[i].isAnnotationPresent(JoinTable.class)) continue;
                if (fields[i].get(entity) == null || "serialVersionUID".equals(fields[i].getName())) {
                    if (!fields[i].getName().equals(fieldForFun) && (!"count".equalsIgnoreCase(funType) || !"*".equals(fieldForFun))) continue;
                    isContainField = true;
                    continue;
                }
                if (fields[i].getName().equals(fieldForFun)) {
                    isContainField = true;
                }
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(ObjectToSQLRich._toColumnName(fields[i].getName()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            sql = sqlBuffer.toString();
            ObjectToSQLRich.setContext(sql, list, tableName);
            if (SqlStrFilter.checkFunSql(sql, funType)) {
                throw new ObjSQLIllegalSQLStringException("ObjSQLIllegalSQLStringException:sql statement with function is illegal. " + sql);
            }
            Logger.logSQL("select fun SQL : ", sql);
            if (!isContainField) {
                throw new ObjSQLException("ObjSQLException:Miss The Field! The entity(" + tableName + ") don't contain the field:" + fieldForFun);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toSelectSQL(T entity, IncludeType includeType) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType.getValue());
    }

    public <T> String toDeleteSQL(T entity, IncludeType includeType) {
        return _ObjectToSQLHelper._toDeleteSQL(entity, includeType.getValue());
    }

    public <T> String toInsertSQL(T entity, IncludeType includeType) {
        String sql = null;
        try {
            _ObjectToSQLHelper.setInitIdByAuto(entity);
            sql = _ObjectToSQLHelper._toInsertSQL0(entity, includeType.getValue(), "");
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public <T> String toUpdateSQL(T entity, IncludeType includeType) {
        String sql = "";
        sql = _ObjectToSQLHelper._toUpdateSQL(entity, includeType.getValue());
        return sql;
    }

    public <T> String[] toInsertSQL(T[] entity) {
        return this.toInsertSQL(entity, "");
    }

    public <T> String[] toInsertSQL(T[] entity, int batchSize) {
        return this.toInsertSQL(entity, batchSize, "");
    }

    public <T> String[] toInsertSQL(T[] entity, String excludeFieldList) {
        return this.toInsertSQL(entity, this.batchSize, excludeFieldList);
    }

    public <T> String[] toInsertSQL(T[] entity, int batchSize, String excludeFieldList) {
        if (HoneyUtil.isMysql()) {
            return this.toInsertSQLForMysql(entity, batchSize, excludeFieldList);
        }
        String[] sql = null;
        try {
            int len = entity.length;
            this.setInitArrayIdByAuto(entity);
            sql = new String[len];
            String t_sql = "";
            sql[0] = t_sql = _ObjectToSQLHelper._toInsertSQL0(entity[0], 2, excludeFieldList);
            for (int i = 1; i < len; ++i) {
                String sql_i = index1 + i + index2 + sql[0];
                _ObjectToSQLHelper._toInsertSQL_for_ValueList(sql_i, entity[i], excludeFieldList);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private <T> String[] toInsertSQLForMysql(T[] entity, int batchSize, String excludeFieldList) {
        String[] sql = null;
        try {
            int len = entity.length;
            this.setInitArrayIdByAuto(entity);
            sql = new String[len];
            String t_sql = "";
            OneTimeParameter.setAttribute("_SYS_Bee_Return_PlaceholderValue", "tRue");
            sql[0] = t_sql = _ObjectToSQLHelper._toInsertSQL0(entity[0], 2, excludeFieldList);
            ArrayList<PreparedValue> preparedValueList = new ArrayList<PreparedValue>();
            if (showSQL) {
                preparedValueList.addAll(HoneyContext._justGetPreparedValue(sql[0]));
            } else {
                preparedValueList.addAll(HoneyContext.getPreparedValue(sql[0]));
            }
            if (len == 1) {
                HoneyContext.setPreparedValue(t_sql + index1 + "Batch:" + 0 + index2, preparedValueList);
            }
            for (int i = 1; i < len; ++i) {
                String sql_i = index1 + i + index2 + sql[0];
                List<PreparedValue> oneRecoreList = _ObjectToSQLHelper._toInsertSQL_for_ValueList(sql_i, entity[i], excludeFieldList);
                preparedValueList.addAll(oneRecoreList);
                if ((i + 1) % batchSize == 0) {
                    HoneyContext.setPreparedValue(t_sql + "  [Batch:" + i / batchSize + index3, preparedValueList);
                    preparedValueList = new ArrayList();
                    continue;
                }
                if (i != len - 1) continue;
                HoneyContext.setPreparedValue(t_sql + "  [Batch:" + i / batchSize + index3, preparedValueList);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    public String toDeleteByIdSQL(Class c, Integer id) {
        if (id == null) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Integer");
    }

    public String toDeleteByIdSQL(Class c, Long id) {
        if (id == null) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Long");
    }

    public String toDeleteByIdSQL(Class c, String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return null;
        }
        ObjectToSQLRich.checkPackageByClass(c);
        SqlValueWrap sqlBuffer = this.toDeleteByIdSQL0(c);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, ids);
    }

    private SqlValueWrap toDeleteByIdSQL0(Class c) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        String tableName = this._toTableNameByClass(c);
        sqlBuffer.append("delete from ").append(tableName).append(" where ");
        wrap.setValueBuffer(sqlBuffer);
        wrap.setTableNames(tableName);
        return wrap;
    }

    public <T> String toSelectByIdSQL(T entity, Integer id) {
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entity);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Integer");
    }

    public <T> String toSelectByIdSQL(T entity, Long id) {
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entity);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, id, "java.lang.Long");
    }

    public <T> String toSelectByIdSQL(T entity, String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return null;
        }
        SqlValueWrap sqlBuffer = this.toSelectByIdSQL0(entity);
        return this._toSelectAndDeleteByIdSQL(sqlBuffer, ids);
    }

    public <T> String toSelectSQL(T entity, IncludeType includeType, Condition condition) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType.getValue(), condition);
    }

    private <T> String _toUpdateBySQL(T entity, String whereFieldList, int includeType) {
        if (whereFieldList == null) {
            return null;
        }
        String sql = "";
        String[] whereFields = whereFieldList.split(",");
        if (whereFields.length == 0 || "".equals(whereFieldList.trim())) {
            throw new ObjSQLException("ObjSQLException:whereFieldList at least include one field.");
        }
        sql = _ObjectToSQLHelper._toUpdateBySQL(entity, whereFields, includeType);
        return sql;
    }

    public <T> String toUpdateBySQL(T entity, String whereFieldList) {
        return this._toUpdateBySQL(entity, whereFieldList, -1);
    }

    public <T> String toUpdateBySQL(T entity, String whereFieldList, IncludeType includeType) {
        return this._toUpdateBySQL(entity, whereFieldList, includeType.getValue());
    }

    public <T> String toUpdateBySQL(T entity, String whereFieldList, Condition condition) {
        String[] whereFields = whereFieldList.split(",");
        if (whereFields.length == 0 || "".equals(whereFieldList.trim())) {
            throw new ObjSQLException("ObjSQLException:whereFieldList at least include one field.");
        }
        if (condition == null || condition.getIncludeType() == null) {
            return _ObjectToSQLHelper._toUpdateBySQL(entity, whereFields, -1, condition);
        }
        return _ObjectToSQLHelper._toUpdateBySQL(entity, whereFields, condition.getIncludeType().getValue(), condition);
    }

    public <T> String toUpdateSQL(T entity, String updateFieldList, Condition condition) {
        if (updateFieldList == null) {
            updateFieldList = "";
        }
        String[] updateFields = updateFieldList.split(",");
        if (condition == null || condition.getIncludeType() == null) {
            return _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, -1, condition);
        }
        return _ObjectToSQLHelper._toUpdateSQL(entity, updateFields, condition.getIncludeType().getValue(), condition);
    }

    private <T> String _toSelectAndDeleteByIdSQL(SqlValueWrap wrap, Number id, String numType) {
        if (id == null) {
            return null;
        }
        StringBuffer sqlBuffer = wrap.getValueBuffer();
        sqlBuffer.append("id=").append("?");
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        preparedValue = new PreparedValue();
        preparedValue.setType(numType);
        preparedValue.setValue(id);
        list.add(preparedValue);
        ObjectToSQLRich.setContext(sqlBuffer.toString(), list, wrap.getTableNames());
        return sqlBuffer.toString();
    }

    private <T> String _toSelectAndDeleteByIdSQL(SqlValueWrap wrap, String ids) {
        StringBuffer sqlBuffer = wrap.getValueBuffer();
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        String[] idArray = ids.split(",");
        String t_ids = "id=?";
        preparedValue = new PreparedValue();
        preparedValue.setValue(idArray[0]);
        list.add(preparedValue);
        for (int i = 1; i < idArray.length; ++i) {
            preparedValue = new PreparedValue();
            t_ids = t_ids + " or id=?";
            preparedValue.setValue(idArray[i]);
            list.add(preparedValue);
        }
        sqlBuffer.append(t_ids);
        ObjectToSQLRich.setContext(sqlBuffer.toString(), list, wrap.getTableNames());
        return sqlBuffer.toString();
    }

    private <T> SqlValueWrap toSelectByIdSQL0(T entity) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        String tableName = this._toTableName(entity);
        Field[] fields = entity.getClass().getDeclaredFields();
        String packageAndClassName = entity.getClass().getName();
        String columnNames = HoneyContext.getBeanField(packageAndClassName);
        if (columnNames == null) {
            columnNames = HoneyUtil.getBeanField(fields);
            HoneyContext.addBeanField(packageAndClassName, columnNames);
        }
        sqlBuffer.append("select " + columnNames + " from ");
        sqlBuffer.append(tableName).append(" where ");
        wrap.setValueBuffer(sqlBuffer);
        wrap.setTableNames(tableName);
        return wrap;
    }

    private <T> SqlValueWrap toSelectSQL_0(T entity) {
        return this.toSelectSQL_0(entity, null);
    }

    private <T> SqlValueWrap toSelectSQL_0(T entity, String selectField) {
        StringBuffer sqlBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        try {
            String tableName = this._toTableName(entity);
            Field[] fields = entity.getClass().getDeclaredFields();
            String fieldNames = "";
            if (selectField != null && !"".equals(selectField.trim())) {
                fieldNames = HoneyUtil.checkSelectField(entity, selectField);
            } else {
                String packageAndClassName = entity.getClass().getName();
                fieldNames = HoneyContext.getBeanField(packageAndClassName);
                if (fieldNames == null) {
                    fieldNames = HoneyUtil.getBeanField(fields);
                    HoneyContext.addBeanField(packageAndClassName, fieldNames);
                }
            }
            sqlBuffer.append("select " + fieldNames + " from ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i].get(entity) == null || "serialVersionUID".equals(fields[i].getName()) || fields[i].isAnnotationPresent(JoinTable.class)) continue;
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(ObjectToSQLRich._toColumnName(fields[i].getName()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            wrap.setTableNames(tableName);
            wrap.setSql(sqlBuffer.toString());
            wrap.setList(list);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return wrap;
    }

    private static void setContext(String sql, List<PreparedValue> list, String tableName) {
        HoneyContext.setContext(sql, list, tableName);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    public static void checkPackageByClass(Class c) {
        if (c == null) {
            return;
        }
        String packageName = c.getPackage().getName();
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            throw new BeeIllegalEntityException("BeeIllegalEntityException: Illegal Entity, " + c.getName());
        }
    }

    private String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private String _toTableNameByClass(Class c) {
        return NameTranslateHandle.toTableName(c.getName());
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private <T> void setInitArrayIdByAuto(T[] entity) {
        if (entity == null || entity.length < 1) {
            return;
        }
        boolean needGenId = HoneyContext.isNeedGenId(entity[0].getClass());
        if (!needGenId) {
            return;
        }
        Field field = null;
        try {
            field = entity[0].getClass().getDeclaredField("id");
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (!field.getType().equals(Long.class)) {
            return;
        }
        int len = entity.length;
        String tableKey = this._toTableName(entity[0]);
        long[] ids = GenIdFactory.getRangeId(tableKey, len);
        long id = ids[0];
        for (int i = 0; i < len; ++i) {
            field.setAccessible(true);
            try {
                field.set(entity[i], id);
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
            ++id;
        }
    }
}

