/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import org.teasoft.bee.osql.BeeSQLException;
import org.teasoft.bee.osql.transaction.Transaction;
import org.teasoft.bee.osql.transaction.TransactionIsolationLevel;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.SessionFactory;

public class JdbcTransaction
implements Transaction {
    private Connection conn = null;
    private boolean oldAutoCommit;
    private boolean isBegin = false;

    private Connection initOneConn() {
        Connection c = null;
        c = SessionFactory.getConnection();
        return c;
    }

    public void begin() {
        try {
            this.conn = this.initOneConn();
            this.setOldAutoCommit(this.conn.getAutoCommit());
            this.conn.setAutoCommit(false);
            HoneyContext.setCurrentConnection(this.conn);
            this.isBegin = true;
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    public void commit() {
        if (!this.isBegin) {
            throw new BeeSQLException("The Transaction did not to begin!");
        }
        try {
            if (this.conn != null && !this.conn.getAutoCommit()) {
                this.conn.commit();
                if (this.oldAutoCommit != this.conn.getAutoCommit()) {
                    this.conn.setAutoCommit(this.oldAutoCommit);
                }
                this.close();
                this.isBegin = false;
            }
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    public void rollback() {
        try {
            if (this.conn != null && !this.conn.getAutoCommit()) {
                this.conn.rollback();
                if (this.oldAutoCommit != this.conn.getAutoCommit()) {
                    this.conn.setAutoCommit(this.oldAutoCommit);
                }
                this.close();
            }
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    public void setReadOnly(boolean readOnly) {
        try {
            this.conn.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    public void setTransactionIsolation(TransactionIsolationLevel level) {
        try {
            this.conn.setTransactionIsolation(level.getLevel());
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    public boolean isReadOnly() {
        try {
            return this.conn.isReadOnly();
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    public int getTransactionIsolation() {
        try {
            return this.conn.getTransactionIsolation();
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
    }

    public void setTimeout(int second) {
    }

    private void setOldAutoCommit(boolean oldAutoCommit) {
        this.oldAutoCommit = oldAutoCommit;
    }

    private void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                throw ExceptionHelper.convert(e);
            }
            finally {
                HoneyContext.removeCurrentConnection();
                boolean enableMultiDs = HoneyConfig.getHoneyConfig().enableMultiDs;
                int multiDsType = HoneyConfig.getHoneyConfig().multiDsType;
                if (enableMultiDs && multiDsType == 2) {
                    HoneyContext.removeCurrentRoute();
                }
            }
        }
    }
}

