/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.distribution.ds;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.teasoft.bee.distribution.ds.Route;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.exception.NoConfigException;
import org.teasoft.honey.distribution.ds.RouteStruct;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;

public class RwDs
implements Route {
    private String writeDd;
    private List<String> readDsList;
    private static int count = 0;
    private static int max_cout = 2146483647;
    private static Random r = new Random();
    private byte[] lock = new byte[0];
    private static int r_routeWay;

    public RwDs() {
        this.init();
    }

    private void init() {
        String wDB = HoneyConfig.getHoneyConfig().multiDs_writeDB;
        String rDB = HoneyConfig.getHoneyConfig().multiDs_readDB;
        if (wDB == null || "".equals(wDB.trim()) || rDB == null || "".equals(rDB.trim())) {
            throw new NoConfigException("Error: bee.dosql.multi-DS.writeDB and bee.dosql.multi-DS.readDB can not null or empty when bee.dosql.multi-DS.type=1! ");
        }
        this.setWriteDs(wDB);
        this.setReadDsList(this.parseRDb(rDB));
        this.getReadDsList().remove(wDB);
        r_routeWay = HoneyConfig.getHoneyConfig().rDbRouteWay;
    }

    private List<String> parseRDb(String rDB_str) {
        String[] s = rDB_str.split(",");
        ArrayList<String> rList = new ArrayList<String>();
        for (int i = 0; i < s.length; ++i) {
            rList.add(s[i]);
        }
        return rList;
    }

    public String getDsName() {
        RouteStruct routeStruct = HoneyContext.getCurrentRoute();
        if (routeStruct != null && SuidType.SELECT == routeStruct.getSuidType()) {
            return this.getReadDs(r_routeWay);
        }
        return this.getWriteDs();
    }

    public String getWriteDs() {
        return this.writeDd;
    }

    public void setWriteDs(String writeDs) {
        this.writeDd = writeDs;
    }

    public String getReadDs() {
        return this.getReadDs(0);
    }

    public String getReadDs(int type) {
        int index = 0;
        index = type == 1 ? this.poll() : this.rand();
        return this.getReadDsList().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int poll() {
        int size = this.readDsList.size();
        if (count > max_cout) {
            byte[] byArray = this.lock;
            // MONITORENTER : this.lock
            if (count > max_cout) {
                count = 0;
            }
            // MONITOREXIT : byArray
        }
        int index = count % size;
        ++count;
        return index;
    }

    private int rand() {
        int size = this.readDsList.size();
        int index = r.nextInt(size);
        return index;
    }

    public List<String> getReadDsList() {
        return this.readDsList;
    }

    public void setReadDsList(List<String> readDsList) {
        this.readDsList = readDsList;
    }
}

