/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.teasoft.bee.file.FileCreator;
import org.teasoft.honey.osql.core.Logger;

public class FileHandle
implements FileCreator {
    private String LINE_SEPARATOR = System.getProperty("line.separator");

    public void genFile(String fullPathAndName, String content) {
        File f = new File(fullPathAndName);
        if (!f.exists()) {
            String substr = fullPathAndName.substring(0, fullPathAndName.lastIndexOf(File.separator));
            new File(substr).mkdirs();
            Logger.info("Create file: " + fullPathAndName);
        }
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
            bw.write(content);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public void genFile(String fullPath, String fileName, String content) {
        File folder;
        if (!fullPath.endsWith(File.separator)) {
            fullPath = fullPath + File.separator;
        }
        if (!(folder = new File(fullPath)).exists()) {
            folder.mkdirs();
            Logger.info("Create file: " + fullPath + fileName);
        }
        File entityFile = new File(fullPath + fileName);
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(entityFile)));
            bw.write(content);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public void genFile(String basePath, String packagePath, String fileName, String content) {
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        String fullPath = basePath + packagePath.replace(".", File.separator) + File.separator;
        this.genFile(fullPath, fileName, content);
    }

    public void genAppendFile(String fullPathAndName, String content) {
        File f = new File(fullPathAndName);
        if (!f.exists()) {
            String substr = fullPathAndName.substring(0, fullPathAndName.lastIndexOf(File.separator));
            new File(substr).mkdirs();
        }
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f, true)));
            bw.write(content);
            bw.append(this.LINE_SEPARATOR);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public BufferedReader readFile(String fullPathAndName) {
        File file = new File(fullPathAndName);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
        }
        return reader;
    }
}

