/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidRich;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.ObjSQL;

public class ObjSQLRich
extends ObjSQL
implements SuidRich {
    private ObjToSQLRich objToSQLRich;

    public ObjToSQLRich getObjToSQLRich() {
        if (this.objToSQLRich == null) {
            this.objToSQLRich = BeeFactory.getHoneyFactory().getObjToSQLRich();
        }
        return this.objToSQLRich;
    }

    public void setObjToSQLRich(ObjToSQLRich objToSQLRich) {
        this.objToSQLRich = objToSQLRich;
    }

    public <T> List<T> select(T entity, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, size);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, start, size);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> select(T entity, String selectField) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectField);
        list = this.getBeeSql().selectSomeField(sql, entity);
        return list;
    }

    public <T> List<T> select(T entity, String selectFields, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields, start, size);
        list = this.getBeeSql().selectSomeField(sql, entity);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFields) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectOrderBySQL(entity, orderFields);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> List<T> selectOrderBy(T entity, String orderFields, OrderType[] orderTypes) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectOrderBySQL(entity, orderFields, orderTypes);
        Logger.logSQL("selectOrderBy SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> int insert(T[] entity) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity);
        this._regEntityClass(entity[0]);
        return this.getBeeSql().batch(insertSql);
    }

    public <T> int insert(T[] entity, String excludeFields) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity, excludeFields);
        this._regEntityClass(entity[0]);
        return this.getBeeSql().batch(insertSql);
    }

    public <T> int insert(T[] entity, int batchSize) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity, batchSize);
        this._regEntityClass(entity[0]);
        return this.getBeeSql().batch(insertSql, batchSize);
    }

    public <T> int insert(T[] entity, int batchSize, String excludeFields) {
        if (entity == null || entity.length < 1) {
            return -1;
        }
        String[] insertSql = this.getObjToSQLRich().toInsertSQL((Object[])entity, batchSize, excludeFields);
        this._regEntityClass(entity[0]);
        return this.getBeeSql().batch(insertSql, batchSize);
    }

    public <T> int update(T entity, String updateFields) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields);
        Logger.logSQL("update SQL(updateFields) :", sql);
        this._regEntityClass(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> T selectOne(T entity) {
        if (entity == null) {
            return null;
        }
        List<T> list = this.select(entity);
        if (list == null || list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    public <T> String selectWithFun(T entity, FunctionType functionType, String fieldForFun) {
        if (entity == null) {
            return null;
        }
        String s = null;
        String sql = this.getObjToSQLRich().toSelectFunSQL(entity, functionType, fieldForFun);
        this._regEntityClass(entity);
        s = this.getBeeSql().selectFun(sql);
        return s;
    }

    public <T> int update(T entity, String updateFields, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields, includeType);
        Logger.logSQL("update SQL(updateFields) :", sql);
        this._regEntityClass(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> List<T> select(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType);
        Logger.logSQL("select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> int update(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, includeType);
        Logger.logSQL("update SQL: ", sql);
        this._regEntityClass(entity);
        return this.getBeeSql().modify(sql);
    }

    public <T> int insert(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        String sql = this.getObjToSQLRich().toInsertSQL(entity, includeType);
        Logger.logSQL("insert SQL: ", sql);
        this._regEntityClass(entity);
        return this.getBeeSql().modify(sql);
    }

    public <T> int delete(T entity, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        String sql = this.getObjToSQLRich().toDeleteSQL(entity, includeType);
        Logger.logSQL("delete SQL: ", sql);
        this._regEntityClass(entity);
        return this.getBeeSql().modify(sql);
    }

    public <T> List<String[]> selectString(T entity) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity);
        Logger.logSQL("List<String[]> select SQL: ", sql);
        this._regEntityClass(entity);
        list = this.getBeeSql().select(sql);
        return list;
    }

    public <T> List<String[]> selectString(T entity, String selectFields) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQLRich().toSelectSQL(entity, selectFields);
        this._regEntityClass(entity);
        list = this.getBeeSql().select(sql);
        return list;
    }

    public <T> String selectJson(T entity) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity);
        Logger.logSQL("selectJson SQL: ", sql);
        this._regEntityClass(entity);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> String selectJson(T entity, IncludeType includeType) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType);
        Logger.logSQL("selectJson SQL: ", sql);
        this._regEntityClass(entity);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> List<T> selectById(T entity, Integer id) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, id);
        Logger.logSQL("selectById SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> selectById(T entity, Long id) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, id);
        Logger.logSQL("selectById SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> List<T> selectById(T entity, String ids) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectByIdSQL(entity, ids);
        Logger.logSQL("selectById SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public int deleteById(Class c, Integer id) {
        if (c == null) {
            return 0;
        }
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, id);
        Logger.logSQL("deleteById SQL: ", sql);
        this._regEntityClass2(c);
        return this.getBeeSql().modify(sql);
    }

    public int deleteById(Class c, Long id) {
        if (c == null) {
            return 0;
        }
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, id);
        Logger.logSQL("deleteById SQL: ", sql);
        this._regEntityClass2(c);
        return this.getBeeSql().modify(sql);
    }

    public int deleteById(Class c, String ids) {
        if (c == null) {
            return 0;
        }
        String sql = this.getObjToSQLRich().toDeleteByIdSQL(c, ids);
        Logger.logSQL("deleteById SQL: ", sql);
        this._regEntityClass2(c);
        return this.getBeeSql().modify(sql);
    }

    @Deprecated
    public <T> List<T> select(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType, condition);
        Logger.logSQL("select SQL: ", sql);
        return this.getBeeSql().select(sql, entity);
    }

    public <T> String selectJson(T entity, IncludeType includeType, Condition condition) {
        if (entity == null) {
            return null;
        }
        String sql = this.getObjToSQLRich().toSelectSQL(entity, includeType, condition);
        Logger.logSQL("selectJson SQL: ", sql);
        this._regEntityClass(entity);
        return this.getBeeSql().selectJson(sql);
    }

    public <T> int updateBy(T entity, String whereFields) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields);
        Logger.logSQL("update SQL(whereFields) :", sql);
        this._regEntityClass(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int updateBy(T entity, String whereFields, IncludeType includeType) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields, includeType);
        Logger.logSQL("update SQL(whereFields) :", sql);
        this._regEntityClass(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int updateBy(T entity, String whereFields, Condition condition) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateBySQL(entity, whereFields, condition);
        Logger.logSQL("update SQL(whereFields) :", sql);
        this._regEntityClass(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int update(T entity, String updateFields, Condition condition) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, updateFields, condition);
        Logger.logSQL("update SQL(updateFields) :", sql);
        this._regEntityClass(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    public <T> int update(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        int r = 0;
        String sql = this.getObjToSQLRich().toUpdateSQL(entity, "", condition);
        Logger.logSQL("update SQL(condition) :", sql);
        this._regEntityClass(entity);
        r = this.getBeeSql().modify(sql);
        return r;
    }

    private <T> void _regEntityClass(T entity) {
        if (entity == null) {
            return;
        }
        HoneyContext.regEntityClass(entity.getClass());
    }

    private void _regEntityClass2(Class clazz) {
        HoneyContext.regEntityClass(clazz);
    }
}

