/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.JoinType;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ConditionHelper;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;

public class _MoreObjectToSQLHelper {
    private static DbFeature dbFeature = BeeFactory.getHoneyFactory().getDbFeature();
    private static String COMMA = ",";
    private static String ONE_SPACE = " ";
    private static String DOT = ".";

    static <T> String _toSelectSQL(T entity) {
        return _MoreObjectToSQLHelper._toSelectSQL(entity, -1, null, -1, -1);
    }

    static <T> String _toSelectSQL(T entity, int start, int size) {
        return _MoreObjectToSQLHelper._toSelectSQL(entity, -1, null, start, size);
    }

    static <T> String _toSelectSQL(T entity, Condition condition) {
        int includeType = condition == null || condition.getIncludeType() == null ? -1 : condition.getIncludeType().getValue();
        return _MoreObjectToSQLHelper._toSelectSQL(entity, includeType, condition, -1, -1);
    }

    private static <T> String _toSelectSQL(T entity, int includeType, Condition condition, int start, int size) {
        _MoreObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        Set conditionFieldSet = null;
        if (condition != null) {
            conditionFieldSet = condition.getFieldSet();
        }
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlBuffer2 = new StringBuffer();
        try {
            Field[] fields = entity.getClass().getDeclaredFields();
            MoreTableStruct[] moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity);
            boolean twoTablesWithJoinOnStyle = HoneyConfig.getHoneyConfig().isTablesWithJoinOnStyle();
            boolean moreTable_columnListWithStar = HoneyConfig.getHoneyConfig().isMoreTable_columnListWithStar();
            String columnNames = moreTableStruct[0].columnsFull;
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
                String selectField = ConditionHelper.processSelectField(columnNames, condition);
                if (selectField != null) {
                    columnNames = selectField;
                } else if (moreTable_columnListWithStar) {
                    columnNames = "*";
                }
            }
            String tableName = moreTableStruct[0].tableName;
            sqlBuffer.append(K.select).append(" ").append(columnNames).append(" ").append(K.from).append(" ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            String[] useSubTableNames = new String[2];
            if (moreTableStruct[0].joinTableNum > 1 && twoTablesWithJoinOnStyle && moreTableStruct[1].joinType == JoinType.JOIN) {
                Logger.warn("SQL grammar type will use 'where ... =' replace 'join .. on' !");
            }
            if ((moreTableStruct[1].joinType != JoinType.JOIN || twoTablesWithJoinOnStyle && moreTableStruct[0].joinTableNum == 1) && moreTableStruct[1].joinExpression != null && !"".equals(moreTableStruct[1].joinExpression)) {
                if (moreTableStruct[1].joinType == JoinType.FULL_JOIN) {
                    Logger.warn("Pleae confirm the Database supports 'full join' type!");
                }
                if (HoneyUtil.isSqlKeyWordUpper()) {
                    sqlBuffer.append(moreTableStruct[1].joinType.getType().toUpperCase());
                } else {
                    sqlBuffer.append(moreTableStruct[1].joinType.getType());
                }
                sqlBuffer.append(moreTableStruct[1].tableName);
                if (moreTableStruct[1].hasSubAlias) {
                    sqlBuffer.append(ONE_SPACE);
                    sqlBuffer.append(moreTableStruct[1].subAlias);
                }
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(K.on);
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(moreTableStruct[1].joinExpression);
            } else {
                for (int s = 1; s <= 2; ++s) {
                    if (moreTableStruct[s] == null) continue;
                    useSubTableNames[s - 1] = moreTableStruct[s].useSubTableName;
                    sqlBuffer.append(COMMA);
                    sqlBuffer.append(moreTableStruct[s].tableName);
                    if (moreTableStruct[s].hasSubAlias) {
                        sqlBuffer.append(ONE_SPACE);
                        sqlBuffer.append(moreTableStruct[s].subAlias);
                    }
                    if (moreTableStruct[s].joinExpression == null || "".equals(moreTableStruct[s].joinExpression)) continue;
                    if (firstWhere) {
                        sqlBuffer2.append(" ").append(K.where).append(" ");
                        firstWhere = false;
                    } else {
                        sqlBuffer2.append(" ").append(K.and).append(" ");
                    }
                    sqlBuffer2.append(moreTableStruct[s].joinExpression);
                }
            }
            int len = fields.length;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName()) || conditionFieldSet != null && conditionFieldSet.contains(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer2.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer2.append(" ").append(K.and).append(" ");
                }
                sqlBuffer2.append(tableName);
                sqlBuffer2.append(DOT);
                sqlBuffer2.append(_MoreObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer2.append(" ").append(K.isNull);
                    continue;
                }
                sqlBuffer2.append("=");
                sqlBuffer2.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            sqlBuffer.append(sqlBuffer2);
            for (int index = 1; index <= 2; ++index) {
                if (moreTableStruct[index] == null) continue;
                firstWhere = _MoreObjectToSQLHelper.parseSubObject(sqlBuffer, list, conditionFieldSet, firstWhere, includeType, moreTableStruct, index);
            }
            if (condition != null) {
                condition.setSuidType(SuidType.SELECT);
                ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere, useSubTableNames);
            }
            if (start != -1 && size != -1) {
                HoneyUtil.regPagePlaceholder();
                sql = dbFeature.toPageSql(sqlBuffer.toString(), start, size);
                HoneyUtil.setPageNum(list);
            } else {
                sql = sqlBuffer.toString();
            }
            HoneyContext.setPreparedValue(sql, list);
            _MoreObjectToSQLHelper.addInContextForCache(sql, tableName);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private static boolean parseSubObject(StringBuffer sqlBuffer2, List<PreparedValue> list, Set<String> conditionFieldSet, boolean firstWhere, int includeType, MoreTableStruct[] moreTableStruct, int index) {
        Object entity = moreTableStruct[index].subObject;
        if (entity == null) {
            return firstWhere;
        }
        PreparedValue preparedValue = null;
        String useSubTableName = moreTableStruct[index].useSubTableName;
        Field[] fields = moreTableStruct[index].subEntityField.getType().getDeclaredFields();
        int len = fields.length;
        try {
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName()) || conditionFieldSet != null && conditionFieldSet.contains(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer2.append(" ").append(K.where).append(" ");
                    firstWhere = false;
                } else {
                    sqlBuffer2.append(" ").append(K.and).append(" ");
                }
                sqlBuffer2.append(useSubTableName);
                sqlBuffer2.append(DOT);
                sqlBuffer2.append(_MoreObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer2.append(" ").append(K.isNull);
                    continue;
                }
                sqlBuffer2.append("=");
                sqlBuffer2.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(preparedValue);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return firstWhere;
    }

    static void addInContextForCache(String sql, String tableName) {
        CacheSuidStruct struct = new CacheSuidStruct();
        struct.setSql(sql);
        struct.setTableNames(tableName);
        HoneyContext.setCacheInfo(sql, struct);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }
}

