/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.distribution;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teasoft.bee.distribution.GenId;
import org.teasoft.honey.distribution.OneTimeSnowflakeId;
import org.teasoft.honey.distribution.PearFlowerId;
import org.teasoft.honey.distribution.SerialUniqueId;
import org.teasoft.honey.osql.core.HoneyConfig;

public class GenIdFactory {
    private static GenId genId;
    private static Map<String, GenId> map;
    private static String defaultGenType;

    public static long get() {
        return GenIdFactory.get("");
    }

    public static long[] getRangeId(int sizeOfIds) {
        return GenIdFactory.getRangeId("", sizeOfIds);
    }

    public static long get(String bizType) {
        return GenIdFactory.get(bizType, defaultGenType);
    }

    public static long get(String bizType, String genType) {
        genId = GenIdFactory.getGenId(bizType, genType);
        return genId.get();
    }

    public static long[] getRangeId(String bizType, int sizeOfIds) {
        return GenIdFactory.getRangeId(bizType, defaultGenType, sizeOfIds);
    }

    public static long[] getRangeId(String bizType, String genType, int sizeOfIds) {
        genId = GenIdFactory.getGenId(bizType, genType);
        return genId.getRangeId(sizeOfIds);
    }

    private static GenId getGenId(String bizType, String genType) {
        String key = genType + "::" + bizType;
        genId = map.get(key);
        if (genId == null) {
            switch (genType) {
                case "SerialUniqueId": {
                    genId = new SerialUniqueId();
                    break;
                }
                case "OneTimeSnowflakeId": {
                    genId = new OneTimeSnowflakeId();
                    break;
                }
                case "PearFlowerId": {
                    genId = new PearFlowerId();
                }
            }
            map.put(key, genId);
        }
        return genId;
    }

    static {
        map = new ConcurrentHashMap<String, GenId>();
        int idGenerator = HoneyConfig.getHoneyConfig().idGeneratorType;
        defaultGenType = idGenerator == 1 ? "SerialUniqueId" : (idGenerator == 2 ? "OneTimeSnowflakeId" : (idGenerator == 3 ? "PearFlowerId" : "SerialUniqueId"));
    }
}

