/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.logging;

import org.teasoft.bee.logging.Log;
import org.teasoft.bee.logging.Path;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.util.DateUtil;
import org.teasoft.honey.osql.util.FileUtil;

public class FileLogger
implements Log {
    private String className = null;
    private String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String TRACE = "TRACE";
    private static String DEBUG = "DEBUG";
    private static String INFO = "INFO";
    private static String WARN = "WARN";
    private static String ERROR = "ERROR";
    private static String SPACE = " ";
    private static String LEFT = "[";
    private static String RIGHT = "]";
    private static boolean donotPrintCurrentDate = HoneyConfig.getHoneyConfig().isShowSQL_donotPrint_currentDate();
    private static boolean donotPrintLevel = HoneyConfig.getHoneyConfig().isLog_donotPrint_level();

    public FileLogger() {
    }

    public FileLogger(String className) {
        this.className = className;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        if (this.className != null) {
            this.print(TRACE, msg, this.className);
        } else {
            this.print(TRACE, msg);
        }
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        if (this.className != null) {
            this.print(DEBUG, msg, this.className);
        } else {
            this.print(DEBUG, msg);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.className != null) {
            this.print(DEBUG, msg + this.LINE_SEPARATOR + t.getMessage(), this.className);
        } else {
            this.print(DEBUG, msg + this.LINE_SEPARATOR + t.getMessage());
        }
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        if (this.className != null) {
            this.print(INFO, msg, this.className);
        } else {
            this.print(INFO, msg);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        if (this.className != null) {
            this.print(WARN, msg, this.className);
        } else {
            this.print(WARN, msg);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.className != null) {
            this.print(WARN, msg + this.LINE_SEPARATOR + t.getMessage(), this.className);
        } else {
            this.print(WARN, msg + this.LINE_SEPARATOR + t.getMessage());
        }
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        if (this.className != null) {
            this.print(ERROR, msg, this.className);
        } else {
            this.print(ERROR, msg);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.className != null) {
            this.print(ERROR, msg + this.LINE_SEPARATOR + t.getMessage(), this.className);
        } else {
            this.print(ERROR, msg + this.LINE_SEPARATOR + t.getMessage());
        }
    }

    private void print(String level, String msg) {
        StringBuffer b = new StringBuffer();
        if (!donotPrintCurrentDate) {
            b.append(DateUtil.currentDate());
            b.append(SPACE);
        }
        if (!donotPrintLevel) {
            b.append(LEFT).append(level).append(RIGHT).append(SPACE);
        }
        b.append(msg);
        this.appendFile(b.toString());
    }

    private void print(String level, String msg, String className) {
        StringBuffer b = new StringBuffer();
        if (!donotPrintCurrentDate) {
            b.append(DateUtil.currentDate());
            b.append(SPACE);
        }
        if (!donotPrintLevel) {
            b.append(LEFT).append(level).append(RIGHT).append(SPACE);
        }
        b.append(LEFT).append(className).append(RIGHT).append(SPACE).append(msg);
        this.appendFile(b.toString());
    }

    private void appendFile(String content) {
        FileUtil.genAppendFile(Path.getFullPath(), content);
    }
}

