/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.logging;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.teasoft.bee.logging.Log;
import org.teasoft.honey.osql.core.HoneyConfig;

public class LoggerFactory {
    private static Constructor<? extends Log> logConstructor;
    private static Constructor<? extends Log> logNoArgConstructor;
    private static ThreadLocal<Map<String, Log>> logLocal;
    private static boolean isNoArgInConstructor;

    private static void tryImplementation(String testClassName, String implClassName) {
        if (logConstructor != null) {
            return;
        }
        if (isNoArgInConstructor && logNoArgConstructor != null) {
            return;
        }
        try {
            if (implClassName != null && (implClassName.endsWith(".Log4jImpl") || implClassName.endsWith(".Slf4jImpl") || implClassName.endsWith(".SystemLogger") || implClassName.endsWith(".NoLogging") || implClassName.endsWith(".FileLogger"))) {
                try {
                    if (testClassName != null && !"".equals(testClassName)) {
                        LoggerFactory.genClassByName(testClassName);
                    }
                    Class<?> implClassNoArg = LoggerFactory.genClassByName(implClassName);
                    logNoArgConstructor = implClassNoArg.getConstructor(new Class[0]);
                    isNoArgInConstructor = true;
                }
                catch (ClassNotFoundException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (testClassName != null && !"".equals(testClassName)) {
                LoggerFactory.genClassByName(testClassName);
            }
            Class<?> implClass = LoggerFactory.genClassByName(implClassName);
            logConstructor = implClass.getConstructor(String.class);
            System.out.println("[Bee] LoggerFactory Use the Logger is : " + implClassName);
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static Log getLog() {
        Log cacheLog = LoggerFactory.getCacheInfo("NoArg");
        if (cacheLog != null) {
            return cacheLog;
        }
        Log log = null;
        try {
            if (isNoArgInConstructor) {
                log = logNoArgConstructor.newInstance(new Object[0]);
                LoggerFactory.setCacheInfo("NoArg", log);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (log != null) {
            return log;
        }
        log = LoggerFactory.getLog(LoggerFactory.class.getName());
        return log;
    }

    public static Log getLog(Class clazz) {
        return LoggerFactory.getLog(clazz.getName());
    }

    public static Log getLog(String loggerName) {
        Log cacheLog;
        if (loggerName == null || "".equals(loggerName.trim())) {
            loggerName = LoggerFactory.class.getName();
        }
        if ((cacheLog = LoggerFactory.getCacheInfo(loggerName)) != null) {
            return cacheLog;
        }
        try {
            Log log = logConstructor.newInstance(loggerName);
            LoggerFactory.setCacheInfo(loggerName, log);
            return log;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating logger'" + loggerName + "'.  Cause by: " + t, t);
        }
    }

    private static Class<?> genClassByName(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static boolean isNoArgInConstructor() {
        return isNoArgInConstructor;
    }

    private static void setCacheInfo(String key, Log logger) {
        if (logger == null) {
            return;
        }
        if (key == null || "".equals(key.trim())) {
            return;
        }
        Map<String, Log> map = logLocal.get();
        if (null == map) {
            map = new HashMap<String, Log>();
        }
        map.put(key, logger);
        logLocal.set(map);
    }

    private static Log getCacheInfo(String key) {
        Map<String, Log> map = logLocal.get();
        if (null == map) {
            return null;
        }
        Log temp = map.get(key);
        return temp;
    }

    static {
        logLocal = new ThreadLocal();
        String loggerType = HoneyConfig.getHoneyConfig().loggerType;
        if (loggerType != null && !"".equals(loggerType.trim())) {
            if ((loggerType = loggerType.trim()).equalsIgnoreCase("log4j")) {
                LoggerFactory.tryImplementation("org.apache.log4j.Logger", "org.teasoft.beex.logging.Log4jImpl");
            } else if (loggerType.equalsIgnoreCase("slf4j")) {
                LoggerFactory.tryImplementation("org.slf4j.Logger", "org.teasoft.beex.logging.Slf4jImpl");
            } else if (loggerType.equalsIgnoreCase("log4j2")) {
                LoggerFactory.tryImplementation("org.apache.logging.log4j.Logger", "org.teasoft.beex.logging.Log4j2Impl");
            } else if (loggerType.equalsIgnoreCase("commonsLog")) {
                LoggerFactory.tryImplementation("org.apache.commons.logging.LogFactory", "org.teasoft.beex.logging.JakartaCommonsLoggingImpl");
            } else if (loggerType.equalsIgnoreCase("systemLogger")) {
                LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.SystemLogger");
            } else if (loggerType.equalsIgnoreCase("fileLogger")) {
                LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.FileLogger");
            } else if (loggerType.equalsIgnoreCase("noLogging")) {
                LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.NoLogging");
            } else if (loggerType.equalsIgnoreCase("jdkLog")) {
                LoggerFactory.tryImplementation("java.util.logging.Logger", "org.teasoft.honey.logging.Jdk14LoggingImpl");
            }
        }
        LoggerFactory.tryImplementation("org.apache.log4j.Logger", "org.teasoft.beex.logging.Log4jImpl");
        LoggerFactory.tryImplementation("org.slf4j.Logger", "org.teasoft.beex.logging.Slf4jImpl");
        LoggerFactory.tryImplementation("org.apache.logging.log4j.Logger", "org.teasoft.beex.logging.Log4j2Impl");
        LoggerFactory.tryImplementation("org.apache.commons.logging.LogFactory", "org.teasoft.beex.logging.JakartaCommonsLoggingImpl");
        LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.SystemLogger");
        LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.FileLogger");
        LoggerFactory.tryImplementation("", "org.teasoft.honey.logging.NoLogging");
        LoggerFactory.tryImplementation("java.util.logging.Logger", "org.teasoft.honey.logging.Jdk14LoggingImpl");
    }
}

