/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.autogen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeException;
import org.teasoft.honey.osql.autogen.GenConfig;
import org.teasoft.honey.osql.autogen.Table;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.SessionFactory;
import org.teasoft.honey.osql.util.DateUtil;

public class GenBean {
    private GenConfig config;
    private String LINE_SEPARATOR = System.getProperty("line.separator");

    public GenBean(GenConfig config) {
        this.config = config;
    }

    private void genBeanFile(Table table) {
        String entitySaveDir;
        File folder;
        String tableName = table.getTableName();
        List<String> columnNames = table.getColumNames();
        List<String> columTypes = table.getColumTypes();
        Map<String, String> commentMap = table.getCommentMap();
        String entityName = "";
        entityName = NameTranslateHandle.toEntityName(tableName);
        if (this.config.getEntityNamePre() != null) {
            entityName = this.config.getEntityNamePre() + entityName;
        }
        Logger.info("The Honey gen the JavaBean: " + this.config.getPackagePath() + "." + entityName);
        String tableComment = "";
        if (this.config.isGenComment()) {
            tableComment = commentMap.get(table.getTableName());
        }
        String authorComment = "/**" + this.LINE_SEPARATOR;
        if (this.config.isGenComment() && !"".equals(tableComment)) {
            authorComment = authorComment + "*" + tableComment + this.LINE_SEPARATOR;
        }
        authorComment = authorComment + "*@author Honey" + this.LINE_SEPARATOR;
        authorComment = authorComment + "*Create on " + DateUtil.currentDate() + this.LINE_SEPARATOR;
        authorComment = authorComment + "*/";
        String packageStr = "package " + this.config.getPackagePath() + ";" + this.LINE_SEPARATOR;
        String importStr = "";
        String propertyName = "";
        String propertiesStr = "";
        String getsetStr = "";
        String getsetProNameStr = "";
        String javaType = "";
        boolean bigIntegerFlag = true;
        boolean bigDecimalFlag = true;
        boolean dateFlag = true;
        boolean timeFlag = true;
        boolean timestampFlag = true;
        boolean blobFlag = true;
        boolean clobFlag = true;
        boolean arrayFlag = true;
        StringBuffer tostr = new StringBuffer();
        if (this.config.isGenSerializable()) {
            importStr = importStr + "import java.io.Serializable;" + this.LINE_SEPARATOR;
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            String columnType = columTypes.get(i);
            String comment = "";
            String getOrIs = "get";
            propertyName = NameTranslateHandle.toFieldName(columnName);
            getsetProNameStr = HoneyUtil.firstLetterToUpperCase(propertyName);
            javaType = HoneyUtil.getFieldType(columnType);
            if ("BigDecimal".equals(javaType) && bigDecimalFlag) {
                importStr = importStr + "import java.math.BigDecimal;" + this.LINE_SEPARATOR;
                bigDecimalFlag = false;
            } else if ("BigInteger".equals(javaType) && bigIntegerFlag) {
                importStr = importStr + "import java.math.BigInteger;" + this.LINE_SEPARATOR;
                bigIntegerFlag = false;
            } else if ("Date".equals(javaType) && dateFlag) {
                importStr = importStr + "import java.sql.Date;" + this.LINE_SEPARATOR;
                dateFlag = false;
            } else if ("Time".equals(javaType) && timeFlag) {
                importStr = importStr + "import java.sql.Time;" + this.LINE_SEPARATOR;
                timeFlag = false;
            } else if ("Timestamp".equals(javaType) && timestampFlag) {
                importStr = importStr + "import java.sql.Timestamp;" + this.LINE_SEPARATOR;
                timestampFlag = false;
            } else if ("Blob".equals(javaType) && blobFlag) {
                importStr = importStr + "import java.sql.Blob;" + this.LINE_SEPARATOR;
                blobFlag = false;
            } else if ("Clob".equals(javaType) && clobFlag) {
                importStr = importStr + "import java.sql.Clob;" + this.LINE_SEPARATOR;
                clobFlag = false;
            } else if ("Array".equals(javaType) && arrayFlag) {
                importStr = importStr + "import java.sql.Array;" + this.LINE_SEPARATOR;
                arrayFlag = false;
            }
            if ("boolean".equals(javaType)) {
                getOrIs = "is";
            }
            if (this.config.isGenComment() && commentMap != null) {
                comment = commentMap.get(columnName);
                if (this.config.getCommentPlace() == 2) {
                    if (!"".equals(comment)) {
                        propertiesStr = propertiesStr + "\t// " + comment + this.LINE_SEPARATOR;
                    }
                    propertiesStr = propertiesStr + "\tprivate " + javaType + " " + propertyName + ";" + this.LINE_SEPARATOR;
                } else {
                    propertiesStr = propertiesStr + "\tprivate " + javaType + " " + propertyName + ";";
                    if (!"".equals(comment)) {
                        propertiesStr = propertiesStr + "//" + comment;
                    }
                    propertiesStr = propertiesStr + this.LINE_SEPARATOR;
                }
            } else {
                propertiesStr = propertiesStr + "\tprivate " + javaType + " " + propertyName + ";" + this.LINE_SEPARATOR;
            }
            getsetStr = getsetStr + "\tpublic " + javaType + " " + getOrIs + getsetProNameStr + "() {" + this.LINE_SEPARATOR + "\t\t" + "return " + propertyName + ";" + this.LINE_SEPARATOR + "\t}" + this.LINE_SEPARATOR + this.LINE_SEPARATOR + "\t" + "public void set" + getsetProNameStr + "(" + javaType + " " + propertyName + ") {" + this.LINE_SEPARATOR + "\t\t" + "this." + propertyName + " = " + propertyName + ";" + this.LINE_SEPARATOR + "\t}" + this.LINE_SEPARATOR + this.LINE_SEPARATOR;
            if (!this.config.isGenToString()) continue;
            tostr.append("\t\t str.append(\",").append(propertyName).append("=\").append(").append(propertyName).append(");");
            tostr.append("\t\t " + this.LINE_SEPARATOR);
        }
        String basePath = this.config.getBaseDir();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        if (!(folder = new File(entitySaveDir = basePath + this.config.getPackagePath().replace(".", File.separator) + File.separator)).exists()) {
            folder.mkdirs();
        }
        File entityFile = new File(entitySaveDir + entityName + ".java");
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(entityFile)));
            bw.write(packageStr + this.LINE_SEPARATOR);
            if (!"".equals(importStr)) {
                bw.write(importStr + this.LINE_SEPARATOR);
            }
            bw.write(authorComment + this.LINE_SEPARATOR);
            bw.write("public class " + entityName);
            if (this.config.isGenSerializable()) {
                bw.write(" implements Serializable");
            }
            bw.write(" {" + this.LINE_SEPARATOR + this.LINE_SEPARATOR);
            if (this.config.isGenSerializable()) {
                bw.write("\tprivate static final long serialVersionUID = " + HoneyUtil.genSerializableNum() + ";" + this.LINE_SEPARATOR);
                bw.write(this.LINE_SEPARATOR);
            }
            bw.write(propertiesStr);
            bw.write(this.LINE_SEPARATOR);
            bw.write(getsetStr);
            if (this.config.isGenToString()) {
                tostr.deleteCharAt(tostr.indexOf(","));
                tostr.insert(0, "\t\t" + this.LINE_SEPARATOR);
                tostr.append("\t\t str.append(\"]\");\t");
                tostr.append("\t\t " + this.LINE_SEPARATOR);
                tostr.append("\t\t return str.toString();\t");
                tostr.append("\t\t " + this.LINE_SEPARATOR);
                tostr.append("\t }");
                tostr.append("\t\t " + this.LINE_SEPARATOR);
                tostr.insert(0, "\t\t str.append(\"" + entityName + "[\");\t");
                tostr.insert(0, "\t" + this.LINE_SEPARATOR);
                tostr.insert(0, "\t\t StringBuffer str=new StringBuffer();");
                tostr.insert(0, "\t" + this.LINE_SEPARATOR);
                tostr.insert(0, "\t public String toString(){");
                bw.write(tostr.toString());
            }
            bw.write("}");
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            throw ExceptionHelper.convert(e);
        }
    }

    public void genAllBeanFile() {
        Logger.info("Generating...");
        List<Table> tables = this.getAllTables();
        Table table = null;
        for (int i = 0; i < tables.size(); ++i) {
            table = tables.get(i);
            this.genBeanFile(table);
        }
        Logger.info("Generate Success!");
        Logger.info("Please check: " + this.config.getBaseDir() + this.config.getPackagePath().replace(".", "\\"));
    }

    public void genSomeBeanFile(String tableList) {
        String[] tables = tableList.split(",");
        Connection con = null;
        try {
            con = SessionFactory.getConnection();
            Table table = null;
            for (int i = 0; i < tables.length; ++i) {
                table = this.getTable(tables[i], con);
                this.genBeanFile(table);
            }
            con.close();
        }
        catch (Exception e) {
            Logger.info(e.getMessage());
            if (e.getMessage().contains("You have an error in your SQL syntax;") && e.getMessage().contains("where 1<>1")) {
                Logger.info("Maybe the table name is the database key work. Please rename the tableName and test again." + e.getMessage());
            }
            throw ExceptionHelper.convert(e);
        }
        Logger.info("Generate Success!");
        Logger.info("Please check folder: " + this.config.getBaseDir() + this.config.getPackagePath().replace(".", "\\"));
    }

    private List<Table> getAllTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = SessionFactory.getConnection();
            String showTablesSql = "";
            if (!"".equals(this.config.getQueryTableSql().trim())) {
                showTablesSql = this.config.getQueryTableSql();
            } else if (this.config.getDbName().equalsIgnoreCase("mysql")) {
                showTablesSql = "show tables";
            } else if (this.config.getDbName().equalsIgnoreCase("oracle")) {
                showTablesSql = "select table_name from user_tables";
            } else if (this.config.getDbName().equalsIgnoreCase("sqlserver")) {
                showTablesSql = "select table_name from edp.information_schema.tables where table_type='base table'";
            } else {
                throw new BeeException("There are not default sql, please check the bee.databaseName in bee.properties is right or not, or define queryTableSql in GenConfig!");
            }
            ps = con.prepareStatement(showTablesSql);
            rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getString(1) == null) continue;
                tables.add(this.getTable(rs.getString(1).trim(), con));
            }
            rs.close();
            ps.close();
            con.close();
        }
        catch (SQLException e) {
            Logger.error(e.getMessage());
            throw ExceptionHelper.convert(e);
        }
        return tables;
    }

    private Table getTable(String tableName, Connection con) throws SQLException {
        PreparedStatement ps = con.prepareStatement("select * from " + tableName + " where 1<>1");
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rmeta = rs.getMetaData();
        Table table = new Table();
        table.setTableName(tableName);
        table.setSchema(rmeta.getCatalogName(1));
        int columCount = rmeta.getColumnCount();
        for (int i = 1; i <= columCount; ++i) {
            table.getColumNames().add(rmeta.getColumnName(i).trim());
            table.getColumTypes().add(rmeta.getColumnTypeName(i).trim());
        }
        rs.close();
        ps.close();
        this.initComment(table, con);
        return table;
    }

    private void initComment(Table table, Connection con) throws SQLException {
        String sql = "";
        String t_sql = this.config.getQueryColumnCommnetSql();
        if (t_sql != null) {
            sql = t_sql;
        } else if (this.config.getDbName().equalsIgnoreCase("mysql") || this.config.getDbName().equalsIgnoreCase("MariaDB")) {
            sql = "select column_name,column_comment from information_schema.COLUMNS where TABLE_SCHEMA='" + table.getSchema() + "' and TABLE_NAME=?";
        } else if (this.config.getDbName().equalsIgnoreCase("oracle")) {
            sql = "select column_name,comments from user_col_comments where table_name=?";
        } else {
            throw new BeeException("There are not default sql, please check the bee.databaseName in bee.properties is right or not, or define queryColumnCommnetSql in GenConfig!");
        }
        PreparedStatement ps = con.prepareStatement(sql);
        ps.setString(1, table.getTableName());
        Map<String, String> map = this.getCommentMap(ps);
        String sql2 = "";
        String t_sql2 = this.config.getQueryTableCommnetSql();
        if (t_sql2 != null) {
            sql2 = t_sql2;
        } else if (this.config.getDbName().equalsIgnoreCase("mysql") || this.config.getDbName().equalsIgnoreCase("MariaDB")) {
            sql2 = "select TABLE_NAME,TABLE_COMMENT from information_schema.TABLES where TABLE_SCHEMA='" + table.getSchema() + "' and TABLE_NAME=?";
        } else if (this.config.getDbName().equalsIgnoreCase("oracle")) {
            sql2 = "select table_name,comments from user_tab_comments where table_name=?";
        } else {
            throw new BeeException("There are not default sql, please check the bee.databaseName in bee.properties is right or not, or define queryTableCommnetSql in GenConfig!");
        }
        PreparedStatement ps2 = con.prepareStatement(sql2);
        ps2.setString(1, table.getTableName());
        Map<String, String> map2 = this.getCommentMap(ps2);
        map2.putAll(map);
        table.setCommentMap(map2);
    }

    private Map<String, String> getCommentMap(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.executeQuery();
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            String column_comment = rs.getString(2);
            if (column_comment == null) {
                column_comment = "";
            }
            map.put(rs.getString(1), column_comment);
        }
        rs.close();
        ps.close();
        return map;
    }

    private Table getTalbe(String tableName) {
        Connection con = null;
        Table table = null;
        try {
            con = SessionFactory.getConnection();
            table = this.getTable(tableName, con);
            con.close();
        }
        catch (Exception e) {
            Logger.info(e.getMessage());
            if (e.getMessage().contains("You have an error in your SQL syntax;") && e.getMessage().contains("where 1<>1")) {
                Logger.info("Maybe the table name is the database key work. Please rename the tableName and test again." + e.getMessage());
            }
            throw ExceptionHelper.convert(e);
        }
        return table;
    }

    public List<String> getColumnNames(String tableName) {
        Table table = this.getTalbe(tableName);
        if (table != null) {
            return table.getColumNames();
        }
        return null;
    }

    public List<String> getFieldNames(String tableName) {
        List<String> columnNames = this.getColumnNames(tableName);
        if (columnNames == null) {
            return null;
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < columnNames.size(); ++i) {
            fieldNames.add(NameTranslateHandle.toFieldName(columnNames.get(i)));
        }
        return fieldNames;
    }
}

