/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.Expression;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;

public class ConditionHelper {
    static boolean isNeedAnd = true;
    private static String ONE_SPACE = " ";
    private static DbFeature dbFeature = BeeFactory.getHoneyFactory().getDbFeature();
    private static String setAdd = "setAdd";
    private static String setMultiply = "setMultiply";
    private static String setAddField = "setAddField";
    private static String setMultiplyField = "setMultiplyField";

    static boolean processConditionForUpdateSet(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition) {
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> updateSetList = conditionImpl.getUpdateExpList();
        boolean firstSet = true;
        if (updateSetList != null && updateSetList.size() > 0 && SuidType.UPDATE != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support the method set ,setAdd or setMultiply!");
        }
        PreparedValue preparedValue = null;
        Expression expression = null;
        for (int j = 0; j < updateSetList.size(); ++j) {
            expression = updateSetList.get(j);
            String opType = expression.getOpType();
            if (expression.getValue() == null) {
                throw new BeeErrorGrammarException(conditionImpl.getSuidType() + ": the num of " + opType + " is null");
            }
            if (firstSet) {
                firstSet = false;
            } else {
                sqlBuffer.append(",");
            }
            sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), null));
            sqlBuffer.append("=");
            if (opType != null) {
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), null));
            }
            if (setAddField.equals(opType)) {
                sqlBuffer.append("+");
                sqlBuffer.append(ConditionHelper._toColumnName((String)expression.getValue()));
                continue;
            }
            if (setMultiplyField.equals(opType)) {
                sqlBuffer.append("*");
                sqlBuffer.append(ConditionHelper._toColumnName((String)expression.getValue()));
                continue;
            }
            if (setAdd.equals(opType)) {
                sqlBuffer.append("+");
            } else if (setMultiply.equals(opType)) {
                sqlBuffer.append("*");
            }
            sqlBuffer.append("?");
            preparedValue = new PreparedValue();
            preparedValue.setType(expression.getValue().getClass().getName());
            preparedValue.setValue(expression.getValue());
            list.add(preparedValue);
        }
        return firstSet;
    }

    static boolean processCondition(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition, boolean firstWhere) {
        return ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere, null);
    }

    static boolean processCondition(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition, boolean firstWhere, String[] useSubTableNames) {
        List<Expression> updateSetList;
        Boolean isForUpdate;
        if (condition == null) {
            return firstWhere;
        }
        PreparedValue preparedValue = null;
        boolean isFirstWhere = firstWhere;
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> expList = conditionImpl.getExpList();
        Expression expression = null;
        Integer start = conditionImpl.getStart();
        if (start != null && SuidType.SELECT != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support paging with start !");
        }
        for (int j = 0; j < expList.size(); ++j) {
            expression = expList.get(j);
            String opType = expression.getOpType();
            if (("groupBy".equalsIgnoreCase(opType) || "having".equalsIgnoreCase(opType)) && SuidType.SELECT != conditionImpl.getSuidType()) {
                throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support the opType: " + opType + "!");
            }
            if (firstWhere) {
                if ("groupBy".equalsIgnoreCase(opType) || "having".equalsIgnoreCase(opType) || "orderBy".equalsIgnoreCase(opType)) {
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                    isNeedAnd = false;
                    isFirstWhere = false;
                }
            }
            if (Op.in.getOperator().equalsIgnoreCase(opType) || Op.notIn.getOperator().equalsIgnoreCase(opType)) {
                int i;
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                sqlBuffer.append(" ");
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append(" (");
                sqlBuffer.append("?");
                String str = expression.getValue().toString();
                String[] values = str.trim().split(",");
                for (i = 1; i < values.length; ++i) {
                    sqlBuffer.append(",?");
                }
                sqlBuffer.append(")");
                for (i = 0; i < values.length; ++i) {
                    preparedValue = new PreparedValue();
                    preparedValue.setType(values[i].getClass().getName());
                    preparedValue.setValue(values[i]);
                    list.add(preparedValue);
                }
                isNeedAnd = true;
                continue;
            }
            if (Op.like.getOperator().equalsIgnoreCase(opType) || Op.notLike.getOperator().equalsIgnoreCase(opType)) {
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue().getClass().getName());
                preparedValue.setValue(expression.getValue());
                list.add(preparedValue);
                isNeedAnd = true;
                continue;
            }
            if (" between ".equalsIgnoreCase(opType) || " not between ".equalsIgnoreCase(opType)) {
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                sqlBuffer.append(opType);
                sqlBuffer.append("?");
                sqlBuffer.append(" and ");
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue().getClass().getName());
                preparedValue.setValue(expression.getValue());
                list.add(preparedValue);
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue2().getClass().getName());
                preparedValue.setValue(expression.getValue2());
                list.add(preparedValue);
                isNeedAnd = true;
                continue;
            }
            if ("groupBy".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException("BeeErrorGrammarException: " + conditionImpl.getSuidType() + " do not support 'group by' !");
                }
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                continue;
            }
            if ("having".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'having' !");
                }
                if (2 == expression.getOpNum()) {
                    sqlBuffer.append(expression.getValue());
                    sqlBuffer.append(expression.getValue2());
                    continue;
                }
                if (5 != expression.getOpNum()) continue;
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(expression.getValue3());
                sqlBuffer.append("(");
                if (FunctionType.COUNT.getName().equals(expression.getValue3()) && expression.getFieldName() != null && "*".equals(expression.getFieldName().trim())) {
                    sqlBuffer.append("*");
                } else {
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                }
                sqlBuffer.append(")");
                sqlBuffer.append(expression.getValue4());
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue2().getClass().getName());
                preparedValue.setValue(expression.getValue2());
                list.add(preparedValue);
                continue;
            }
            if ("orderBy".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'order by' !");
                }
                sqlBuffer.append(expression.getValue());
                if (4 == expression.getOpNum()) {
                    sqlBuffer.append(expression.getValue3());
                    sqlBuffer.append("(");
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                    sqlBuffer.append(")");
                } else {
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                }
                if (3 != expression.getOpNum() && 4 != expression.getOpNum()) continue;
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(expression.getValue2());
                continue;
            }
            if (expression.getOpNum() == -2) {
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(expression.getValue());
                continue;
            }
            if (expression.getOpNum() == -1) {
                sqlBuffer.append(expression.getValue());
                isNeedAnd = true;
                continue;
            }
            if (expression.getOpNum() == 1) {
                sqlBuffer.append(" ");
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(" ");
                isNeedAnd = false;
                continue;
            }
            ConditionHelper.adjustAnd(sqlBuffer);
            sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
            if (expression.getValue() == null) {
                if ("=".equals(expression.getOpType())) {
                    sqlBuffer.append(" is null");
                } else {
                    sqlBuffer.append(" is not null");
                }
            } else {
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue().getClass().getName());
                preparedValue.setValue(expression.getValue());
                list.add(preparedValue);
            }
            isNeedAnd = true;
        }
        if (SuidType.SELECT == conditionImpl.getSuidType()) {
            Integer size = conditionImpl.getSize();
            String sql = "";
            if (start != null && size != null) {
                sql = dbFeature.toPageSql(sqlBuffer.toString(), start.intValue(), size.intValue());
                sqlBuffer.delete(0, sqlBuffer.length());
                sqlBuffer.append(sql);
            } else if (size != null) {
                sql = dbFeature.toPageSql(sqlBuffer.toString(), size.intValue());
                sqlBuffer.delete(0, sqlBuffer.length());
                sqlBuffer.append(sql);
            }
        }
        if (useSubTableNames == null && SuidType.SELECT == conditionImpl.getSuidType() && (isForUpdate = conditionImpl.getForUpdate()) != null && isForUpdate.booleanValue()) {
            sqlBuffer.append(" for update ");
        }
        if (SuidType.SELECT == conditionImpl.getSuidType() && (updateSetList = conditionImpl.getUpdateExpList()) != null && updateSetList.size() > 0) {
            Logger.warn("Use set method(s) in SELECT type, but it just effect in UPDATE type! Involved field(s): " + conditionImpl.getUpdatefieldSet());
        }
        return isFirstWhere;
    }

    static <T> String processSelectField(String columnNames, Condition condition) {
        if (condition == null) {
            return null;
        }
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        if (SuidType.SELECT != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support specifying partial fields by method selectField(String) !");
        }
        String selectField = conditionImpl.getSelectField();
        if (selectField == null) {
            return null;
        }
        return HoneyUtil.checkSelectFieldViaString(columnNames, selectField);
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toColumnName(String fieldName, String[] useSubTableNames) {
        if (useSubTableNames == null) {
            return ConditionHelper._toColumnName(fieldName);
        }
        String t_fieldName = "";
        String t_tableName = "";
        String find_tableName = "";
        int index = fieldName.indexOf(".");
        if (index > -1) {
            t_fieldName = fieldName.substring(index + 1);
            t_tableName = fieldName.substring(0, index);
            String t_tableName_dot = fieldName.substring(0, index + 1);
            if (useSubTableNames[0] != null && useSubTableNames[0].startsWith(t_tableName_dot)) {
                find_tableName = t_tableName;
            } else if (useSubTableNames[1] != null && useSubTableNames[1].startsWith(t_tableName_dot)) {
                find_tableName = t_tableName;
            } else {
                OneTimeParameter.setAttribute("_SYS_Bee_DoNotCheckAnnotation", "tRue");
                find_tableName = NameTranslateHandle.toTableName(t_tableName);
            }
            return find_tableName + "." + NameTranslateHandle.toColumnName(t_fieldName);
        }
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static void adjustAnd(StringBuffer sqlBuffer) {
        if (isNeedAnd) {
            sqlBuffer.append(" and ");
            isNeedAnd = false;
        }
    }
}

