/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.bee.osql.annotation.JoinType;
import org.teasoft.bee.osql.exception.BeeErrorFieldException;
import org.teasoft.bee.osql.exception.BeeIllegalEntityException;
import org.teasoft.bee.osql.exception.JoinTableException;
import org.teasoft.bee.osql.exception.JoinTableParameterException;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.util.PropertiesReader;

public final class HoneyUtil {
    private static Map<String, String> jdbcTypeMap = new HashMap<String, String>();
    private static Map<String, Integer> javaTypeMap = new HashMap<String, Integer>();
    private static PropertiesReader jdbcTypeCustomProp = new PropertiesReader("/jdbcTypeToFieldType.properties");
    private static PropertiesReader jdbcTypeCustomProp_specificalDB = null;

    public static int[] mergeArray(int[] total, int[] part, int start, int end) {
        try {
            for (int i = 0; i < part.length; ++i) {
                total[start + i] = part[i];
            }
        }
        catch (Exception e) {
            Logger.error(" HoneyUtil.mergeArray() " + e.getMessage());
        }
        return total;
    }

    static String getBeanField(Field[] field) {
        if (field == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        int len = field.length;
        boolean isFirst = true;
        for (int i = 0; i < len; ++i) {
            if ("serialVersionUID".equals(field[i].getName()) || field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                s.append(",");
            }
            s.append(NameTranslateHandle.toColumnName(field[i].getName()));
        }
        return s.toString();
    }

    static <T> MoreTableStruct[] getMoreTableStructAndCheckBefore(T entity) {
        String packageAndClassName = entity.getClass().getName();
        String key = "ForMoreTable:" + packageAndClassName;
        MoreTableStruct[] moreTableStruct = HoneyContext.getMoreTableStructs(key);
        if (moreTableStruct == null) {
            moreTableStruct = HoneyUtil._getMoreTableStructAndCheckBefore(entity);
            HoneyContext.addMoreTableStructs(key, moreTableStruct);
        }
        return moreTableStruct;
    }

    private static <T> MoreTableStruct[] _getMoreTableStructAndCheckBefore(T entity) {
        String errorMsg;
        if (entity == null) {
            return null;
        }
        String entityFullName = entity.getClass().getName();
        Field[] field = entity.getClass().getDeclaredFields();
        MoreTableStruct[] moreTableStruct = new MoreTableStruct[3];
        moreTableStruct[0] = new MoreTableStruct();
        Field[] subField = new Field[2];
        int subEntityFieldNum = 0;
        HashSet<String> mainFieldSet = new HashSet<String>();
        HashMap<String, String> dulMap = new HashMap<String, String>();
        String tableName = HoneyUtil._toTableName(entity);
        StringBuffer columns = new StringBuffer();
        int len = field.length;
        boolean isFirst = true;
        String mailField = "";
        for (int i = 0; i < len; ++i) {
            if ("serialVersionUID".equals(field[i].getName())) continue;
            if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                if (++subEntityFieldNum == 1) {
                    subField[0] = field[i];
                }
                if (subEntityFieldNum != 2) continue;
                subField[1] = field[i];
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                columns.append(",");
            }
            columns.append(tableName);
            columns.append(".");
            mailField = NameTranslateHandle.toColumnName(field[i].getName());
            columns.append(mailField);
            mainFieldSet.add(mailField);
        }
        if (subEntityFieldNum > 2) {
            throw new JoinTableException("One entity only supports two JoinTable at most! " + entityFullName + " has " + subEntityFieldNum + " JoinTable now !");
        }
        JoinTable[] joinTable = new JoinTable[2];
        String[] subTableName = new String[2];
        boolean hasOtherJoin = false;
        if (subField[0] != null) {
            joinTable[0] = subField[0].getAnnotation(JoinTable.class);
            errorMsg = HoneyUtil.checkJoinTable(joinTable[0]);
            if (!"".equals(errorMsg)) {
                throw new JoinTableParameterException("Error: mainField and subField can not just use only one." + errorMsg);
            }
            if (joinTable[0].joinType() != JoinType.JOIN) {
                hasOtherJoin = true;
            }
        }
        if (subField[1] != null) {
            joinTable[1] = subField[1].getAnnotation(JoinTable.class);
            errorMsg = HoneyUtil.checkJoinTable(joinTable[1]);
            if (!"".equals(errorMsg)) {
                throw new JoinTableParameterException("Error: mainField and subField can not just use only one." + errorMsg);
            }
            if (joinTable[1].joinType() != JoinType.JOIN) {
                hasOtherJoin = true;
            }
        }
        if (hasOtherJoin && subEntityFieldNum == 2) {
            throw new JoinTableException("Just support JoinType.JOIN in this version when a entity has two JoinTable annotation fields!");
        }
        moreTableStruct[0].tableName = tableName;
        moreTableStruct[0].entityFullName = entityFullName;
        moreTableStruct[0].entityName = entity.getClass().getSimpleName();
        moreTableStruct[0].joinTableNum = subEntityFieldNum;
        for (int j = 0; j < 2; ++j) {
            String useSubTableName;
            if (subField[j] == null) continue;
            String mainColumn = HoneyUtil._toColumnName(joinTable[j].mainField());
            String subColumn = HoneyUtil._toColumnName(joinTable[j].subField());
            subTableName[j] = HoneyUtil._toTableNameByEntityName(subField[j].getType().getName());
            moreTableStruct[1 + j] = new MoreTableStruct();
            moreTableStruct[1 + j].subEntityField = subField[j];
            moreTableStruct[1 + j].tableName = subTableName[j];
            moreTableStruct[1 + j].entityFullName = subField[j].getType().getName();
            moreTableStruct[1 + j].entityName = subField[j].getType().getSimpleName();
            moreTableStruct[1 + j].mainField = joinTable[j].mainField();
            moreTableStruct[1 + j].subField = joinTable[j].subField();
            moreTableStruct[1 + j].joinType = joinTable[j].joinType();
            String t_subAlias = joinTable[j].subAlias();
            if (t_subAlias != null && !"".equals(t_subAlias)) {
                moreTableStruct[1 + j].subAlias = t_subAlias;
                useSubTableName = t_subAlias;
                moreTableStruct[1 + j].hasSubAlias = true;
            } else {
                useSubTableName = subTableName[j];
            }
            if (!"".equals(mainColumn) && !"".equals(subColumn)) {
                moreTableStruct[1 + j].joinExpression = tableName + "." + mainColumn + "=" + useSubTableName + "." + subColumn;
            }
            moreTableStruct[1 + j].useSubTableName = useSubTableName;
            try {
                subField[j].setAccessible(true);
                moreTableStruct[1 + j].subObject = subField[j].get(entity);
            }
            catch (IllegalAccessException e) {
                throw ExceptionHelper.convert(e);
            }
            StringBuffer subColumns = HoneyUtil._getBeanFullField_0(subField[j], useSubTableName, entityFullName, mainFieldSet, dulMap);
            moreTableStruct[1 + j].columnsFull = subColumns.toString();
            columns.append(",");
            columns.append(subColumns);
        }
        moreTableStruct[0].columnsFull = columns.toString();
        moreTableStruct[0].subDulFieldMap = dulMap;
        return moreTableStruct;
    }

    static StringBuffer _getBeanFullField_0(Field entityField, String tableName, String entityFullName, Set<String> mainFieldSet, Map<String, String> dulMap) {
        Field[] field = entityField.getType().getDeclaredFields();
        StringBuffer columns = new StringBuffer();
        int len = field.length;
        boolean isFirst = true;
        String subFieldName = "";
        for (int i = 0; i < len; ++i) {
            if ("serialVersionUID".equals(field[i].getName())) continue;
            if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                if (entityField.getType().getName().equals(field[i].getType().getName())) continue;
                Logger.warn("Annotation JoinTable field: " + entityField.getName() + "(in " + entityFullName + ") still include JoinTable field:" + field[i].getName() + "(will be ignored)!");
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                columns.append(",");
            }
            subFieldName = NameTranslateHandle.toColumnName(field[i].getName());
            if (!mainFieldSet.add(subFieldName) && HoneyUtil.isOracle()) {
                dulMap.put(tableName + "." + subFieldName, tableName + "_" + subFieldName + "_$");
                columns.append(tableName);
                columns.append(".");
                columns.append(subFieldName);
                columns.append("  " + tableName + "_" + subFieldName + "_$");
                continue;
            }
            columns.append(tableName);
            columns.append(".");
            columns.append(subFieldName);
        }
        return columns;
    }

    public static String getFieldType(String jdbcType) {
        String javaType = jdbcTypeMap.get(jdbcType);
        if (javaType != null) {
            return javaType;
        }
        if (null == jdbcTypeMap.get(jdbcType)) {
            int i;
            String tempType = jdbcType.trim();
            if (tempType.endsWith(" UNSIGNED") && (javaType = jdbcTypeMap.get(tempType.substring(0, i = tempType.indexOf(" ")))) != null) {
                return javaType;
            }
            javaType = "[UNKNOWN TYPE]" + jdbcType;
        }
        return javaType;
    }

    private static void initJdbcTypeMap() {
        jdbcTypeMap.put("CHAR", "String");
        jdbcTypeMap.put("VARCHAR", "String");
        jdbcTypeMap.put("LONGVARCHAR", "String");
        jdbcTypeMap.put("NVARCHAR", "String");
        jdbcTypeMap.put("NCHAR", "String");
        jdbcTypeMap.put("NUMERIC", "BigDecimal");
        jdbcTypeMap.put("DECIMAL", "BigDecimal");
        jdbcTypeMap.put("BIT", "Boolean");
        jdbcTypeMap.put("TINYINT", "Byte");
        jdbcTypeMap.put("SMALLINT", "Short");
        jdbcTypeMap.put("INT", "Integer");
        jdbcTypeMap.put("INTEGER", "Integer");
        jdbcTypeMap.put("BIGINT", "Long");
        jdbcTypeMap.put("REAL", "Float");
        jdbcTypeMap.put("FLOAT", "Float");
        jdbcTypeMap.put("DOUBLE", "Double");
        jdbcTypeMap.put("BINARY", "byte[]");
        jdbcTypeMap.put("VARBINARY", "byte[]");
        jdbcTypeMap.put("LONGVARBINARY", "byte[]");
        jdbcTypeMap.put("DATE", "Date");
        jdbcTypeMap.put("TIME", "Time");
        jdbcTypeMap.put("TIMESTAMP", "Timestamp");
        jdbcTypeMap.put("CLOB", "Clob");
        jdbcTypeMap.put("BLOB", "Blob");
        jdbcTypeMap.put("ARRAY", "Array");
        jdbcTypeMap.put("NCLOB", "java.sql.NClob");
        jdbcTypeMap.put("ROWID", "java.sql.RowId");
        jdbcTypeMap.put("SQLXML", "java.sql.SQLXML");
        jdbcTypeMap.put("TIMESTAMP_WITH_TIMEZONE", "Timestamp");
        jdbcTypeMap.put("TIMESTAMP WITH TIME ZONE", "Timestamp");
        jdbcTypeMap.put("TIMESTAMP WITH LOCAL TIME ZONE", "Timestamp");
        String dbName = HoneyConfig.getHoneyConfig().getDbName();
        if ("mysql".equalsIgnoreCase(dbName) || "MariaDB".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("MEDIUMINT", "Integer");
            jdbcTypeMap.put("DATETIME", "Timestamp");
            jdbcTypeMap.put("TINYBLOB", "Blob");
            jdbcTypeMap.put("MEDIUMBLOB", "Blob");
            jdbcTypeMap.put("LONGBLOB", "Blob");
            jdbcTypeMap.put("YEAR", "Integer");
            jdbcTypeMap.put("TINYINT", "Byte");
            jdbcTypeMap.put("SMALLINT", "Short");
            jdbcTypeMap.put("TINYINT UNSIGNED", "Short");
            jdbcTypeMap.put("SMALLINT UNSIGNED", "Integer");
            jdbcTypeMap.put("INT UNSIGNED", "Long");
            jdbcTypeMap.put("BIGINT UNSIGNED", "BigInteger");
        } else if ("oracle".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("LONG", "String");
            jdbcTypeMap.put("VARCHAR2", "String");
            jdbcTypeMap.put("NVARCHAR2", "String");
            jdbcTypeMap.put("NUMBER", "BigDecimal");
            jdbcTypeMap.put("RAW", "byte[]");
            jdbcTypeMap.put("INTERVALYM", "String");
            jdbcTypeMap.put("INTERVALDS", "String");
            jdbcTypeMap.put("INTERVAL YEAR TO MONTH", "String");
            jdbcTypeMap.put("INTERVAL DAY TO SECOND", "String");
        } else if ("sqlserver".equalsIgnoreCase(dbName)) {
            jdbcTypeMap.put("SMALLINT", "Short");
            jdbcTypeMap.put("TINYINT", "Short");
            jdbcTypeMap.put("DATETIMEOFFSET", "microsoft.sql.DateTimeOffset");
        }
    }

    private static void appendJdbcTypeCustomProp() {
        for (String s : jdbcTypeCustomProp.getKeys()) {
            jdbcTypeMap.put(s, jdbcTypeCustomProp.getValue(s));
        }
    }

    private static void appendJdbcTypeCustomProp_specificalDB() {
        for (String s : jdbcTypeCustomProp_specificalDB.getKeys()) {
            jdbcTypeMap.put(s, jdbcTypeCustomProp_specificalDB.getValue(s));
        }
    }

    private static void initJavaTypeMap() {
        javaTypeMap.put("java.lang.String", 1);
        javaTypeMap.put("java.lang.Integer", 2);
        javaTypeMap.put("java.lang.Long", 3);
        javaTypeMap.put("java.lang.Double", 4);
        javaTypeMap.put("java.lang.Float", 5);
        javaTypeMap.put("java.lang.Short", 6);
        javaTypeMap.put("java.lang.Byte", 7);
        javaTypeMap.put("[B", 8);
        javaTypeMap.put("java.lang.Boolean", 9);
        javaTypeMap.put("java.math.BigDecimal", 10);
        javaTypeMap.put("java.sql.Date", 11);
        javaTypeMap.put("java.sql.Time", 12);
        javaTypeMap.put("java.sql.Timestamp", 13);
        javaTypeMap.put("java.sql.Blob", 14);
        javaTypeMap.put("java.sql.Clob", 15);
        javaTypeMap.put("java.sql.NClob", 16);
        javaTypeMap.put("java.sql.RowId", 17);
        javaTypeMap.put("java.sql.SQLXML", 18);
        javaTypeMap.put("java.math.BigInteger", 19);
    }

    public static int getJavaTypeIndex(String javaType) {
        return javaTypeMap.get(javaType) == null ? -1 : javaTypeMap.get(javaType);
    }

    public static String firstLetterToUpperCase(String str) {
        return NameUtil.firstLetterToUpperCase(str);
    }

    static boolean isContinueForMoreTable(int includeType, Object object, String fieldName) {
        return (includeType == -1 || includeType == 1) && object == null || (includeType == -1 || includeType == 0) && "".equals(object) || "serialVersionUID".equals(fieldName);
    }

    static boolean isContinue(int includeType, Object object, Field field) {
        if (field != null && field.isAnnotationPresent(JoinTable.class)) {
            return true;
        }
        String fieldName = field.getName();
        return (includeType == -1 || includeType == 1) && object == null || (includeType == -1 || includeType == 0) && "".equals(object) || "serialVersionUID".equals(fieldName);
    }

    static void setPreparedValues(PreparedStatement pst, int objTypeIndex, int i, Object value) throws SQLException {
        if (null == value) {
            HoneyUtil.setPreparedNull(pst, objTypeIndex, i);
            return;
        }
        switch (objTypeIndex) {
            case 1: {
                pst.setString(i + 1, (String)value);
                break;
            }
            case 2: {
                pst.setInt(i + 1, (Integer)value);
                break;
            }
            case 3: {
                pst.setLong(i + 1, (Long)value);
                break;
            }
            case 4: {
                pst.setDouble(i + 1, (Double)value);
                break;
            }
            case 5: {
                pst.setFloat(i + 1, ((Float)value).floatValue());
                break;
            }
            case 6: {
                pst.setShort(i + 1, (Short)value);
                break;
            }
            case 7: {
                pst.setByte(i + 1, (Byte)value);
                break;
            }
            case 8: {
                pst.setBytes(i + 1, (byte[])value);
                break;
            }
            case 9: {
                pst.setBoolean(i + 1, (Boolean)value);
                break;
            }
            case 10: {
                pst.setBigDecimal(i + 1, (BigDecimal)value);
                break;
            }
            case 11: {
                pst.setDate(i + 1, (Date)value);
                break;
            }
            case 12: {
                pst.setTime(i + 1, (Time)value);
                break;
            }
            case 13: {
                pst.setTimestamp(i + 1, (Timestamp)value);
                break;
            }
            case 14: {
                pst.setBlob(i + 1, (Blob)value);
                break;
            }
            case 15: {
                pst.setClob(i + 1, (Clob)value);
                break;
            }
            case 16: {
                pst.setNClob(i + 1, (NClob)value);
                break;
            }
            case 17: {
                pst.setRowId(i + 1, (RowId)value);
                break;
            }
            case 18: {
                pst.setSQLXML(i + 1, (SQLXML)value);
                break;
            }
            default: {
                pst.setObject(i + 1, value);
            }
        }
    }

    static Object getResultObject(ResultSet rs, String typeName, String columnName) throws SQLException {
        int k = HoneyUtil.getJavaTypeIndex(typeName);
        switch (k) {
            case 1: {
                return rs.getString(columnName);
            }
            case 2: {
                return rs.getInt(columnName);
            }
            case 3: {
                return rs.getLong(columnName);
            }
            case 4: {
                return rs.getDouble(columnName);
            }
            case 5: {
                return Float.valueOf(rs.getFloat(columnName));
            }
            case 6: {
                return rs.getShort(columnName);
            }
            case 7: {
                return rs.getByte(columnName);
            }
            case 8: {
                return rs.getBytes(columnName);
            }
            case 9: {
                return rs.getBoolean(columnName);
            }
            case 10: {
                return rs.getBigDecimal(columnName);
            }
            case 11: {
                return rs.getDate(columnName);
            }
            case 12: {
                return rs.getTime(columnName);
            }
            case 13: {
                return rs.getTimestamp(columnName);
            }
            case 14: {
                return rs.getBlob(columnName);
            }
            case 15: {
                return rs.getClob(columnName);
            }
            case 16: {
                return rs.getNClob(columnName);
            }
            case 17: {
                return rs.getRowId(columnName);
            }
            case 18: {
                return rs.getSQLXML(columnName);
            }
        }
        return rs.getObject(columnName);
    }

    static Object getResultObjectByIndex(ResultSet rs, String typeName, int index) throws SQLException {
        int k = HoneyUtil.getJavaTypeIndex(typeName);
        switch (k) {
            case 1: {
                return rs.getString(index);
            }
            case 2: {
                return rs.getInt(index);
            }
            case 3: {
                return rs.getLong(index);
            }
            case 4: {
                return rs.getDouble(index);
            }
            case 5: {
                return Float.valueOf(rs.getFloat(index));
            }
            case 6: {
                return rs.getShort(index);
            }
            case 7: {
                return rs.getByte(index);
            }
            case 8: {
                return rs.getBytes(index);
            }
            case 9: {
                return rs.getBoolean(index);
            }
            case 10: {
                return rs.getBigDecimal(index);
            }
            case 11: {
                return rs.getDate(index);
            }
            case 12: {
                return rs.getTime(index);
            }
            case 13: {
                return rs.getTimestamp(index);
            }
            case 14: {
                return rs.getBlob(index);
            }
            case 15: {
                return rs.getClob(index);
            }
            case 16: {
                return rs.getNClob(index);
            }
            case 17: {
                return rs.getRowId(index);
            }
            case 18: {
                return rs.getSQLXML(index);
            }
        }
        return rs.getObject(index);
    }

    public static void setPreparedNull(PreparedStatement pst, int objTypeIndex, int i) throws SQLException {
        pst.setNull(i + 1, 0);
    }

    public static String genSerializableNum() {
        String s = Math.random() + "";
        int end = s.length() > 12 ? 12 : s.length();
        return "159" + s.substring(2, end) + "L";
    }

    public static String deleteLastSemicolon(String sql) {
        String new_sql = sql.trim();
        if (new_sql.endsWith(";")) {
            return new_sql.substring(0, new_sql.length() - 1);
        }
        return sql;
    }

    public static <T> void checkPackage(T entity) {
        if (entity == null) {
            return;
        }
        if (entity.getClass().getPackage() == null) {
            return;
        }
        String packageName = entity.getClass().getPackage().getName();
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            throw new BeeIllegalEntityException("BeeIllegalEntityException: Illegal Entity, " + entity.getClass().getName());
        }
    }

    public static <T> Map<String, Object> getColumnMapByEntity(T entity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        try {
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i].get(entity) == null || "serialVersionUID".equals(fields[i].getName()) || fields[i].isAnnotationPresent(JoinTable.class)) continue;
                map.put(HoneyUtil._toColumnName(fields[i].getName()), fields[i].get(entity));
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return map;
    }

    public static String list2Value(List<PreparedValue> list) {
        return HoneyUtil.list2Value(list, false);
    }

    public static String list2Value(List<PreparedValue> list, boolean needType) {
        StringBuffer b = new StringBuffer();
        if (list == null || list.size() == 0) {
            return "";
        }
        String type = "";
        int size = list.size();
        for (int j = 0; j < size; ++j) {
            b.append(list.get(j).getValue());
            type = list.get(j).getType();
            if (needType && type != null) {
                b.append("(");
                if (type.startsWith("java.lang.")) {
                    b.append(type.substring(10));
                } else {
                    b.append(type);
                }
                b.append(")");
            }
            if (j == size - 1) continue;
            b.append(",");
        }
        return b.toString();
    }

    public static String getExecutableSql(String sql, List<PreparedValue> list) {
        if (list == null || list.size() == 0) {
            return sql;
        }
        int size = list.size();
        Object value = null;
        for (int j = 0; j < size; ++j) {
            value = list.get(j).getValue();
            sql = value instanceof Number ? sql.replaceFirst("\\?", String.valueOf(value)) : sql.replaceFirst("\\?", "'" + String.valueOf(value) + "'");
        }
        return sql;
    }

    static <T> String checkSelectField(T entity, String fieldList) {
        if (fieldList == null) {
            return null;
        }
        Field[] fields = entity.getClass().getDeclaredFields();
        String packageAndClassName = entity.getClass().getName();
        String columnsdNames = HoneyContext.getBeanField(packageAndClassName);
        if (columnsdNames == null) {
            columnsdNames = HoneyUtil.getBeanField(fields);
            HoneyContext.addBeanField(packageAndClassName, columnsdNames);
        }
        return HoneyUtil.checkSelectFieldViaString(columnsdNames, fieldList);
    }

    static String checkSelectFieldViaString(String columnsdNames, String fieldList) {
        if (fieldList == null) {
            return null;
        }
        columnsdNames = columnsdNames.toLowerCase();
        String errorField = "";
        boolean isFirstError = true;
        String[] selectFields = fieldList.split(",");
        String newSelectFields = "";
        boolean isFisrt = true;
        for (String s : selectFields) {
            String colName = HoneyUtil._toColumnName(s);
            if (!(columnsdNames.contains("," + colName + ",") || columnsdNames.startsWith(colName + ",") || columnsdNames.endsWith("," + colName) || columnsdNames.equals(colName) || columnsdNames.contains("." + colName + ",") || columnsdNames.endsWith("." + colName))) {
                if (isFirstError) {
                    errorField = errorField + s;
                    isFirstError = false;
                } else {
                    errorField = errorField + "," + s;
                }
            }
            if (isFisrt) {
                newSelectFields = newSelectFields + colName;
                isFisrt = false;
                continue;
            }
            newSelectFields = newSelectFields + ", " + colName;
        }
        if (!"".equals(errorField)) {
            throw new BeeErrorFieldException("ErrorField: " + errorField);
        }
        if ("".equals(newSelectFields.trim())) {
            return null;
        }
        return newSelectFields;
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toTableNameByEntityName(String entityName) {
        return NameTranslateHandle.toTableName(entityName);
    }

    private static String checkJoinTable(JoinTable joinTable) {
        String errorMsg = "";
        String mainField = joinTable.mainField();
        String subField = joinTable.subField();
        int errorCount = 0;
        if (mainField == null) {
            errorMsg = "mainField is null! ";
            ++errorCount;
        } else if ("".equals(mainField.trim())) {
            errorMsg = errorMsg + "mainField is empty! ";
            ++errorCount;
        }
        if (subField == null) {
            errorMsg = errorMsg + "subField is null! ";
            ++errorCount;
        } else if ("".equals(subField.trim())) {
            errorMsg = errorMsg + "subField is empty! ";
            ++errorCount;
        }
        if (errorCount == 1) {
            return errorMsg;
        }
        return "";
    }

    public static boolean isMysql() {
        return "mysql".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName()) || "MariaDB".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    public static boolean isOracle() {
        return "oracle".equalsIgnoreCase(HoneyConfig.getHoneyConfig().getDbName());
    }

    static {
        String proFileName = "/jdbcTypeToFieldType-{DbName}.properties";
        jdbcTypeCustomProp_specificalDB = new PropertiesReader(proFileName.replace("{DbName}", HoneyConfig.getHoneyConfig().getDbName()));
        HoneyUtil.initJdbcTypeMap();
        HoneyUtil.appendJdbcTypeCustomProp();
        HoneyUtil.appendJdbcTypeCustomProp_specificalDB();
        HoneyUtil.initJavaTypeMap();
    }
}

