/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.logging.Log;
import org.teasoft.honey.logging.LoggerFactory;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import sun.reflect.Reflection;

public class Logger {
    private static boolean showSQL = HoneyConfig.getHoneyConfig().isShowSQL();
    private static boolean showSQLShowType = HoneyConfig.getHoneyConfig().isShowSQLShowType();
    private static boolean showExecutableSql = HoneyConfig.getHoneyConfig().isShowExecutableSql();
    private static Log log = null;

    public static void logSQL(String hardStr, String sql) {
        if (!showSQL) {
            return;
        }
        String callerClass = Reflection.getCallerClass().getName();
        Logger.resetLog(callerClass);
        if (showSQL) {
            List<PreparedValue> list = null;
            String insertIndex = (String)OneTimeParameter.getAttribute("_SYS_Bee_BatchInsert");
            list = HoneyUtil.isMysql() && insertIndex != null ? HoneyContext.getPreparedValue(sql) : HoneyContext._justGetPreparedValue(sql);
            String value = HoneyUtil.list2Value(list, showSQLShowType);
            if (value == null || "".equals(value.trim())) {
                Logger._print("[Bee] " + hardStr, sql);
            } else {
                if (insertIndex != null) {
                    if ("0".equals(insertIndex) && !HoneyUtil.isMysql()) {
                        Logger._print("[Bee] " + hardStr, sql);
                    }
                    Logger.print("[Bee] --> index:" + insertIndex + " ,  [values]: " + value);
                } else {
                    Logger._print("[Bee] " + hardStr, sql + "   [values]: " + value);
                }
                if (showExecutableSql) {
                    String executableSql = HoneyUtil.getExecutableSql(sql, list);
                    if (insertIndex != null && !"0".equals(insertIndex)) {
                        int endIndex = executableSql.indexOf("]_End ");
                        Logger._println("[Bee] " + hardStr + " ( ExecutableSql " + executableSql.substring(4, endIndex + 1) + " )", executableSql.substring(endIndex + 6) + " ;");
                    } else if ("0".equals(insertIndex)) {
                        Logger._println("[Bee] " + hardStr + " ( ExecutableSql [index0])", executableSql);
                    } else {
                        Logger._println("[Bee] " + hardStr + " ( ExecutableSql )", executableSql);
                    }
                }
            }
        }
    }

    private static void print(String s) {
        log.info(s);
    }

    private static void _print(String s1, String s2) {
        log.info(s1 + s2);
    }

    private static void _println(String s1, String s2) {
        log.info(s1 + "\n" + s2);
    }

    public static void debug(String msg) {
        String callerClass = Reflection.getCallerClass().getName();
        Logger.resetLog(callerClass);
        log.debug(msg);
    }

    public static void info(String msg) {
        String callerClass = Reflection.getCallerClass().getName();
        Logger.resetLog(callerClass);
        log.info(msg);
    }

    public static void info(Number msg) {
        String callerClass = Reflection.getCallerClass().getName();
        Logger.resetLog(callerClass);
        log.info(msg + "");
    }

    public static void warn(String msg) {
        String callerClass = Reflection.getCallerClass().getName();
        Logger.resetLog(callerClass);
        log.warn(msg);
    }

    public static void warn(Number msg) {
        String callerClass = Reflection.getCallerClass().getName();
        Logger.resetLog(callerClass);
        log.warn(msg + "");
    }

    public static void error(String msg) {
        String callerClass = Reflection.getCallerClass().getName();
        Logger.resetLog(callerClass);
        log.error(msg);
    }

    public static void error(Number msg) {
        String callerClass = Reflection.getCallerClass().getName();
        Logger.resetLog(callerClass);
        log.error(msg + "");
    }

    private static Log _getLog() {
        Log log = LoggerFactory.getLog();
        return log;
    }

    private static Log _getLog(String className) {
        Log log = LoggerFactory.getLog(className);
        return log;
    }

    private static void resetLog(String callerClass) {
        if (LoggerFactory.isNoArgInConstructor()) {
            log = Logger._getLog();
        } else {
            try {
                log = Logger._getLog(callerClass);
            }
            catch (Exception e) {
                log = Logger._getLog(Logger.class.getName());
            }
        }
    }
}

