/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Cache;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MoreTableStruct;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.TransformResultSet;
import org.teasoft.honey.osql.name.NameUtil;

public class SqlLib
implements BeeSql {
    private Cache cache = BeeFactory.getHoneyFactory().getCache();
    private int cacheWorkResultSetSize = HoneyConfig.getHoneyConfig().getCacheWorkResultSetSize();
    private boolean enableMultiDs;
    private static boolean showSQL = HoneyConfig.getHoneyConfig().isShowSQL();
    private static String index1 = "_SYS[index";
    private static String index2 = "]_End ";
    private static String index3 = "]";

    public SqlLib() {
        this.enableMultiDs = HoneyConfig.getHoneyConfig().enableMultiDs;
    }

    private Connection getConn() throws SQLException {
        return HoneyContext.getConn();
    }

    public <T> List<T> select(String sql, T entity) {
        return this.selectSomeField(sql, entity);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> selectSomeField(String sql, T entity) {
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "List<T>", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                return (List)cacheObj;
            }
            this.initRoute(SuidType.SELECT, entity.getClass(), sql);
        }
        Connection conn = null;
        PreparedStatement pst = null;
        Object targetObj = null;
        ArrayList<Object> rsList = null;
        Hashtable<String, Field> map = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            ResultSet rs = pst.executeQuery();
            ResultSetMetaData rmeta = rs.getMetaData();
            int columnCount = rmeta.getColumnCount();
            rsList = new ArrayList<Object>();
            map = new Hashtable<String, Field>();
            Field field = null;
            String name = null;
            boolean isFirst = true;
            while (true) {
                if (rs.next()) {
                    targetObj = entity.getClass().newInstance();
                } else {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.checkClose(pst, conn);
                    entity = null;
                    targetObj = null;
                    map = null;
                    Logger.logSQL("| <--  select rows: ", rsList.size() + "");
                    return rsList;
                }
                for (int i = 0; i < columnCount; ++i) {
                    block20: {
                        try {
                            name = SqlLib._toFieldName(rmeta.getColumnName(i + 1));
                            if (isFirst) {
                                field = entity.getClass().getDeclaredField(name);
                                map.put(name, field);
                                break block20;
                            } else {
                                field = (Field)map.get(name);
                                if (field == null) {
                                }
                            }
                        }
                        catch (NoSuchFieldException e) {}
                        continue;
                    }
                    field.setAccessible(true);
                    try {
                        field.set(targetObj, rs.getObject(i + 1));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field.set(targetObj, this._getObjectByindex(rs, field, i + 1));
                    }
                }
                rsList.add(targetObj);
                isFirst = false;
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
    }

    public String selectFun(String sql) throws ObjSQLException {
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "String", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                return (String)cacheObj;
            }
            this.initRoute(SuidType.SELECT, null, sql);
        }
        String result = null;
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            if (rs.next()) {
                result = rs.getObject(1) == null ? "" : rs.getObject(1).toString();
            }
            boolean hasMore = false;
            if (rs.next()) {
                hasMore = true;
            }
            if (hasMore) {
                throw new ObjSQLException("ObjSQLException:The size of ResultSet more than 1.");
            }
            this.addInCache(sql, result, "String", SuidType.SELECT, 1);
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return result;
    }

    public List<String[]> select(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "List<String[]>", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                return (List)cacheObj;
            }
            this.initRoute(SuidType.SELECT, null, sql);
        }
        List<Object> list = new ArrayList();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            list = TransformResultSet.toStringsList(rs);
            Logger.logSQL(" | <--  select rows: ", list.size() + "");
            this.addInCache(sql, list, "List<String[]>", SuidType.SELECT, list.size());
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return list;
    }

    public int modify(String sql) {
        if (sql == null || "".equals(sql)) {
            return -2;
        }
        this.initRoute(SuidType.MODIFY, null, sql);
        int num = 0;
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            num = pst.executeUpdate();
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        Logger.logSQL("| <--  Affected rows: ", num + "");
        this.clearInCache(sql, "int", SuidType.MODIFY);
        return num;
    }

    public String selectJson(String sql) {
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "StringJson", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                return (String)cacheObj;
            }
            this.initRoute(SuidType.SELECT, null, sql);
        }
        StringBuffer json = new StringBuffer("");
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            rs = pst.executeQuery();
            json = TransformResultSet.toJson(rs);
            this.addInCache(sql, json.toString(), "StringJson", SuidType.SELECT, -1);
            this.checkClose(pst, conn);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
        return json.toString();
    }

    public int batch(String[] sql) {
        if (sql == null) {
            return -1;
        }
        int batchSize = HoneyConfig.getHoneyConfig().getBatchSize();
        return this.batch(sql, batchSize);
    }

    public int batch(String[] sql, int batchSize) {
        if (sql == null || sql.length < 1) {
            return -1;
        }
        if (HoneyUtil.isMysql()) {
            return this.batchForMysql(sql, batchSize);
        }
        this.initRoute(SuidType.INSERT, null, sql[0]);
        int len = sql.length;
        int total = 0;
        int temp = 0;
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConn();
            boolean oldAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql[0]);
            pst = conn.prepareStatement(exe_sql);
            if (len <= batchSize) {
                total = this.batch(sql[0], 0, len, conn, pst);
            } else {
                for (int i = 0; i < len / batchSize; ++i) {
                    temp = this.batch(sql[0], i * batchSize, (i + 1) * batchSize, conn, pst);
                    total += temp;
                    pst.clearBatch();
                    pst.clearParameters();
                }
                if (len % batchSize != 0) {
                    temp = this.batch(sql[0], len - len % batchSize, len, conn, pst);
                    total += temp;
                }
            }
            conn.setAutoCommit(oldAutoCommit);
            this.checkClose(pst, conn);
            this.clearInCache(sql[0], "int[]", SuidType.INSERT);
        }
        catch (SQLException e) {
            block13: {
                if (!this.isConstraint(e)) break block13;
                e.printStackTrace();
                int n = total;
                return n;
            }
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.checkClose(pst, conn);
            this.clearInCache(sql[0], "int[]", SuidType.INSERT);
        }
        return total;
    }

    private int batch(String sql, int start, int end, Connection conn, PreparedStatement pst) throws SQLException {
        int a = 0;
        for (int i = start; i < end; ++i) {
            if (showSQL) {
                OneTimeParameter.setAttribute("_SYS_Bee_BatchInsert", i + "");
                String sql_i = i == 0 ? sql : index1 + i + index2 + sql;
                Logger.logSQL("insert[] SQL : ", sql_i);
            }
            if (i == 0) {
                this.setPreparedValues(pst, sql);
            } else {
                this.setPreparedValues(pst, index1 + i + index2 + sql);
            }
            pst.addBatch();
        }
        pst.executeBatch();
        a = pst.getUpdateCount();
        conn.commit();
        Logger.logSQL("| <-- index[" + start + "~" + (end - 1) + index3 + " Affected rows: ", a + "");
        return a;
    }

    private int batchForMysql(String[] sql, int batchSize) {
        if (sql == null || sql.length < 1) {
            return -1;
        }
        this.initRoute(SuidType.INSERT, null, sql[0]);
        int len = sql.length;
        int total = 0;
        int temp = 0;
        String placeholderValue = (String)OneTimeParameter.getAttribute("_SYS_Bee_PlaceholderValue");
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConn();
            boolean oldAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql[0]);
            if (len <= batchSize) {
                String[] batchExeSql = this.getBatchExeSql(exe_sql, len, placeholderValue);
                pst = conn.prepareStatement(batchExeSql[0]);
                total = this._batchForMysql(sql[0], 0, len, conn, pst, batchSize, batchExeSql[1]);
            } else {
                String[] batchExeSql = this.getBatchExeSql(exe_sql, batchSize, placeholderValue);
                pst = conn.prepareStatement(batchExeSql[0]);
                for (int i = 0; i < len / batchSize; ++i) {
                    temp = this._batchForMysql(sql[0], i * batchSize, (i + 1) * batchSize, conn, pst, batchSize, batchExeSql[1]);
                    total += temp;
                }
                if (len % batchSize != 0) {
                    batchExeSql = this.getBatchExeSql(exe_sql, len % batchSize, placeholderValue);
                    pst = conn.prepareStatement(batchExeSql[0]);
                    temp = this._batchForMysql(sql[0], len - len % batchSize, len, conn, pst, batchSize, batchExeSql[1]);
                    total += temp;
                }
            }
            conn.setAutoCommit(oldAutoCommit);
            this.checkClose(pst, conn);
            this.clearInCache(sql[0], "int[]", SuidType.INSERT);
        }
        catch (SQLException e) {
            block12: {
                if (!this.isConstraint(e)) break block12;
                e.printStackTrace();
                int n = total;
                return n;
            }
            throw ExceptionHelper.convert(e);
        }
        finally {
            this.checkClose(pst, conn);
            this.clearInCache(sql[0], "int[]", SuidType.INSERT);
        }
        return total;
    }

    private boolean isConstraint(SQLException e) {
        return "MySQLIntegrityConstraintViolationException".equals(e.getClass().getSimpleName()) || e.getMessage().startsWith("Duplicate entry ") || e instanceof SQLIntegrityConstraintViolationException || e.getMessage().contains("ORA-00001:") || e.getMessage().contains("Duplicate entry") || e.getMessage().contains("Duplicate Entry") || e.getMessage().contains("duplicate key") || e.getMessage().contains("DUPLICATE KEY") || e.getMessage().contains("Duplicate key") || e.getMessage().contains("Duplicate Key");
    }

    private int _batchForMysql(String sql, int start, int end, Connection conn, PreparedStatement pst, int batchSize, String batchSqlForPrint) throws SQLException {
        if (showSQL) {
            if (start == 0 || end - start != batchSize) {
                Logger.logSQL("insert[] SQL : ", batchSqlForPrint);
            }
            for (int i = start; i < end; ++i) {
                OneTimeParameter.setAttribute("_SYS_Bee_BatchInsert", i + "");
                String sql_i = i == 0 ? sql : index1 + i + index2 + sql;
                Logger.logSQL("insert[] SQL : ", sql_i);
            }
        }
        int a = 0;
        String sqlForGetValue = sql + "  [Batch:" + start / batchSize + index3;
        this.setPreparedValues(pst, sqlForGetValue);
        a = pst.executeUpdate();
        conn.commit();
        Logger.logSQL("| <-- [Batch:" + start / batchSize + index3 + " Affected rows: ", a + "");
        return a;
    }

    private String[] getBatchExeSql(String sql0, int size, String placeholderValue) {
        StringBuffer batchSql = new StringBuffer(sql0);
        StringBuffer batchSql_forPrint = new StringBuffer(sql0);
        String[] batchExeSql = new String[2];
        for (int i = 0; i < size - 1; ++i) {
            batchSql.append(",");
            batchSql.append(placeholderValue);
            if (size > 10 && i == 1) {
                batchSql_forPrint.append(",......,");
                continue;
            }
            if (size > 10 && i == size - 2) {
                batchSql_forPrint.append(placeholderValue);
                batchSql_forPrint.append("      ");
                batchSql_forPrint.append("Total of records : ");
                batchSql_forPrint.append(size);
                continue;
            }
            if (size > 10 && i > 1) continue;
            batchSql_forPrint.append(",");
            batchSql_forPrint.append(placeholderValue);
        }
        batchExeSql[0] = batchSql.toString();
        batchExeSql[1] = batchSql_forPrint.toString();
        return batchExeSql;
    }

    protected void checkClose(Statement stmt, Connection conn) {
        HoneyContext.checkClose(stmt, conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> moreTableSelect(String sql, T entity) {
        if (sql == null || "".equals(sql.trim())) {
            return null;
        }
        boolean isReg = this.updateInfoInCache(sql, "List<T>", SuidType.SELECT);
        if (isReg) {
            Object cacheObj = this.cache.get(sql);
            if (cacheObj != null) {
                return (List)cacheObj;
            }
            this.initRoute(SuidType.SELECT, entity.getClass(), sql);
        }
        Connection conn = null;
        PreparedStatement pst = null;
        Object targetObj = null;
        ArrayList rsList = null;
        try {
            conn = this.getConn();
            String exe_sql = HoneyUtil.deleteLastSemicolon(sql);
            pst = conn.prepareStatement(exe_sql);
            this.setPreparedValues(pst, sql);
            ResultSet rs = pst.executeQuery();
            rsList = new ArrayList();
            Field[] field = entity.getClass().getDeclaredFields();
            int columnCount = field.length;
            MoreTableStruct[] moreTableStruct = HoneyUtil.getMoreTableStructAndCheckBefore(entity);
            Field[] subField = new Field[2];
            String[] subUseTable = new String[2];
            String[] variableName = new String[2];
            Class[] subEntityFieldClass = new Class[2];
            for (int i = 1; i <= 2; ++i) {
                if (moreTableStruct[i] == null) continue;
                subField[i - 1] = moreTableStruct[i].subEntityField;
                variableName[i - 1] = subField[i - 1].getName();
                subEntityFieldClass[i - 1] = subField[i - 1].getType();
                subUseTable[i - 1] = moreTableStruct[i].useSubTableName;
            }
            Field[] fields1 = subEntityFieldClass[0].getDeclaredFields();
            Field[] fields2 = null;
            if (subField[1] != null) {
                fields2 = subEntityFieldClass[1].getDeclaredFields();
            }
            Map<String, String> dulSubFieldMap = moreTableStruct[0].subDulFieldMap;
            String tableName = SqlLib._toTableName(entity);
            while (true) {
                String columnName;
                String dulField;
                boolean isDul;
                Object subObj1;
                if (rs.next()) {
                    subObj1 = subEntityFieldClass[0].newInstance();
                    isDul = false;
                    dulField = "";
                } else {
                    this.addInCache(sql, rsList, "List<T>", SuidType.SELECT, rsList.size());
                    this.checkClose(pst, conn);
                    entity = null;
                    targetObj = null;
                    Logger.logSQL("| <--  select rows: ", rsList.size() + "");
                    return rsList;
                }
                for (int i = 0; i < fields1.length; ++i) {
                    if ("serialVersionUID".equals(fields1[i].getName()) || fields1[i] != null && fields1[i].isAnnotationPresent(JoinTable.class)) continue;
                    fields1[i].setAccessible(true);
                    isDul = false;
                    dulField = "";
                    try {
                        columnName = SqlLib._toColumnName(fields1[i].getName());
                        if (this.isOracle()) {
                            dulField = dulSubFieldMap.get(subUseTable[0] + "." + columnName);
                            if (dulField != null) {
                                fields1[i].set(subObj1, rs.getObject(dulField));
                                isDul = true;
                                continue;
                            }
                            fields1[i].set(subObj1, rs.getObject(columnName));
                            continue;
                        }
                        fields1[i].set(subObj1, rs.getObject(subUseTable[0] + "." + columnName));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isOracle()) {
                            fields1[i].set(subObj1, this._getObjectForMoreTable_oracle(rs, fields1[i], isDul, dulField));
                            continue;
                        }
                        fields1[i].set(subObj1, this._getObjectForMoreTable(rs, subUseTable[0], fields1[i]));
                        continue;
                    }
                    catch (SQLException e) {
                        fields1[i].set(subObj1, null);
                    }
                }
                Object subObj2 = null;
                if (subField[1] != null) {
                    subObj2 = subEntityFieldClass[1].newInstance();
                    columnName = "";
                    for (int i = 0; i < fields2.length; ++i) {
                        if ("serialVersionUID".equals(fields2[i].getName()) || fields2[i] != null && fields2[i].isAnnotationPresent(JoinTable.class)) continue;
                        fields2[i].setAccessible(true);
                        isDul = false;
                        dulField = "";
                        try {
                            columnName = SqlLib._toColumnName(fields2[i].getName());
                            if (this.isOracle()) {
                                dulField = dulSubFieldMap.get(subUseTable[1] + "." + columnName);
                                if (dulField != null) {
                                    fields2[i].set(subObj2, rs.getObject(dulField));
                                    isDul = true;
                                    continue;
                                }
                                fields2[i].set(subObj2, rs.getObject(columnName));
                                continue;
                            }
                            fields2[i].set(subObj2, rs.getObject(subUseTable[1] + "." + columnName));
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            if (this.isOracle()) {
                                fields2[i].set(subObj2, this._getObjectForMoreTable_oracle(rs, fields2[i], isDul, dulField));
                                continue;
                            }
                            fields2[i].set(subObj2, this._getObjectForMoreTable(rs, subUseTable[1], fields2[i]));
                            continue;
                        }
                        catch (SQLException e) {
                            fields2[i].set(subObj2, null);
                        }
                    }
                }
                targetObj = entity.getClass().newInstance();
                for (int i = 0; i < columnCount; ++i) {
                    if ("serialVersionUID".equals(field[i].getName())) continue;
                    if (field[i] != null && field[i].isAnnotationPresent(JoinTable.class)) {
                        field[i].setAccessible(true);
                        if (field[i].getName().equals(variableName[0])) {
                            field[i].set(targetObj, subObj1);
                            continue;
                        }
                        if (subField[1] == null || !field[i].getName().equals(variableName[1])) continue;
                        field[i].set(targetObj, subObj2);
                        continue;
                    }
                    field[i].setAccessible(true);
                    try {
                        if (this.isOracle()) {
                            field[i].set(targetObj, rs.getObject(SqlLib._toColumnName(field[i].getName())));
                            continue;
                        }
                        field[i].set(targetObj, rs.getObject(tableName + "." + SqlLib._toColumnName(field[i].getName())));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        field[i].set(targetObj, this._getObjectForMoreTable(rs, tableName, field[i]));
                        continue;
                    }
                    catch (SQLException e) {
                        field[i].set(targetObj, null);
                    }
                }
                rsList.add(targetObj);
            }
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.convert(e);
                catch (IllegalAccessException e2) {
                    throw ExceptionHelper.convert(e2);
                }
                catch (InstantiationException e3) {
                    throw ExceptionHelper.convert(e3);
                }
            }
            catch (Throwable throwable) {
                this.checkClose(pst, conn);
                throw throwable;
            }
        }
    }

    private void setPreparedValues(PreparedStatement pst, String sql) throws SQLException {
        List<PreparedValue> list = HoneyContext.getPreparedValue(sql);
        if (null != list && list.size() > 0) {
            this._setPreparedValues(pst, list);
        }
    }

    private void _setPreparedValues(PreparedStatement pst, List<PreparedValue> list) throws SQLException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int k = HoneyUtil.getJavaTypeIndex(list.get(i).getType());
            HoneyUtil.setPreparedValues(pst, k, i, list.get(i).getValue());
        }
    }

    private Object _getObject(ResultSet rs, Field field) throws SQLException {
        return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName()));
    }

    private Object _getObjectForMoreTable(ResultSet rs, String tableName, Field field) throws SQLException {
        if (this.isOracle()) {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName()));
        }
        return HoneyUtil.getResultObject(rs, field.getType().getName(), tableName + "." + SqlLib._toColumnName(field.getName()));
    }

    private Object _getObjectForMoreTable_oracle(ResultSet rs, Field field, boolean isDul, String otherName) throws SQLException {
        if (isDul) {
            return HoneyUtil.getResultObject(rs, field.getType().getName(), otherName);
        }
        return HoneyUtil.getResultObject(rs, field.getType().getName(), SqlLib._toColumnName(field.getName()));
    }

    private Object _getObjectByindex(ResultSet rs, Field field, int index) throws SQLException {
        return HoneyUtil.getResultObjectByIndex(rs, field.getType().getName(), index);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toFieldName(String columnName) {
        return NameTranslateHandle.toFieldName(columnName);
    }

    private void addInCache(String sql, Object rs, String returnType, SuidType suidType, int resultSetSize) {
        if (resultSetSize > this.cacheWorkResultSetSize) {
            HoneyContext.deleteCacheInfo(sql);
            return;
        }
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            this.cache.add(sql, rs);
        }
    }

    private boolean updateInfoInCache(String sql, String returnType, SuidType suidType) {
        return HoneyContext.updateInfoInCache(sql, returnType, suidType);
    }

    private void clearInCache(String sql, String returnType, SuidType suidType) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            HoneyContext.setCacheInfo(sql, struct);
        }
        this.cache.clear(sql);
    }

    private void initRoute(SuidType suidType, Class clazz, String sql) {
        if (!this.enableMultiDs) {
            return;
        }
        HoneyContext.initRoute(suidType, clazz, sql);
    }

    private boolean isOracle() {
        return HoneyUtil.isOracle();
    }
}

