/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.distribution.ds;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.teasoft.bee.distribution.ds.Route;
import org.teasoft.bee.osql.exception.NoConfigException;
import org.teasoft.honey.distribution.ds.RouteStruct;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;

public class OnlyMulitiDB
implements Route {
    private String defaultDs;
    private static Map<String, String> entityClassPathToDs = new ConcurrentHashMap<String, String>();
    private static Map<String, String> tableToDs = new ConcurrentHashMap<String, String>();
    private static List<String> entityClassPathToDsWithStar = new CopyOnWriteArrayList<String>();

    public OnlyMulitiDB() {
        this.init();
    }

    private void init() {
        this.defaultDs = HoneyConfig.getHoneyConfig().multiDS_defalutDS;
        if (this.defaultDs == null || "".equals(this.defaultDs.trim())) {
            throw new NoConfigException("Error: bee.dosql.multiDS.defalutDS can not null or empty when bee.dosql.multiDS.type=2! ");
        }
        String matchEntityClassPath = HoneyConfig.getHoneyConfig().multiDS_matchEntityClassPath;
        String matchTable = HoneyConfig.getHoneyConfig().multiDS_matchTable;
        if ((matchEntityClassPath == null || "".equals(matchEntityClassPath.trim())) && (matchTable == null || "".equals(matchTable.trim()))) {
            throw new NoConfigException("Error: bee.dosql.multiDS.matchEntityClassPath and bee.dosql.multiDS.matchTable can not null or empty at same time when bee.dosql.multi-DS.type=2! ");
        }
        OnlyMulitiDB.parseListToMap(matchEntityClassPath, entityClassPathToDs, true);
        OnlyMulitiDB.parseListToMap(matchTable, tableToDs, false);
    }

    private static void parseListToMap(String str, Map<String, String> map, boolean isAdd2List) {
        if (str == null || "".equals(str.trim())) {
            return;
        }
        String[] str1 = str.split(";");
        for (int i = 0; i < str1.length; ++i) {
            String[] str2 = str1[i].split(":");
            String[] str3 = str2[1].trim().split(",");
            for (int k = 0; k < str3.length; ++k) {
                if (isAdd2List && str3[k].trim().endsWith(".**")) {
                    entityClassPathToDsWithStar.add(str3[k].trim());
                }
                if (str3[k].trim().indexOf(".") > 0) {
                    map.put(str3[k].trim(), str2[0].trim());
                    continue;
                }
                map.put(str3[k].trim().toLowerCase(), str2[0].trim());
            }
        }
    }

    public String getDsName() {
        RouteStruct routeStruct = HoneyContext.getCurrentRoute();
        if (routeStruct == null) {
            return this.defaultDs;
        }
        String ds = null;
        String tables = routeStruct.getTableNames();
        Class clazz = routeStruct.getEntityClass();
        if (clazz == null) {
            ds = this.getDsViaTables(tables);
            if (ds != null) {
                return ds;
            }
            return this.defaultDs;
        }
        String fullName = clazz.getName();
        ds = entityClassPathToDs.get(fullName);
        if (ds != null) {
            return ds;
        }
        if (clazz.getPackage() != null) {
            String packageName = clazz.getPackage().getName();
            ds = entityClassPathToDs.get(packageName + ".*");
            if (ds != null) {
                return ds;
            }
            for (int i = 0; i < entityClassPathToDsWithStar.size(); ++i) {
                String prePath;
                String s = entityClassPathToDsWithStar.get(i);
                if (!s.endsWith(".**") || !fullName.startsWith(prePath = s.substring(0, s.length() - 2))) continue;
                return entityClassPathToDs.get(s);
            }
            ds = this.getDsViaTables(tables);
            if (ds != null) {
                return ds;
            }
        }
        return this.defaultDs;
    }

    private String getDsViaTables(String tables) {
        String[] ts;
        String ds = null;
        if (tables != null && (!tables.contains("##") ? (ds = tableToDs.get(tables.trim().toLowerCase())) != null : (ds = tableToDs.get((ts = tables.split("##"))[0].toLowerCase())) != null)) {
            return ds;
        }
        return ds;
    }
}

