/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.autogen;

import java.lang.reflect.Field;
import java.util.Map;
import org.teasoft.bee.osql.PreparedSql;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.honey.osql.autogen.Java2DbType;
import org.teasoft.honey.osql.core.BeeFactoryHelper;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.name.NameUtil;

public class Ddl {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static PreparedSql preparedSql = BeeFactoryHelper.getPreparedSql();

    private static Map<String, String> getJava2DbType() {
        return Java2DbType.getJava2DbType(HoneyContext.getDbDialect());
    }

    public static <T> boolean createTable(T entity, boolean isDropExistTable) {
        if (isDropExistTable) {
            String tableName;
            block7: {
                tableName = Ddl._toTableName(entity);
                boolean second = false;
                try {
                    String sql0 = "";
                    if (HoneyUtil.isOracle() || HoneyUtil.isSqlServer()) {
                        sql0 = "DROP TABLE " + tableName;
                    } else {
                        sql0 = " DROP TABLE IF EXISTS " + tableName;
                        second = true;
                    }
                    preparedSql.modify(sql0);
                }
                catch (Exception e) {
                    if (!second) break block7;
                    try {
                        preparedSql.modify("DROP TABLE " + tableName);
                    }
                    catch (Exception e2) {
                        Logger.warn(e2.getMessage());
                    }
                }
            }
            return Ddl.createTable(entity, tableName);
        }
        return Ddl.createTable(entity);
    }

    public static <T> boolean createTable(T entity) {
        return Ddl.createTable(entity, null);
    }

    private static <T> boolean createTable(T entity, String tableName) {
        boolean result = false;
        try {
            preparedSql.modify(Ddl.toCreateTableSQL(entity, tableName));
            result = true;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            result = false;
        }
        return result;
    }

    public static <T> String toCreateTableSQL(T entity) {
        return Ddl.toCreateTableSQL(entity, null);
    }

    private static <T> String toCreateTableSQL(T entity, String tableName) {
        if (HoneyUtil.isSQLite()) {
            return Ddl.toCreateTableSQLForSQLite(entity, tableName);
        }
        if (HoneyUtil.isMysql()) {
            return Ddl.toCreateTableSQLForMySQL(entity, tableName);
        }
        if ("H2".equalsIgnoreCase(HoneyContext.getDbDialect())) {
            return Ddl.toCreateTableSQLForH2(entity, tableName);
        }
        if ("PostgreSQL".equalsIgnoreCase(HoneyContext.getDbDialect())) {
            return Ddl.toCreateTableSQLForPostgreSQL(entity, tableName);
        }
        if (HoneyUtil.isSqlServer()) {
            return Ddl.toCreateTableSQLForSQLSERVER(entity, tableName);
        }
        return Ddl._toCreateTableSQL(entity, tableName);
    }

    private static <T> String _toCreateTableSQL(T entity, String tableName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE " + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName())).append("  ");
            sqlBuffer.append(Ddl.getJava2DbType().get(fields[i].getType().getName()));
            if ("id".equalsIgnoreCase(fields[i].getName())) {
                sqlBuffer.append(" PRIMARY KEY");
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static <T> String toCreateTableSQLForSQLite(T entity, String tableName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE " + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName())).append("  ");
            if ("id".equalsIgnoreCase(fields[i].getName())) {
                sqlBuffer.append(" INTEGER PRIMARY KEY NOT NULL");
            } else {
                sqlBuffer.append(Ddl.getJava2DbType().get(fields[i].getType().getName()));
                String type = Ddl.getJava2DbType().get(fields[i].getType().getName());
                if ("timestamp".equalsIgnoreCase(type) || "datetime".equalsIgnoreCase(type)) {
                    sqlBuffer.append(" DEFAULT CURRENT_TIMESTAMP");
                } else {
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static <T> String toCreateTableSQLForMySQL(T entity, String tableName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE " + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName())).append("  ");
            if ("id".equalsIgnoreCase(fields[i].getName())) {
                sqlBuffer.append("bigint(20) PRIMARY KEY NOT NULL AUTO_INCREMENT");
            } else {
                sqlBuffer.append(Ddl.getJava2DbType().get(fields[i].getType().getName()));
                String type = Ddl.getJava2DbType().get(fields[i].getType().getName());
                if ("timestamp".equalsIgnoreCase(type) || "datetime".equalsIgnoreCase(type)) {
                    sqlBuffer.append(" DEFAULT CURRENT_TIMESTAMP");
                } else {
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static <T> String toCreateTableSQLForH2(T entity, String tableName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE " + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName())).append("  ");
            if ("id".equalsIgnoreCase(fields[i].getName())) {
                sqlBuffer.append("bigint PRIMARY KEY NOT NULL");
            } else {
                sqlBuffer.append(Ddl.getJava2DbType().get(fields[i].getType().getName()));
                String type = Ddl.getJava2DbType().get(fields[i].getType().getName());
                if ("timestamp".equalsIgnoreCase(type) || "datetime".equalsIgnoreCase(type)) {
                    sqlBuffer.append(" DEFAULT CURRENT_TIMESTAMP");
                } else {
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static <T> String toCreateTableSQLForPostgreSQL(T entity, String tableName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE " + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName())).append("  ");
            if ("id".equalsIgnoreCase(fields[i].getName())) {
                sqlBuffer.append("bigserial NOT NULL");
            } else {
                sqlBuffer.append(Ddl.getJava2DbType().get(fields[i].getType().getName()));
                String type = Ddl.getJava2DbType().get(fields[i].getType().getName());
                if ("timestamp".equalsIgnoreCase(type) || "datetime".equalsIgnoreCase(type)) {
                    sqlBuffer.append(" DEFAULT CURRENT_TIMESTAMP");
                } else {
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    private static <T> String toCreateTableSQLForSQLSERVER(T entity, String tableName) {
        if (tableName == null) {
            tableName = Ddl._toTableName(entity);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE " + tableName + " (").append(LINE_SEPARATOR);
        Field[] fields = entity.getClass().getDeclaredFields();
        boolean hasCurrentTime = false;
        for (int i = 0; i < fields.length; ++i) {
            if (Ddl.isSkipField(fields[i])) {
                if (i != fields.length - 1) continue;
                sqlBuffer.delete(sqlBuffer.length() - 5, sqlBuffer.length() - 2);
                continue;
            }
            sqlBuffer.append(Ddl._toColumnName(fields[i].getName())).append("  ");
            if ("id".equalsIgnoreCase(fields[i].getName())) {
                sqlBuffer.append("bigint PRIMARY KEY NOT NULL");
            } else {
                String type = Ddl.getJava2DbType().get(fields[i].getType().getName());
                if ("timestamp".equalsIgnoreCase(type)) {
                    if (!hasCurrentTime) {
                        sqlBuffer.append(type);
                        sqlBuffer.append(" ");
                        hasCurrentTime = true;
                    } else {
                        sqlBuffer.append("datetime DEFAULT NULL");
                    }
                } else {
                    sqlBuffer.append(type);
                    sqlBuffer.append(" DEFAULT NULL");
                }
            }
            if (i != fields.length - 1) {
                sqlBuffer.append(",  ");
            } else {
                sqlBuffer.append("  ");
            }
            sqlBuffer.append(LINE_SEPARATOR);
        }
        sqlBuffer.append(" )");
        return sqlBuffer.toString();
    }

    public static void setDynamicParameter(String para, String value) {
        BeeFactoryHelper.getSuid().setDynamicParameter(para, value);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static boolean isSkipField(Field field) {
        if (field != null) {
            if ("serialVersionUID".equals(field.getName())) {
                return true;
            }
            if (field.isSynthetic()) {
                return true;
            }
            if (field.isAnnotationPresent(JoinTable.class)) {
                return true;
            }
        }
        return false;
    }
}

