/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.chain;

import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.chain.Select;
import org.teasoft.bee.osql.exception.BeeErrorFieldException;
import org.teasoft.honey.osql.chain.AbstractSelectToSql;
import org.teasoft.honey.osql.core.Check;
import org.teasoft.honey.osql.core.CheckField;
import org.teasoft.honey.osql.core.FunAndOrderTypeMap;
import org.teasoft.honey.osql.core.K;

public class SelectImpl
extends AbstractSelectToSql
implements Select {
    private static final String STAR = "*";
    private static final String DISTINCT = K.distinct;
    private static final String L_PARENTHESES = "(";
    private static final String R_PARENTHESES = ")";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String AND = " " + K.and + " ";
    private boolean isStartField = true;
    private boolean isStartWhere = true;
    private boolean isStartOn = true;
    private boolean isAddAnd = false;
    private boolean isStartGroupBy = true;
    private boolean isStartHaving = true;
    private boolean isStartOrderBy = true;

    public Select select() {
        if (this.isStartField) {
            this.sql.append(K.select).append(SPACE);
            this.sql.append(STAR);
            this.isStartField = false;
        }
        return this;
    }

    public Select select(String column) {
        this.checkField(column);
        if (this.isStartField) {
            this.sql.append(K.select).append(SPACE);
            this.sql.append(column);
            this.isStartField = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(column);
        }
        return this;
    }

    public Select distinct(String field) {
        this.checkField(field);
        return this.select(DISTINCT + L_PARENTHESES + field + R_PARENTHESES);
    }

    public Select from(String table) {
        this.checkExpression(table);
        this.sql.append(SPACE).append(K.from).append(SPACE);
        this.sql.append(table);
        return this;
    }

    public Select join(String anotherTable) {
        this.checkExpression(anotherTable);
        this.sql.append(SPACE).append(K.join).append(SPACE);
        this.sql.append(anotherTable);
        return this;
    }

    public Select innerJoin(String anotherTable) {
        this.checkExpression(anotherTable);
        this.sql.append(SPACE).append(K.innerJoin).append(SPACE);
        this.sql.append(anotherTable);
        return this;
    }

    public Select leftJoin(String anotherTable) {
        this.checkExpression(anotherTable);
        this.sql.append(SPACE).append(K.leftJoin).append(SPACE);
        this.sql.append(anotherTable);
        return this;
    }

    public Select rightJoin(String anotherTable) {
        this.checkExpression(anotherTable);
        this.sql.append(SPACE).append(K.rightJoin).append(SPACE);
        this.sql.append(anotherTable);
        return this;
    }

    public Select on() {
        this.sql.append(SPACE).append(K.on).append(SPACE);
        this.isStartOn = false;
        return this;
    }

    public Select on(String expression) {
        this.checkExpression(expression);
        if (this.isStartOn) {
            this.sql.append(SPACE).append(K.on).append(SPACE);
            this.sql.append(expression);
            this.isStartOn = false;
        } else {
            if (this.isAddAnd) {
                this.sql.append(AND);
            }
            this.sql.append(expression);
            this.isAddAnd = true;
        }
        return this;
    }

    public Select groupBy(String field) {
        this.checkField(field);
        if (this.isStartGroupBy) {
            this.sql.append(SPACE).append(K.groupBy).append(SPACE);
            this.sql.append(field);
            this.isStartGroupBy = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(field);
        }
        return this;
    }

    public Select having(String expression) {
        this.checkExpression(expression);
        if (this.isStartHaving) {
            this.sql.append(SPACE).append(K.having).append(SPACE);
            this.sql.append(expression);
            this.isStartHaving = false;
        } else {
            this.sql.append(AND);
            this.sql.append(expression);
        }
        return this;
    }

    public Select orderBy(String field) {
        this.checkField(field);
        if (this.isStartOrderBy) {
            this.sql.append(SPACE).append(K.orderBy).append(SPACE);
            this.sql.append(field);
            this.isStartOrderBy = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(field);
        }
        return this;
    }

    public Select orderBy(String field, OrderType orderType) {
        this.checkField(field);
        if (this.isStartOrderBy) {
            this.sql.append(SPACE).append(K.orderBy).append(SPACE);
            this.sql.append(field);
            this.sql.append(SPACE);
            this.sql.append(FunAndOrderTypeMap.transfer(orderType.getName()));
            this.isStartOrderBy = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(field);
            this.sql.append(SPACE);
            this.sql.append(FunAndOrderTypeMap.transfer(orderType.getName()));
        }
        return this;
    }

    private Select useSubSelect(String keyword, String subSelect) {
        this.sql.append(keyword);
        this.sql.append(SPACE);
        this.sql.append(L_PARENTHESES);
        this.sql.append(subSelect);
        this.sql.append(R_PARENTHESES);
        return this;
    }

    private Select useSubSelect(String field, String keyword, String subSelect) {
        this.checkField(field);
        this.sql.append(field);
        this.sql.append(SPACE);
        this.sql.append(keyword);
        this.sql.append(SPACE);
        this.sql.append(L_PARENTHESES);
        this.sql.append(subSelect);
        this.sql.append(R_PARENTHESES);
        return this;
    }

    public Select exists(Select subSelect) {
        return this.useSubSelect(K.exists, subSelect.toSQL());
    }

    public Select notExists(Select subSelect) {
        return this.useSubSelect(K.notExists, subSelect.toSQL());
    }

    public Select in(String field, Select subSelect) {
        return this.useSubSelect(field, K.in, subSelect.toSQL());
    }

    public Select notIn(String field, Select subSelect) {
        return this.useSubSelect(field, K.notIn, subSelect.toSQL());
    }

    public Select start(int start) {
        this.start = start;
        return this;
    }

    public Select size(int size) {
        this.size = size;
        return this;
    }

    public Select lParentheses() {
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.isAddAnd = false;
        this.sql.append(L_PARENTHESES);
        return this;
    }

    public Select rParentheses() {
        this.sql.append(R_PARENTHESES);
        this.isAddAnd = true;
        return this;
    }

    public Select where() {
        this.sql.append(SPACE).append(K.where).append(SPACE);
        this.isStartWhere = false;
        return this;
    }

    public Select where(String expression) {
        this.checkExpression(expression);
        if (this.isStartWhere) {
            this.sql.append(SPACE).append(K.where).append(SPACE);
            this.sql.append(expression);
            this.isStartWhere = false;
            this.isAddAnd = true;
        } else {
            if (this.isAddAnd) {
                this.sql.append(AND);
            }
            this.sql.append(expression);
            this.isAddAnd = true;
        }
        return this;
    }

    public Select op(String field, Op opType, String value) {
        this.checkField(field);
        if (opType == Op.in) {
            return this.in(field, value);
        }
        if (opType == Op.notIn) {
            return this.notIn(field, value);
        }
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(opType.getOperator());
        this.sql.append("'");
        this.sql.append(value);
        this.sql.append("'");
        this.isAddAnd = true;
        return this;
    }

    public Select op(String field, Op opType, Number value) {
        this.checkField(field);
        if (opType == Op.in) {
            return this.in(field, value);
        }
        if (opType == Op.notIn) {
            return this.notIn(field, value);
        }
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(opType.getOperator());
        this.sql.append(value);
        this.isAddAnd = true;
        return this;
    }

    public Select op(String field, String value) {
        this.checkField(field);
        return this.op(field, Op.eq, value);
    }

    public Select op(String field, Number value) {
        this.checkField(field);
        return this.op(field, Op.eq, value);
    }

    public Select and() {
        this.sql.append(AND);
        this.isAddAnd = false;
        return this;
    }

    public Select or() {
        this.sql.append(SPACE).append(K.or).append(SPACE);
        this.isAddAnd = false;
        return this;
    }

    public Select in(String field, Number ... valueList) {
        this.checkField(field);
        return this.inOrNotIn(field, K.in, valueList);
    }

    public Select notIn(String field, Number ... valueList) {
        this.checkField(field);
        return this.inOrNotIn(field, K.notIn, valueList);
    }

    private Select inOrNotIn(String field, String op, Number ... valueList) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        String value = "";
        for (int i = 0; i < valueList.length; ++i) {
            value = i == 0 ? value + valueList[i] : value + COMMA + valueList[i];
        }
        this.sql.append(field + SPACE + op + " (" + value + R_PARENTHESES);
        return this;
    }

    public Select in(String field, String valueList) {
        return this.inOrNotIn(field, K.in, valueList);
    }

    public Select notIn(String field, String valueList) {
        return this.inOrNotIn(field, K.notIn, valueList);
    }

    private Select inOrNotIn(String field, String op, String valueList) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        valueList = valueList.replace(COMMA, "','");
        this.sql.append(field + SPACE + op + " ('" + valueList + "')");
        return this;
    }

    public Select between(String field, Number low, Number high) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.between).append(SPACE);
        this.sql.append(low);
        this.sql.append(AND);
        this.sql.append(high);
        this.isAddAnd = true;
        return this;
    }

    public Select notBetween(String field, Number low, Number high) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.notBetween).append(SPACE);
        this.sql.append(low);
        this.sql.append(AND);
        this.sql.append(high);
        this.isAddAnd = true;
        return this;
    }

    public Select isNull(String field) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.isNull).append(SPACE);
        return this;
    }

    public Select isNotNull(String field) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.isNotNull).append(SPACE);
        return this;
    }

    private void checkField(String field) {
        if (CheckField.isNotValid(field)) {
            throw new BeeErrorFieldException("The field: '" + field + "' is invalid!");
        }
    }

    private void checkExpression(String expression) {
        if (Check.isNotValidExpression(expression)) {
            throw new BeeErrorFieldException("The expression: '" + expression + "' is invalid!");
        }
    }
}

