/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.chain;

import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.chain.Update;
import org.teasoft.bee.osql.exception.BeeErrorFieldException;
import org.teasoft.honey.osql.chain.AbstractToSql;
import org.teasoft.honey.osql.core.Check;
import org.teasoft.honey.osql.core.CheckField;
import org.teasoft.honey.osql.core.K;

public class UpdateImpl
extends AbstractToSql
implements Update {
    private boolean isStartWhere = true;
    private boolean isAddAnd = false;
    private boolean isStartTable = true;
    private boolean isStartSet = true;
    private static final String L_PARENTHESES = "(";
    private static final String R_PARENTHESES = ")";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String AND = " " + K.and + " ";

    public UpdateImpl() {
        this.sql.append("update ");
    }

    public Update update(String table) {
        if (this.isStartTable) {
            this.sql.append(table);
            this.isStartTable = false;
        } else {
            this.sql.append(COMMA);
            this.sql.append(table);
        }
        return this;
    }

    public Update set(String field, String value) {
        if (!this.isStartSet) {
            this.sql.append(" , ");
        }
        if (this.isStartSet) {
            this.sql.append(" set ");
            this.isStartSet = false;
        }
        this.sql.append(field);
        this.sql.append("=");
        this.sql.append("'");
        this.sql.append(value);
        this.sql.append("'");
        return this;
    }

    public Update set(String field, Number value) {
        if (!this.isStartSet) {
            this.sql.append(" , ");
        }
        if (this.isStartSet) {
            this.sql.append(" set ");
            this.isStartSet = false;
        }
        this.sql.append(field);
        this.sql.append("=");
        this.sql.append(value);
        return this;
    }

    public Update lParentheses() {
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.isAddAnd = false;
        this.sql.append(L_PARENTHESES);
        return this;
    }

    public Update rParentheses() {
        this.sql.append(R_PARENTHESES);
        this.isAddAnd = true;
        return this;
    }

    public Update where() {
        this.sql.append(SPACE).append(K.where).append(SPACE);
        this.isStartWhere = false;
        return this;
    }

    public Update where(String expression) {
        this.checkExpression(expression);
        if (this.isStartWhere) {
            this.sql.append(SPACE).append(K.where).append(SPACE);
            this.sql.append(expression);
            this.isStartWhere = false;
            this.isAddAnd = true;
        } else {
            if (this.isAddAnd) {
                this.sql.append(AND);
            }
            this.sql.append(expression);
            this.isAddAnd = true;
        }
        return this;
    }

    public Update op(String field, Op opType, String value) {
        this.checkField(field);
        if (opType == Op.in) {
            return this.in(field, value);
        }
        if (opType == Op.notIn) {
            return this.notIn(field, value);
        }
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(opType.getOperator());
        this.sql.append("'");
        this.sql.append(value);
        this.sql.append("'");
        this.isAddAnd = true;
        return this;
    }

    public Update op(String field, Op opType, Number value) {
        this.checkField(field);
        if (opType == Op.in) {
            return this.in(field, value);
        }
        if (opType == Op.notIn) {
            return this.notIn(field, value);
        }
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(opType.getOperator());
        this.sql.append(value);
        this.isAddAnd = true;
        return this;
    }

    public Update op(String field, String value) {
        this.checkField(field);
        return this.op(field, Op.eq, value);
    }

    public Update op(String field, Number value) {
        this.checkField(field);
        return this.op(field, Op.eq, value);
    }

    public Update and() {
        this.sql.append(AND);
        this.isAddAnd = false;
        return this;
    }

    public Update or() {
        this.sql.append(SPACE).append(K.or).append(SPACE);
        this.isAddAnd = false;
        return this;
    }

    public Update in(String field, Number ... valueList) {
        this.checkField(field);
        return this.inOrNotIn(field, K.in, valueList);
    }

    public Update notIn(String field, Number ... valueList) {
        this.checkField(field);
        return this.inOrNotIn(field, K.notIn, valueList);
    }

    private Update inOrNotIn(String field, String op, Number ... valueList) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        String value = "";
        for (int i = 0; i < valueList.length; ++i) {
            value = i == 0 ? value + valueList[i] : value + COMMA + valueList[i];
        }
        this.sql.append(field + SPACE + op + " (" + value + R_PARENTHESES);
        return this;
    }

    public Update in(String field, String valueList) {
        return this.inOrNotIn(field, K.in, valueList);
    }

    public Update notIn(String field, String valueList) {
        return this.inOrNotIn(field, K.notIn, valueList);
    }

    private Update inOrNotIn(String field, String op, String valueList) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        valueList = valueList.replace(COMMA, "','");
        this.sql.append(field + SPACE + op + " ('" + valueList + "')");
        return this;
    }

    public Update between(String field, Number low, Number high) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.between).append(SPACE);
        this.sql.append(low);
        this.sql.append(AND);
        this.sql.append(high);
        this.isAddAnd = true;
        return this;
    }

    public Update notBetween(String field, Number low, Number high) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.notBetween).append(SPACE);
        this.sql.append(low);
        this.sql.append(AND);
        this.sql.append(high);
        this.isAddAnd = true;
        return this;
    }

    public Update isNull(String field) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.isNull).append(SPACE);
        return this;
    }

    public Update isNotNull(String field) {
        this.checkField(field);
        if (this.isAddAnd) {
            this.sql.append(AND);
        }
        this.sql.append(field);
        this.sql.append(SPACE).append(K.isNotNull).append(SPACE);
        return this;
    }

    private void checkField(String field) {
        if (CheckField.isNotValid(field)) {
            throw new BeeErrorFieldException("The field: '" + field + "' is invalid!");
        }
    }

    private void checkExpression(String expression) {
        if (Check.isNotValidExpression(expression)) {
            throw new BeeErrorFieldException("The expression: '" + expression + "' is invalid!");
        }
    }
}

