/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.teasoft.bee.osql.BeeAbstractFactory;
import org.teasoft.honey.distribution.ds.Router;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyFactory;
import org.teasoft.honey.osql.core.Logger;

public class BeeFactory
extends BeeAbstractFactory {
    private static BeeFactory instance = new BeeFactory();
    private static HoneyFactory honeyFactory = null;

    public static HoneyFactory getHoneyFactory() {
        if (honeyFactory == null) {
            honeyFactory = new HoneyFactory();
        }
        return honeyFactory;
    }

    private BeeFactory() {
    }

    public static BeeFactory getInstance() {
        return instance;
    }

    public DataSource getDataSource() {
        if (super.getDataSourceMap() == null) {
            return super.getDataSource();
        }
        return this._getDsFromDsMap();
    }

    private DataSource _getDsFromDsMap() {
        String dsName = Router.getDsName();
        return (DataSource)this.getDataSourceMap().get(dsName);
    }

    protected void parseDbNameByDsMap() {
        Map dsMap = this.getDataSourceMap();
        if (dsMap == null) {
            return;
        }
        HashMap<String, String> dsName2DbName = new HashMap<String, String>();
        for (Map.Entry entry : dsMap.entrySet()) {
            dsName2DbName.put((String)entry.getKey(), this.getDbName((DataSource)entry.getValue()));
        }
        HoneyContext.setDsName2DbName(dsName2DbName);
        Logger.info("Parse DataSourceMap: dataSource name to database name , result: " + dsName2DbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDbName(DataSource ds) {
        Connection conn = null;
        String dbName = null;
        try {
            conn = ds.getConnection();
            if (conn != null) {
                dbName = conn.getMetaData().getDatabaseProductName();
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e2) {
                Logger.error(e2.getMessage());
            }
        }
        return dbName;
    }
}

