/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.List;
import org.teasoft.honey.distribution.ds.Router;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.util.MD5;

public class CacheKey {
    private static final String SEPARATOR = " (@separator#) ";
    private static boolean cacheKeyUseMD5 = HoneyConfig.getHoneyConfig().cache_keyUseMD5;

    public static String genKey(String key) {
        String str = CacheKey.fullSql(key);
        if (cacheKeyUseMD5) {
            str = MD5.getMd5(str);
        }
        return str;
    }

    private static String fullSql(String sql) {
        String value = "";
        String returnType = "";
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            List<PreparedValue> list = HoneyContext.justGetPreparedValue(sql);
            value = HoneyUtil.list2Value(list, true);
            returnType = struct.getReturnType();
        }
        StringBuffer strBuf = new StringBuffer();
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().multiDS_enable;
        int multiDsType = HoneyConfig.getHoneyConfig().multiDS_type;
        if (enableMultiDs && multiDsType == 2) {
            String ds = Router.getDsName();
            strBuf.append("DataSourceName:");
            strBuf.append(ds);
            strBuf.append(SEPARATOR);
        }
        strBuf.append(sql);
        if (value != null && !"".equals(value.trim())) {
            strBuf.append(SEPARATOR);
            strBuf.append("[values]: ");
            strBuf.append(value);
        }
        strBuf.append(SEPARATOR);
        strBuf.append("[returnType]: ");
        strBuf.append(returnType);
        return strBuf.toString();
    }

    static List<String> genTableNameList(String sql) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        ArrayList<String> list = new ArrayList<String>();
        if (struct != null) {
            String tableNames = struct.getTableNames();
            String[] tabs = tableNames.trim().split("##");
            for (int i = 0; i < tabs.length; ++i) {
                list.add(tabs[i]);
            }
        }
        return list;
    }
}

