/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.ConditionImpl;
import org.teasoft.honey.osql.core.Expression;
import org.teasoft.honey.osql.core.FunAndOrderTypeMap;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.util.StringUtils;

public class ConditionHelper {
    static boolean isNeedAnd = true;
    private static final String ONE_SPACE = " ";
    private static final String setAdd = "setAdd";
    private static final String setMultiply = "setMultiply";
    private static final String setAddField = "setAddField";
    private static final String setMultiplyField = "setMultiplyField";
    private static final String setWithField = "setWithField";

    private static DbFeature getDbFeature() {
        return BeeFactory.getHoneyFactory().getDbFeature();
    }

    static boolean processConditionForUpdateSet(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition) {
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> updateSetList = conditionImpl.getUpdateExpList();
        boolean firstSet = true;
        if (updateSetList != null && updateSetList.size() > 0 && SuidType.UPDATE != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support the method set ,setAdd or setMultiply!");
        }
        PreparedValue preparedValue = null;
        Expression expression = null;
        for (int j = 0; updateSetList != null && j < updateSetList.size(); ++j) {
            expression = updateSetList.get(j);
            String opType = expression.getOpType();
            if (expression.getValue() == null) {
                throw new BeeErrorGrammarException(conditionImpl.getSuidType() + ": the num of " + opType + " is null");
            }
            if (firstSet) {
                firstSet = false;
            } else {
                sqlBuffer.append(",");
            }
            sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), null));
            sqlBuffer.append("=");
            if (opType != null) {
                if (setWithField.equals(opType)) {
                    sqlBuffer.append(ConditionHelper._toColumnName((String)expression.getValue()));
                } else {
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName()));
                }
            }
            if (setAddField.equals(opType)) {
                sqlBuffer.append("+");
                sqlBuffer.append(ConditionHelper._toColumnName((String)expression.getValue()));
                continue;
            }
            if (setMultiplyField.equals(opType)) {
                sqlBuffer.append("*");
                sqlBuffer.append(ConditionHelper._toColumnName((String)expression.getValue()));
                continue;
            }
            if (setAdd.equals(opType)) {
                sqlBuffer.append("+");
            } else if (setMultiply.equals(opType)) {
                sqlBuffer.append("*");
            }
            if (setWithField.equals(opType)) continue;
            sqlBuffer.append("?");
            preparedValue = new PreparedValue();
            preparedValue.setType(expression.getValue().getClass().getName());
            preparedValue.setValue(expression.getValue());
            list.add(preparedValue);
        }
        return firstSet;
    }

    static boolean processCondition(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition, boolean firstWhere) {
        return ConditionHelper.processCondition(sqlBuffer, list, condition, firstWhere, null);
    }

    static boolean processCondition(StringBuffer sqlBuffer, List<PreparedValue> list, Condition condition, boolean firstWhere, String[] useSubTableNames) {
        List<Expression> updateSetList;
        Boolean isForUpdate;
        if (condition == null) {
            return firstWhere;
        }
        PreparedValue preparedValue = null;
        boolean isFirstWhere = firstWhere;
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<Expression> expList = conditionImpl.getExpList();
        Expression expression = null;
        Integer start = conditionImpl.getStart();
        if (start != null && SuidType.SELECT != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support paging with start !");
        }
        for (int j = 0; j < expList.size(); ++j) {
            expression = expList.get(j);
            String opType = expression.getOpType();
            if (("groupBy".equalsIgnoreCase(opType) || "having".equalsIgnoreCase(opType)) && SuidType.SELECT != conditionImpl.getSuidType()) {
                throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support the opType: " + opType + "!");
            }
            if (firstWhere) {
                if ("groupBy".equalsIgnoreCase(opType) || "having".equalsIgnoreCase(opType) || "orderBy".equalsIgnoreCase(opType)) {
                    firstWhere = false;
                } else {
                    sqlBuffer.append(ONE_SPACE).append(K.where).append(ONE_SPACE);
                    firstWhere = false;
                    isNeedAnd = false;
                    isFirstWhere = false;
                }
            }
            if (Op.in.getOperator().equalsIgnoreCase(opType) || Op.notIn.getOperator().equalsIgnoreCase(opType)) {
                int i;
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                if (HoneyUtil.isSqlKeyWordUpper()) {
                    sqlBuffer.append(expression.getOpType().toUpperCase());
                } else {
                    sqlBuffer.append(expression.getOpType());
                }
                sqlBuffer.append(" (");
                sqlBuffer.append("?");
                String str = expression.getValue().toString();
                String[] values = str.trim().split(",");
                for (i = 1; i < values.length; ++i) {
                    sqlBuffer.append(",?");
                }
                sqlBuffer.append(")");
                for (i = 0; i < values.length; ++i) {
                    preparedValue = new PreparedValue();
                    preparedValue.setType(values[i].getClass().getName());
                    preparedValue.setValue(values[i]);
                    list.add(preparedValue);
                }
                isNeedAnd = true;
                continue;
            }
            if (Op.like.getOperator().equalsIgnoreCase(opType) || Op.notLike.getOperator().equalsIgnoreCase(opType)) {
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                if (HoneyUtil.isSqlKeyWordUpper()) {
                    sqlBuffer.append(expression.getOpType().toUpperCase());
                } else {
                    sqlBuffer.append(expression.getOpType());
                }
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue().getClass().getName());
                preparedValue.setValue(expression.getValue());
                list.add(preparedValue);
                isNeedAnd = true;
                continue;
            }
            if (" between ".equalsIgnoreCase(opType) || " not between ".equalsIgnoreCase(opType)) {
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                sqlBuffer.append(opType);
                sqlBuffer.append("?");
                sqlBuffer.append(ONE_SPACE + K.and + ONE_SPACE);
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue().getClass().getName());
                preparedValue.setValue(expression.getValue());
                list.add(preparedValue);
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue2().getClass().getName());
                preparedValue.setValue(expression.getValue2());
                list.add(preparedValue);
                isNeedAnd = true;
                continue;
            }
            if ("groupBy".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException("BeeErrorGrammarException: " + conditionImpl.getSuidType() + " do not support 'group by' !");
                }
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                continue;
            }
            if ("having".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'having' !");
                }
                if (5 != expression.getOpNum()) continue;
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(FunAndOrderTypeMap.transfer(expression.getValue3().toString()));
                sqlBuffer.append("(");
                if (FunctionType.COUNT.getName().equals(expression.getValue3()) && "*".equals(expression.getFieldName().trim())) {
                    sqlBuffer.append("*");
                } else {
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                }
                sqlBuffer.append(")");
                sqlBuffer.append(expression.getValue4());
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue2().getClass().getName());
                preparedValue.setValue(expression.getValue2());
                list.add(preparedValue);
                continue;
            }
            if ("orderBy".equalsIgnoreCase(opType)) {
                if (SuidType.SELECT != conditionImpl.getSuidType()) {
                    throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support 'order by' !");
                }
                sqlBuffer.append(expression.getValue());
                if (4 == expression.getOpNum()) {
                    sqlBuffer.append(FunAndOrderTypeMap.transfer(expression.getValue3().toString()));
                    sqlBuffer.append("(");
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                    sqlBuffer.append(")");
                } else {
                    sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
                }
                if (3 != expression.getOpNum() && 4 != expression.getOpNum()) continue;
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(FunAndOrderTypeMap.transfer(expression.getValue2().toString()));
                continue;
            }
            if (expression.getOpNum() == -2) {
                ConditionHelper.adjustAnd(sqlBuffer);
                sqlBuffer.append(expression.getValue());
                continue;
            }
            if (expression.getOpNum() == -1) {
                sqlBuffer.append(expression.getValue());
                isNeedAnd = true;
                continue;
            }
            if (expression.getOpNum() == 1) {
                sqlBuffer.append(ONE_SPACE);
                sqlBuffer.append(expression.getValue());
                sqlBuffer.append(ONE_SPACE);
                isNeedAnd = false;
                continue;
            }
            ConditionHelper.adjustAnd(sqlBuffer);
            sqlBuffer.append(ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames));
            if (expression.getValue() == null) {
                if ("=".equals(expression.getOpType())) {
                    sqlBuffer.append(ONE_SPACE + K.isNull);
                } else {
                    sqlBuffer.append(ONE_SPACE + K.isNotNull);
                    if (!"!=".equals(expression.getOpType())) {
                        String fieldName = ConditionHelper._toColumnName(expression.getFieldName(), useSubTableNames);
                        Logger.warn(fieldName + expression.getOpType() + "null transfer to : " + fieldName + ONE_SPACE + K.isNotNull);
                    }
                }
            } else if (expression.getOpNum() == -3) {
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append(expression.getValue());
            } else {
                sqlBuffer.append(expression.getOpType());
                sqlBuffer.append("?");
                preparedValue = new PreparedValue();
                preparedValue.setType(expression.getValue().getClass().getName());
                preparedValue.setValue(expression.getValue());
                list.add(preparedValue);
            }
            isNeedAnd = true;
        }
        if (SuidType.SELECT == conditionImpl.getSuidType() && !OneTimeParameter.isTrue("_SYS_Bee_Select_Fun")) {
            Integer size = conditionImpl.getSize();
            String sql = "";
            if (start != null && size != null) {
                HoneyUtil.regPagePlaceholder();
                sql = ConditionHelper.getDbFeature().toPageSql(sqlBuffer.toString(), start.intValue(), size.intValue());
                sqlBuffer.delete(0, sqlBuffer.length());
                sqlBuffer.append(sql);
                HoneyUtil.setPageNum(list);
            } else if (size != null) {
                HoneyUtil.regPagePlaceholder();
                sql = ConditionHelper.getDbFeature().toPageSql(sqlBuffer.toString(), size.intValue());
                sqlBuffer.delete(0, sqlBuffer.length());
                sqlBuffer.append(sql);
                HoneyUtil.setPageNum(list);
            }
        }
        if (useSubTableNames == null && SuidType.SELECT == conditionImpl.getSuidType() && (isForUpdate = conditionImpl.getForUpdate()) != null && isForUpdate.booleanValue()) {
            sqlBuffer.append(ONE_SPACE + K.forUpdate + ONE_SPACE);
        }
        if (SuidType.SELECT == conditionImpl.getSuidType() && (updateSetList = conditionImpl.getUpdateExpList()) != null && updateSetList.size() > 0) {
            Logger.warn("Use Condition's set method(s) in SELECT type, but it just effect in UPDATE type! Involved field(s): " + conditionImpl.getUpdatefields());
        }
        return isFirstWhere;
    }

    static <T> String processSelectField(String columnNames, Condition condition) {
        return ConditionHelper.processSelectField(columnNames, condition, null);
    }

    static <T> String processSelectField(String columnNames, Condition condition, Map<String, String> subDulFieldMap) {
        if (condition == null) {
            return null;
        }
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        if (SuidType.SELECT != conditionImpl.getSuidType()) {
            throw new BeeErrorGrammarException(conditionImpl.getSuidType() + " do not support specifying partial fields by method selectField(String) !");
        }
        String selectField = conditionImpl.getSelectField();
        if (selectField == null) {
            return null;
        }
        return HoneyUtil.checkAndProcessSelectFieldViaString(columnNames, selectField, subDulFieldMap);
    }

    public static String processFunction(String columnNames, Condition condition) {
        ConditionImpl conditionImpl = (ConditionImpl)condition;
        List<ConditionImpl.FunExpress> funExpList = conditionImpl.getFunExpList();
        String funStr = "";
        boolean isFirst = true;
        for (int i = 0; i < funExpList.size(); ++i) {
            String columnName = "*".equals(funExpList.get(i).getField()) ? "*" : HoneyUtil.checkAndProcessSelectFieldViaString(columnNames, funExpList.get(i).getField(), null);
            if (isFirst) {
                isFirst = false;
            } else {
                funStr = funStr + ",";
            }
            String functionTypeName = funExpList.get(i).getFunctionType();
            funStr = funStr + FunAndOrderTypeMap.transfer(functionTypeName) + "(" + columnName + ")";
            String alias = funExpList.get(i).getAlias();
            if (!StringUtils.isNotBlank(alias)) continue;
            funStr = funStr + ONE_SPACE + K.as + ONE_SPACE + alias;
        }
        return funStr;
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static String _toColumnName(String fieldName, String[] useSubTableNames) {
        if (useSubTableNames == null) {
            return ConditionHelper._toColumnName(fieldName);
        }
        String t_fieldName = "";
        String t_tableName = "";
        String find_tableName = "";
        int index = fieldName.indexOf(".");
        if (index > -1) {
            t_fieldName = fieldName.substring(index + 1);
            t_tableName = fieldName.substring(0, index);
            String t_tableName_dot = fieldName.substring(0, index + 1);
            if (useSubTableNames[0] != null && useSubTableNames[0].startsWith(t_tableName_dot)) {
                find_tableName = t_tableName;
            } else if (useSubTableNames[1] != null && useSubTableNames[1].startsWith(t_tableName_dot)) {
                find_tableName = t_tableName;
            } else {
                OneTimeParameter.setTrueForKey("_SYS_Bee_DoNotCheckAnnotation");
                find_tableName = NameTranslateHandle.toTableName(t_tableName);
            }
            return find_tableName + "." + NameTranslateHandle.toColumnName(t_fieldName);
        }
        return NameTranslateHandle.toColumnName(fieldName);
    }

    private static void adjustAnd(StringBuffer sqlBuffer) {
        if (isNeedAnd) {
            sqlBuffer.append(ONE_SPACE + K.and + ONE_SPACE);
            isNeedAnd = false;
        }
    }
}

