/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.honey.distribution.ds.RouteStruct;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SessionFactory;
import org.teasoft.honey.util.ObjectUtils;

public final class HoneyContext {
    private static ConcurrentMap<String, String> beanMap;
    private static ThreadLocal<Map<String, List<PreparedValue>>> sqlPreValueLocal;
    private static ThreadLocal<Map<String, CacheSuidStruct>> cacheLocal;
    private static ThreadLocal<RouteStruct> currentRoute;
    private static ThreadLocal<Connection> currentConnection;
    private static ThreadLocal<String> sameConnctionDoing;
    private static ConcurrentMap<String, String> entity2table;
    private static ConcurrentMap<String, String> table2entity;
    private static Map<String, String> entityList_includes_Map;
    private static Map<String, String> entityList_excludes_Map;
    private static List<String> entityListWithStar_in;
    private static List<String> entityListWithStar_ex;
    private static Map<String, String> dsName2DbName;
    private static boolean configRefresh;

    private HoneyContext() {
    }

    static ConcurrentMap<String, String> getEntity2tableMap() {
        return entity2table;
    }

    static ConcurrentMap<String, String> getTable2entityMap() {
        if (table2entity == null) {
            table2entity = new ConcurrentHashMap<String, String>();
            HoneyContext.initTable2Entity();
        }
        return table2entity;
    }

    private static void initEntity2Table() {
        String entity2tableMappingList = HoneyConfig.getHoneyConfig().naming_entity2tableMappingList;
        if (entity2tableMappingList != null) {
            String[] entity2table_array = entity2tableMappingList.split(",");
            for (int i = 0; i < entity2table_array.length; ++i) {
                String[] item = entity2table_array[i].trim().split(":");
                if (item.length != 2) {
                    Logger.error("[" + entity2table_array[i].trim() + "] wrong formatter,separate option is not colon(:). (in bee.properties file, key: bee.osql.name.mapping.entity2table)");
                    continue;
                }
                entity2table.put(item[0].trim(), item[1].trim());
            }
        }
    }

    private static void initTable2Entity() {
        String entity2tableMappingList = HoneyConfig.getHoneyConfig().naming_entity2tableMappingList;
        if (entity2tableMappingList != null) {
            String[] entity2table_array = entity2tableMappingList.split(",");
            for (int i = 0; i < entity2table_array.length; ++i) {
                String[] item = entity2table_array[i].trim().split(":");
                if (item.length != 2) {
                    Logger.error("[" + entity2table_array[i].trim() + "] wrong formatter,separate option is not colon(:). (in bee.properties file, key: bee.osql.name.mapping.entity2table)");
                    continue;
                }
                if (table2entity.containsKey(item[1].trim())) {
                    Logger.warn((String)table2entity.get(item[1].trim()) + " and " + item[0].trim() + " mapping same table: " + item[1].trim());
                }
                table2entity.put(item[1].trim(), item[0].trim());
            }
        }
    }

    static String addBeanField(String key, String value) {
        return beanMap.put(key, value);
    }

    public static String getBeanField(String key) {
        return (String)beanMap.get(key);
    }

    static void clearFieldNameCache() {
        beanMap.clear();
    }

    private static boolean isShowExecutableSql() {
        return HoneyConfig.getHoneyConfig().showSql_showExecutableSql;
    }

    static void setPreparedValue(String sqlStr, List<PreparedValue> list) {
        if (list == null) {
            return;
        }
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            return;
        }
        if (list.size() == 0 && !HoneyContext.isShowExecutableSql()) {
            return;
        }
        Map<String, List<PreparedValue>> map = sqlPreValueLocal.get();
        if (null == map) {
            map = new ConcurrentHashMap<String, List<PreparedValue>>();
        }
        map.put(sqlStr, list);
        sqlPreValueLocal.set(map);
    }

    static List<PreparedValue> justGetPreparedValue(String sqlStr) {
        Map<String, List<PreparedValue>> map = sqlPreValueLocal.get();
        if (null == map) {
            return null;
        }
        List<PreparedValue> list = map.get(sqlStr);
        return list;
    }

    static void clearPreparedValue(String sqlStr) {
        Map<String, List<PreparedValue>> map = sqlPreValueLocal.get();
        if (null == map) {
            return;
        }
        List<PreparedValue> list = map.get(sqlStr);
        if (list != null) {
            map.remove(sqlStr);
        }
    }

    static List<PreparedValue> getAndClearPreparedValue(String sqlStr) {
        Map<String, List<PreparedValue>> map = sqlPreValueLocal.get();
        if (null == map) {
            return null;
        }
        List<PreparedValue> list = map.get(sqlStr);
        if (list != null) {
            map.remove(sqlStr);
        }
        return list;
    }

    static void setCacheInfo(String sqlStr, CacheSuidStruct cacheInfo) {
        if (cacheInfo == null) {
            return;
        }
        if (sqlStr == null || "".equals(sqlStr.trim())) {
            return;
        }
        Map<String, CacheSuidStruct> map = cacheLocal.get();
        if (null == map) {
            map = new ConcurrentHashMap<String, CacheSuidStruct>();
        }
        map.put(sqlStr, cacheInfo);
        cacheLocal.set(map);
    }

    public static CacheSuidStruct getCacheInfo(String sqlStr) {
        Map<String, CacheSuidStruct> map = cacheLocal.get();
        if (null == map) {
            return null;
        }
        CacheSuidStruct struct = map.get(sqlStr);
        return struct;
    }

    static void deleteCacheInfo(String sqlStr) {
        Map<String, CacheSuidStruct> map = cacheLocal.get();
        if (map != null) {
            map.remove(sqlStr);
        }
    }

    public static String getDbDialect() {
        return HoneyConfig.getHoneyConfig().getDbName();
    }

    public static Connection getCurrentConnection() {
        return currentConnection.get();
    }

    public static void setCurrentConnection(Connection conn) {
        currentConnection.set(conn);
    }

    public static void removeCurrentConnection() {
        currentConnection.remove();
    }

    private static String getSameConnctionDoing() {
        return sameConnctionDoing.get();
    }

    private static void setSameConnctionDoing() {
        sameConnctionDoing.set("tRue");
    }

    private static void removeSameConnctionDoing() {
        sameConnctionDoing.remove();
    }

    static void endSameConnection() {
        if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_BEGIN")) {
            Logger.warn("Do not get the new Connection in the SameConnection.Maybe all the results get from cache! ");
        } else if (!"tRue".equals(HoneyContext.getSameConnctionDoing())) {
            if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_EXCEPTION")) {
                Logger.warn("Do not use same Connection, because have exception in between the begin and end SameConnection !");
            } else {
                Logger.warn("Calling the endSameConnection(), but miss the beginSameConnection()");
            }
        } else if ("tRue".equals(HoneyContext.getSameConnctionDoing())) {
            OneTimeParameter.setTrueForKey("_SYS_Bee_SAME_CONN_END");
            HoneyContext.checkClose(null, HoneyContext.getCurrentConnection());
        }
        HoneyContext.removeCurrentConnection();
    }

    public static RouteStruct getCurrentRoute() {
        RouteStruct routeStruct = currentRoute.get();
        return routeStruct;
    }

    public static void setCurrentRoute(RouteStruct routeStruct) {
        currentRoute.set(routeStruct);
    }

    public static void removeCurrentRoute() {
        currentRoute.remove();
    }

    static void setContext(String sql, List<PreparedValue> list, String tableName) {
        HoneyContext.setPreparedValue(sql, list);
        HoneyContext.addInContextForCache(sql, tableName);
    }

    static void addInContextForCache(String sql, String tableName) {
        CacheSuidStruct struct = new CacheSuidStruct();
        struct.setSql(sql);
        struct.setTableNames(tableName);
        HoneyContext.setCacheInfo(sql, struct);
    }

    static void regEntityClass(Class clazz) {
        OneTimeParameter.setAttribute("_SYS_Bee_ROUTE_EC", clazz);
    }

    static Connection getConn() throws SQLException {
        Connection conn = null;
        conn = HoneyContext.getCurrentConnection();
        if (conn == null) {
            conn = SessionFactory.getConnection();
            if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_BEGIN")) {
                HoneyContext.setCurrentConnection(conn);
                HoneyContext.setSameConnctionDoing();
            }
        }
        return conn;
    }

    static void closeConn(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw ExceptionHelper.convert(e);
        }
        finally {
            HoneyContext.removeCurrentConnection();
            if ("tRue".equals(HoneyContext.getSameConnctionDoing())) {
                HoneyContext.removeSameConnctionDoing();
                OneTimeParameter.setTrueForKey("_SYS_Bee_SAME_CONN_EXCEPTION");
            }
            boolean enableMultiDs = HoneyConfig.getHoneyConfig().multiDS_enable;
            int multiDsType = HoneyConfig.getHoneyConfig().multiDS_type;
            if (enableMultiDs && multiDsType == 2) {
                HoneyContext.removeCurrentRoute();
            }
        }
    }

    public static void checkClose(Statement stmt, Connection conn) {
        HoneyContext.checkClose(null, stmt, conn);
    }

    public static void checkClose(ResultSet rs, Statement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw ExceptionHelper.convert(e);
            }
        }
        if (conn != null) {
            try {
                if ("tRue".equals(HoneyContext.getSameConnctionDoing())) {
                    if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_END")) {
                        HoneyContext.removeSameConnctionDoing();
                        if (conn != null) {
                            conn.close();
                        }
                    }
                } else if (conn != null && conn.getAutoCommit()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                Logger.debug(e.getMessage());
                throw ExceptionHelper.convert(e);
            }
            finally {
                boolean enableMultiDs = HoneyConfig.getHoneyConfig().multiDS_enable;
                int multiDsType = HoneyConfig.getHoneyConfig().multiDS_type;
                if (enableMultiDs && multiDsType == 2) {
                    HoneyContext.removeCurrentRoute();
                }
            }
        }
    }

    static boolean updateInfoInCache(String sql, String returnType, SuidType suidType) {
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            struct.setReturnType(returnType);
            struct.setSuidType(suidType.getType());
            HoneyContext.setCacheInfo(sql, struct);
            return true;
        }
        return false;
    }

    static void initRoute(SuidType suidType, Class clazz, String sql) {
        if (clazz == null) {
            clazz = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        }
        RouteStruct routeStruct = new RouteStruct();
        routeStruct.setSuidType(suidType);
        routeStruct.setEntityClass(clazz);
        CacheSuidStruct struct = HoneyContext.getCacheInfo(sql);
        if (struct != null) {
            routeStruct.setTableNames(struct.getTableNames());
        }
        HoneyContext.setCurrentRoute(routeStruct);
    }

    static void initRouteWhenParseSql(SuidType suidType, Class clazz, String tableNames) {
        if (clazz == null) {
            clazz = (Class)OneTimeParameter.getAttribute("_SYS_Bee_ROUTE_EC");
        }
        RouteStruct routeStruct = new RouteStruct();
        routeStruct.setSuidType(suidType);
        routeStruct.setEntityClass(clazz);
        routeStruct.setTableNames(tableNames);
        HoneyContext.setCurrentRoute(routeStruct);
    }

    private static void parseEntityListToMap() {
        String entityList_includes = HoneyConfig.getHoneyConfig().genid_includesEntityList;
        HoneyContext._parseListToMap(entityList_includes, entityList_includes_Map, entityListWithStar_in);
        String entityList_excludes = HoneyConfig.getHoneyConfig().genid_excludesEntityList;
        HoneyContext._parseListToMap(entityList_excludes, entityList_excludes_Map, entityListWithStar_ex);
    }

    private static void _parseListToMap(String str, Map<String, String> map, List<String> starList) {
        if (str == null || "".equals(str.trim())) {
            return;
        }
        String[] strArray = str.trim().split(",");
        for (int k = 0; k < strArray.length; ++k) {
            if (strArray[k].trim().endsWith(".**")) {
                starList.add(strArray[k].trim());
            }
            map.put(strArray[k].trim(), "1");
        }
    }

    private static boolean isConfigForEntityIN(Class clazz) {
        return HoneyContext._isConfig(clazz, entityList_includes_Map, entityListWithStar_in);
    }

    private static boolean isConfigForEntityEX(Class clazz) {
        return HoneyContext._isConfig(clazz, entityList_excludes_Map, entityListWithStar_ex);
    }

    private static boolean _isConfig(Class clazz, Map<String, String> map, List<String> starList) {
        String fullName = clazz.getName();
        String ds = null;
        ds = map.get(fullName);
        if (ds != null) {
            return true;
        }
        if (clazz.getPackage() != null) {
            String packageName = clazz.getPackage().getName();
            ds = map.get(packageName + ".*");
            if (ds != null) {
                return true;
            }
            for (int i = 0; i < starList.size(); ++i) {
                String prePath;
                String s = starList.get(i);
                if (!s.endsWith(".**") || !fullName.startsWith(prePath = s.substring(0, s.length() - 2))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNeedGenId(Class clazz) {
        boolean needGenId = false;
        boolean genAll = HoneyConfig.getHoneyConfig().genid_forAllTableLongId;
        needGenId = genAll ? !HoneyContext.isConfigForEntityEX(clazz) : (HoneyContext.isConfigForEntityEX(clazz) ? false : HoneyContext.isConfigForEntityIN(clazz));
        return needGenId;
    }

    static boolean isNeedRealTimeDb() {
        boolean enableMultiDs = HoneyConfig.getHoneyConfig().multiDS_enable;
        if (enableMultiDs) {
            int multiDsType = HoneyConfig.getHoneyConfig().multiDS_type;
            boolean supportDifferentDbType = HoneyConfig.getHoneyConfig().multiDS_differentDbType;
            if (multiDsType == 2 && supportDifferentDbType) {
                return true;
            }
        }
        return false;
    }

    static String getRealTimeDbName() {
        String dbName = null;
        if (HoneyContext.isNeedRealTimeDb()) {
            return HoneyConfig.getHoneyConfig().getDbName();
        }
        return dbName;
    }

    static boolean isAlreadySetRoute() {
        return OneTimeParameter.isTrue("_SYS_Bee_ALREADY_SET_ROUTE");
    }

    public static Map<String, String> getDsName2DbName() {
        return dsName2DbName;
    }

    public static void setDsName2DbName(Map<String, String> dsName2DbName) {
        HoneyContext.dsName2DbName = dsName2DbName;
    }

    public static boolean isConfigRefresh() {
        return configRefresh;
    }

    public static void setConfigRefresh(boolean configRefresh) {
        HoneyContext.configRefresh = configRefresh;
    }

    public static void updateConfig(Map<String, Object> map) {
        if (ObjectUtils.isEmpty(map)) {
            return;
        }
        HoneyConfig obj = HoneyConfig.getHoneyConfig();
        Class<?> clazz = obj.getClass();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                Field field = clazz.getDeclaredField(entry.getKey());
                field.setAccessible(true);
                field.set(obj, entry.getValue());
            }
            catch (Exception e) {
                throw ExceptionHelper.convert(e);
            }
        }
        HoneyContext.setConfigRefresh(true);
    }

    static {
        table2entity = null;
        entityList_includes_Map = new ConcurrentHashMap<String, String>();
        entityList_excludes_Map = new ConcurrentHashMap<String, String>();
        entityListWithStar_in = new CopyOnWriteArrayList<String>();
        entityListWithStar_ex = new CopyOnWriteArrayList<String>();
        beanMap = new ConcurrentHashMap<String, String>();
        sqlPreValueLocal = new ThreadLocal();
        cacheLocal = new ThreadLocal();
        currentConnection = new ThreadLocal();
        sameConnctionDoing = new ThreadLocal();
        currentRoute = new ThreadLocal();
        entity2table = new ConcurrentHashMap<String, String>();
        HoneyContext.initEntity2Table();
        HoneyContext.parseEntityListToMap();
        configRefresh = false;
    }
}

