/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeException;
import org.teasoft.bee.osql.MapSql;
import org.teasoft.bee.osql.MapSqlKey;
import org.teasoft.bee.osql.MapSqlSetting;
import org.teasoft.bee.osql.exception.BeeIllegalBusinessException;
import org.teasoft.honey.distribution.GenIdFactory;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.K;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MapSqlImpl;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.util.ObjectUtils;
import org.teasoft.honey.util.StringUtils;

public class MapSqlProcessor {
    public static String toSelectSqlByMap(MapSql mapSql) {
        String orderByStr;
        String havingStr;
        String groupByField;
        MapSqlImpl suidMapImpl = (MapSqlImpl)mapSql;
        Map<MapSqlKey, String> sqlkeyMap = suidMapImpl.getSqlkeyMap();
        Map<String, Object> whereConditonMap = suidMapImpl.getKvMap();
        Map<MapSqlSetting, Boolean> sqlSettingMap = suidMapImpl.getSqlSettingMap();
        String tableName = sqlkeyMap.get(MapSqlKey.Table);
        MapSqlProcessor.checkTable(tableName);
        String selectColumns = sqlkeyMap.get(MapSqlKey.SelectColumns);
        Boolean isTransfer = sqlSettingMap.get(MapSqlSetting.IsNamingTransfer);
        if (isTransfer == null) {
            isTransfer = false;
        }
        if (isTransfer.booleanValue()) {
            selectColumns = MapSqlProcessor._toColumnName(selectColumns);
            OneTimeParameter.setTrueForKey("_SYS_Bee_DoNotCheckAnnotation");
            tableName = MapSqlProcessor._toTableName(tableName);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(K.select).append(K.space).append(selectColumns).append(K.space).append(K.from).append(K.space).append(tableName);
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        if (ObjectUtils.isNotEmpty(whereConditonMap)) {
            MapSqlProcessor.where(whereConditonMap, list, sqlBuffer, isTransfer, MapSqlProcessor.getIncludeType(sqlSettingMap));
        }
        if (StringUtils.isNotBlank(groupByField = sqlkeyMap.get(MapSqlKey.GroupBy))) {
            sqlBuffer.append(K.space).append(K.groupBy).append(K.space).append(groupByField);
        }
        if (StringUtils.isNotBlank(havingStr = sqlkeyMap.get(MapSqlKey.Having))) {
            sqlBuffer.append(K.space).append(K.having).append(K.space).append(havingStr);
        }
        if (StringUtils.isNotBlank(orderByStr = sqlkeyMap.get(MapSqlKey.OrderBy))) {
            sqlBuffer.append(K.space).append(K.orderBy).append(K.space).append(orderByStr);
        }
        String sql = sqlBuffer.toString();
        MapSqlProcessor.setContext(sql, list, tableName);
        return sql;
    }

    private static int getIncludeType(Map<MapSqlSetting, Boolean> sqlSettingMap) {
        int includeType = -1;
        boolean f1 = false;
        boolean f2 = false;
        Boolean isIncludeNull = sqlSettingMap.get(MapSqlSetting.IsIncludeNull);
        Boolean isIncludeEmptyString = sqlSettingMap.get(MapSqlSetting.IsIncludeEmptyString);
        if (isIncludeNull != null && isIncludeNull.booleanValue()) {
            includeType = 0;
            f1 = true;
        }
        if (isIncludeEmptyString != null && isIncludeEmptyString.booleanValue()) {
            includeType = 1;
            f2 = true;
        }
        if (f1 && f2) {
            includeType = 2;
        }
        return includeType;
    }

    public static String toDeleteSqlByMap(MapSql mapSql) {
        boolean notDeleteWholeRecords;
        MapSqlImpl suidMapImpl = (MapSqlImpl)mapSql;
        Map<MapSqlKey, String> sqlkeyMap = suidMapImpl.getSqlkeyMap();
        Map<String, Object> whereConditonMap = suidMapImpl.getKvMap();
        Map<MapSqlSetting, Boolean> sqlSettingMap = suidMapImpl.getSqlSettingMap();
        String tableName = sqlkeyMap.get(MapSqlKey.Table);
        MapSqlProcessor.checkTable(tableName);
        Boolean isTransfer = sqlSettingMap.get(MapSqlSetting.IsNamingTransfer);
        if (isTransfer == null) {
            isTransfer = false;
        }
        if (isTransfer.booleanValue()) {
            OneTimeParameter.setTrueForKey("_SYS_Bee_DoNotCheckAnnotation");
            tableName = MapSqlProcessor._toTableName(tableName);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(K.delete).append(K.space).append(K.from).append(K.space).append(tableName);
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        boolean firstWhere = false;
        if (ObjectUtils.isNotEmpty(whereConditonMap)) {
            firstWhere = MapSqlProcessor.where(whereConditonMap, list, sqlBuffer, isTransfer, MapSqlProcessor.getIncludeType(sqlSettingMap));
        }
        String sql = sqlBuffer.toString();
        if (firstWhere && (notDeleteWholeRecords = HoneyConfig.getHoneyConfig().notDeleteWholeRecords)) {
            Logger.logSQL("In MapSuid, delete SQL: ", sql);
            throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed delete whole records in one table.");
        }
        MapSqlProcessor.setContext(sql, list, tableName);
        return sql;
    }

    public static String toInsertSqlByMap(MapSql mapSql) {
        MapSqlImpl suidMapImpl = (MapSqlImpl)mapSql;
        Map<MapSqlKey, String> sqlkeyMap = suidMapImpl.getSqlkeyMap();
        Map<String, Object> insertKvMap = suidMapImpl.getKvMap();
        Map<MapSqlSetting, Boolean> sqlSettingMap = suidMapImpl.getSqlSettingMap();
        String tableName = sqlkeyMap.get(MapSqlKey.Table);
        MapSqlProcessor.checkTable(tableName);
        Boolean isTransfer = sqlSettingMap.get(MapSqlSetting.IsNamingTransfer);
        if (isTransfer == null) {
            isTransfer = false;
        }
        if (isTransfer.booleanValue()) {
            OneTimeParameter.setTrueForKey("_SYS_Bee_DoNotCheckAnnotation");
            tableName = MapSqlProcessor._toTableName(tableName);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(K.insert).append(K.space).append(K.into).append(K.space).append(tableName);
        Object oldId = null;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        if (!ObjectUtils.isNotEmpty(insertKvMap)) {
            throw new BeeException("Must set the insert vlaue with MapSql.put(String fieldName, Object value) !");
        }
        oldId = MapSqlProcessor.processId(insertKvMap, tableName);
        MapSqlProcessor.toInsertSql(insertKvMap, list, sqlBuffer, isTransfer, MapSqlProcessor.getIncludeType(sqlSettingMap));
        String sql = sqlBuffer.toString();
        MapSqlProcessor.setContext(sql, list, tableName);
        MapSqlProcessor.revertId(insertKvMap, oldId);
        return sql;
    }

    private static void checkTable(String tableName) {
        if (StringUtils.isBlank(tableName)) {
            throw new BeeException("The Map which key is SqlMapKey.Table must define!");
        }
    }

    private static Object processId(Map<String, Object> insertKvMap, String tableName) {
        Object id = insertKvMap.get("id");
        boolean isUpper = false;
        if (id == null) {
            id = insertKvMap.get("ID");
            isUpper = true;
        }
        boolean genAll = HoneyConfig.getHoneyConfig().genid_forAllTableLongId;
        boolean replaceOldValue = HoneyConfig.getHoneyConfig().genid_replaceOldId;
        if (id != null) {
            if (genAll && replaceOldValue) {
                long newId = GenIdFactory.get(tableName);
                if (isUpper) {
                    insertKvMap.put("ID", newId);
                } else {
                    insertKvMap.put("id", newId);
                }
                OneTimeParameter.setAttribute("_SYS_Bee_MapSuid_Insert_Has_ID", newId);
            } else {
                OneTimeParameter.setAttribute("_SYS_Bee_MapSuid_Insert_Has_ID", id);
            }
        } else if (genAll) {
            long newId = GenIdFactory.get(tableName);
            insertKvMap.put("id", newId);
            OneTimeParameter.setAttribute("_SYS_Bee_MapSuid_Insert_Has_ID", newId);
        }
        return id;
    }

    private static void revertId(Map<String, Object> insertKvMap, Object oldId) {
        Object id = insertKvMap.get("id");
        if (id != null) {
            if (oldId == null) {
                insertKvMap.remove("id");
            } else {
                insertKvMap.put("id", oldId);
            }
        } else {
            id = insertKvMap.get("ID");
            if (id != null) {
                if (oldId == null) {
                    insertKvMap.remove("ID");
                } else {
                    insertKvMap.put("ID", oldId);
                }
            }
        }
    }

    private static boolean where(Map<String, Object> whereConditonMap, List<PreparedValue> list, StringBuffer sqlBuffer, boolean isTransfer, int includeType) {
        boolean firstWhere = true;
        PreparedValue preparedValue = null;
        for (Map.Entry<String, Object> entry : whereConditonMap.entrySet()) {
            Object value = entry.getValue();
            if (HoneyUtil.isContinue(includeType, value, null)) continue;
            if (firstWhere) {
                sqlBuffer.append(K.space).append(K.where).append(K.space);
                firstWhere = false;
            } else {
                sqlBuffer.append(K.space).append(K.and).append(K.space);
            }
            if (isTransfer) {
                sqlBuffer.append(MapSqlProcessor._toColumnName(entry.getKey()));
            } else {
                sqlBuffer.append(entry.getKey());
            }
            if (value == null) {
                sqlBuffer.append(" ").append(K.isNull);
                continue;
            }
            sqlBuffer.append("=");
            sqlBuffer.append("?");
            preparedValue = new PreparedValue();
            preparedValue.setType(entry.getValue().getClass().getSimpleName());
            preparedValue.setValue(entry.getValue());
            list.add(preparedValue);
        }
        return firstWhere;
    }

    private static void toInsertSql(Map<String, Object> insertKvMap, List<PreparedValue> list, StringBuffer sqlBuffer, boolean isTransfer, int includeType) {
        StringBuffer sqlValue = new StringBuffer(" (");
        boolean isFirst = true;
        sqlBuffer.append(" (");
        PreparedValue preparedValue = null;
        for (Map.Entry<String, Object> entry : insertKvMap.entrySet()) {
            Object value = entry.getValue();
            if (HoneyUtil.isContinue(includeType, value, null)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sqlBuffer.append(",");
                sqlValue.append(",");
            }
            if (isTransfer) {
                sqlBuffer.append(MapSqlProcessor._toColumnName(entry.getKey()));
            } else {
                sqlBuffer.append(entry.getKey());
            }
            sqlValue.append("?");
            preparedValue = new PreparedValue();
            if (value == null) {
                preparedValue.setType(Object.class.getSimpleName());
            } else {
                preparedValue.setType(value.getClass().getSimpleName());
            }
            preparedValue.setValue(value);
            list.add(preparedValue);
        }
        sqlValue.append(")");
        sqlBuffer.append(") ").append(K.values);
        sqlBuffer.append(sqlValue);
    }

    private static void setContext(String sql, List<PreparedValue> list, String tableName) {
        HoneyContext.setContext(sql, list, tableName);
    }

    private static String _toTableName(String tableName) {
        return NameTranslateHandle.toTableName(tableName);
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }
}

