/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.MapSql;
import org.teasoft.bee.osql.MapSuid;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.MapSqlProcessor;
import org.teasoft.honey.osql.core.OneTimeParameter;
import org.teasoft.honey.util.ObjectUtils;

public class MapSuidImpl
implements MapSuid {
    private BeeSql beeSql;

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public List<String[]> selectString(MapSql mapSql) {
        String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
        Logger.logSQL("In MapSuid, List<String[]> select SQL: ", sql);
        return this.getBeeSql().select(sql);
    }

    public String selectJson(MapSql mapSql) {
        String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
        Logger.logSQL("In MapSuid, selectJson SQL: ", sql);
        return this.getBeeSql().selectJson(sql);
    }

    public List<Map<String, Object>> select(MapSql mapSql) {
        String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
        Logger.logSQL("In MapSuid, selectMap SQL: ", sql);
        return this.getBeeSql().selectMapList(sql);
    }

    public Map<String, Object> selectOne(MapSql mapSql) {
        String sql = MapSqlProcessor.toSelectSqlByMap(mapSql);
        Logger.logSQL("In MapSuid, selectOneMap SQL: ", sql);
        List list = this.getBeeSql().selectMapList(sql);
        if (ObjectUtils.isNotEmpty(list)) {
            return (Map)list.get(0);
        }
        return Collections.emptyMap();
    }

    public int delete(MapSql mapSql) {
        String sql = MapSqlProcessor.toDeleteSqlByMap(mapSql);
        Logger.logSQL("In MapSuid, delete SQL: ", sql);
        return this.getBeeSql().modify(sql);
    }

    public long insert(MapSql mapSql) {
        long newId;
        if (mapSql == null) {
            return -1L;
        }
        String sql = MapSqlProcessor.toInsertSqlByMap(mapSql);
        Logger.logSQL("In MapSuid, insert SQL: ", sql);
        Object obj = OneTimeParameter.getAttribute("_SYS_Bee_MapSuid_Insert_Has_ID");
        if (obj != null) {
            newId = Long.parseLong(obj.toString());
            if (newId > 1L) {
                int insertNum = this.getBeeSql().modify(sql);
                if (insertNum == 1) {
                    return newId;
                }
                return insertNum;
            }
            if (HoneyUtil.isOracle()) {
                Logger.debug("Need create Sequence and Trigger for auto increment id. By the way,maybe use distribute id is better!");
            }
        }
        newId = this.getBeeSql().insertAndReturnId(sql);
        return newId;
    }
}

