/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.MoreObjToSQL;
import org.teasoft.bee.osql.MoreTable;
import org.teasoft.bee.osql.exception.BeeIllegalParameterException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;

public class MoreObjSQL
implements MoreTable {
    private BeeSql beeSql;
    private MoreObjToSQL moreObjToSQL;

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public MoreObjToSQL getMoreObjToSQL() {
        if (this.moreObjToSQL == null) {
            return BeeFactory.getHoneyFactory().getMoreObjToSQL();
        }
        return this.moreObjToSQL;
    }

    public void setMoreObjToSQL(MoreObjToSQL moreObjToSQL) {
        this.moreObjToSQL = moreObjToSQL;
    }

    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        String sql = this.getMoreObjToSQL().toSelectSQL(entity);
        Logger.logSQL("select SQL: ", sql);
        return this.getBeeSql().moreTableSelect(sql, entity);
    }

    public <T> List<T> select(T entity, int start, int size) {
        if (entity == null) {
            return null;
        }
        if (size <= 0) {
            throw new BeeIllegalParameterException("Parameter 'size' need great than 0!");
        }
        if (start < 0) {
            throw new BeeIllegalParameterException("Parameter 'start' need great equal 0!");
        }
        String sql = this.getMoreObjToSQL().toSelectSQL(entity, start, size);
        Logger.logSQL("select SQL: ", sql);
        return this.getBeeSql().moreTableSelect(sql, entity);
    }

    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        String sql = this.getMoreObjToSQL().toSelectSQL(entity, condition);
        Logger.logSQL("select SQL: ", sql);
        return this.getBeeSql().moreTableSelect(sql, entity);
    }

    public MoreObjSQL setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }
}

