/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.List;
import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.ObjToSQL;
import org.teasoft.bee.osql.Suid;
import org.teasoft.bee.osql.exception.NotSupportedException;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.OneTimeParameter;

public class ObjSQL
implements Suid {
    private BeeSql beeSql;
    private ObjToSQL objToSQL;

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            this.beeSql = BeeFactory.getHoneyFactory().getBeeSql();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public ObjToSQL getObjToSQL() {
        if (this.objToSQL == null) {
            this.objToSQL = BeeFactory.getHoneyFactory().getObjToSQL();
        }
        return this.objToSQL;
    }

    public void setObjToSQL(ObjToSQL objToSQL) {
        this.objToSQL = objToSQL;
    }

    public <T> List<T> select(T entity) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQL().toSelectSQL(entity);
        Logger.logSQL("select SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> int update(T entity) {
        if (entity == null) {
            return -1;
        }
        String sql = "";
        int updateNum = -1;
        sql = this.getObjToSQL().toUpdateSQL(entity);
        Logger.logSQL("update SQL: ", sql);
        this._regEntityClass(entity);
        updateNum = this.getBeeSql().modify(sql);
        return updateNum;
    }

    public <T> int insert(T entity) {
        if (entity == null) {
            return -1;
        }
        String sql = this.getObjToSQL().toInsertSQL(entity);
        int insertNum = -1;
        Logger.logSQL("insert SQL: ", sql);
        this._regEntityClass(entity);
        HoneyUtil.revertId(entity);
        insertNum = this.getBeeSql().modify(sql);
        return insertNum;
    }

    public <T> long insertAndReturnId(T entity) {
        if (entity == null) {
            return -1L;
        }
        if (!(HoneyContext.isNeedGenId(entity.getClass()) || HoneyUtil.isMysql() || HoneyUtil.isOracle() || HoneyUtil.isSQLite())) {
            throw new NotSupportedException("The current database don't support return the id after insert. You can use the distribute id via set config information,eg: bee.distribution.genid.forAllTableLongId=true");
        }
        String sql = this.getObjToSQL().toInsertSQL(entity);
        Logger.logSQL("insert SQL: ", sql);
        this._regEntityClass(entity);
        Object obj = HoneyUtil.getIdValue(entity);
        HoneyUtil.revertId(entity);
        long returnId = -1L;
        if (obj != null) {
            returnId = Long.parseLong(obj.toString());
            if (returnId > 1L) {
                int insertNum = this.getBeeSql().modify(sql);
                if (insertNum == 1) {
                    return returnId;
                }
                return insertNum;
            }
            if (HoneyUtil.isOracle()) {
                Logger.debug("Need create Sequence and Trigger for auto increment id. By the way,maybe use distribute id is better!");
            }
        }
        returnId = this.getBeeSql().insertAndReturnId(sql);
        return returnId;
    }

    public int delete(Object entity) {
        if (entity == null) {
            return -1;
        }
        String sql = this.getObjToSQL().toDeleteSQL(entity);
        int deleteNum = -1;
        Logger.logSQL("delete SQL: ", sql);
        this._regEntityClass(entity);
        deleteNum = this.getBeeSql().modify(sql);
        return deleteNum;
    }

    public <T> List<T> select(T entity, Condition condition) {
        if (entity == null) {
            return null;
        }
        List list = null;
        String sql = this.getObjToSQL().toSelectSQL(entity, condition);
        Logger.logSQL("select SQL: ", sql);
        list = this.getBeeSql().select(sql, entity);
        return list;
    }

    public <T> int delete(T entity, Condition condition) {
        if (entity == null) {
            return -1;
        }
        String sql = this.getObjToSQL().toDeleteSQL(entity, condition);
        int deleteNum = -1;
        if (!"".equals(sql)) {
            Logger.logSQL("delete SQL: ", sql);
        }
        this._regEntityClass(entity);
        deleteNum = this.getBeeSql().modify(sql);
        return deleteNum;
    }

    public Suid setDynamicParameter(String para, String value) {
        OneTimeParameter.setAttribute(para, value);
        return this;
    }

    private <T> void _regEntityClass(T entity) {
        HoneyContext.regEntityClass(entity.getClass());
    }

    public void beginSameConnection() {
        OneTimeParameter.setTrueForKey("_SYS_Bee_SAME_CONN_BEGIN");
        if (OneTimeParameter.isTrue("_SYS_Bee_SAME_CONN_EXCEPTION")) {
            Logger.warn("Last SameConnection do not have endSameConnection() or do not run endSameConnection() after having exception.");
        }
    }

    public void endSameConnection() {
        HoneyContext.endSameConnection();
    }
}

